/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.ProcessEngineImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobAcquisitionContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobAcquisitionStrategy;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.SequentialJobAcquisitionRunnable;
import org.eximeebpms.bpm.engine.test.jobexecutor.ControllableJobExecutor;

public class RecordingAcquireJobsRunnable
extends SequentialJobAcquisitionRunnable {
    protected List<RecordedWaitEvent> waitEvents = new ArrayList<RecordedWaitEvent>();
    protected List<RecordedAcquisitionEvent> acquisitionEvents = new ArrayList<RecordedAcquisitionEvent>();

    public RecordingAcquireJobsRunnable(ControllableJobExecutor jobExecutor) {
        super((JobExecutor)jobExecutor);
    }

    protected void suspendAcquisition(long millis) {
        ControllableJobExecutor controllableExecutor;
        this.LOG.debugJobAcquisitionThreadSleeping(millis);
        if (this.jobExecutor instanceof ControllableJobExecutor && (controllableExecutor = (ControllableJobExecutor)this.jobExecutor).isSyncAsSuspendEnabled()) {
            controllableExecutor.getAcquisitionThreadControl().sync();
        }
    }

    protected AcquiredJobs acquireJobs(JobAcquisitionContext context, JobAcquisitionStrategy configuration, ProcessEngineImpl currentProcessEngine) {
        this.acquisitionEvents.add(new RecordedAcquisitionEvent(System.currentTimeMillis(), configuration.getNumJobsToAcquire(currentProcessEngine.getName())));
        return super.acquireJobs(context, configuration, currentProcessEngine);
    }

    protected void configureNextAcquisitionCycle(JobAcquisitionContext acquisitionContext, JobAcquisitionStrategy acquisitionStrategy) {
        super.configureNextAcquisitionCycle(acquisitionContext, acquisitionStrategy);
        long timeBetweenCurrentAndNextAcquisition = acquisitionStrategy.getWaitTime();
        this.waitEvents.add(new RecordedWaitEvent(System.currentTimeMillis(), timeBetweenCurrentAndNextAcquisition, acquisitionContext.getAcquisitionException()));
    }

    public List<RecordedWaitEvent> getWaitEvents() {
        return this.waitEvents;
    }

    public List<RecordedAcquisitionEvent> getAcquisitionEvents() {
        return this.acquisitionEvents;
    }

    public static class RecordedAcquisitionEvent {
        protected long timestamp;
        protected int numJobsToAcquire;

        public RecordedAcquisitionEvent(long timestamp, int numJobsToAcquire) {
            this.timestamp = timestamp;
            this.numJobsToAcquire = numJobsToAcquire;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getNumJobsToAcquire() {
            return this.numJobsToAcquire;
        }
    }

    public static class RecordedWaitEvent {
        protected long timestamp;
        protected long timeBetweenAcquisitions;
        protected Exception acquisitionException;

        public RecordedWaitEvent(long timestamp, long timeBetweenAcquisitions, Exception acquisitionException) {
            this.timestamp = timestamp;
            this.timeBetweenAcquisitions = timeBetweenAcquisitions;
            this.acquisitionException = acquisitionException;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getTimeBetweenAcquisitions() {
            return this.timeBetweenAcquisitions;
        }

        public Exception getAcquisitionException() {
            return this.acquisitionException;
        }
    }
}

