/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.calendar.CycleBusinessCalendar;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CycleBusinessCalendarTest {
    @After
    public void tearDown() {
        ClockUtil.reset();
    }

    @Test
    public void testSimpleCron() throws Exception {
        CycleBusinessCalendar businessCalendar = new CycleBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2011 03 11 - 17:23");
        ClockUtil.setCurrentTime((Date)now);
        Date duedate = businessCalendar.resolveDuedate("0 0 0 1 * ?");
        Date expectedDuedate = simpleDateFormat.parse("2011 04 1 - 00:00");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }

    @Test
    public void testSimpleDuration() throws Exception {
        CycleBusinessCalendar businessCalendar = new CycleBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2010 06 11 - 17:23");
        ClockUtil.setCurrentTime((Date)now);
        Date duedate = businessCalendar.resolveDuedate("R/P2DT5H70M");
        Date expectedDuedate = simpleDateFormat.parse("2010 06 13 - 23:33");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }

    @Test
    public void testSimpleCronWithStartDate() throws Exception {
        CycleBusinessCalendar businessCalendar = new CycleBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2011 03 11 - 17:23");
        Date duedate = businessCalendar.resolveDuedate("0 0 0 1 * ?", now);
        Date expectedDuedate = simpleDateFormat.parse("2011 04 1 - 00:00");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }

    @Test
    public void testSimpleDurationWithStartDate() throws Exception {
        CycleBusinessCalendar businessCalendar = new CycleBusinessCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd - HH:mm");
        Date now = simpleDateFormat.parse("2010 06 11 - 17:23");
        Date duedate = businessCalendar.resolveDuedate("R/P2DT5H70M", now);
        Date expectedDuedate = simpleDateFormat.parse("2010 06 13 - 23:33");
        Assert.assertEquals((Object)expectedDuedate, (Object)duedate);
    }

    @Test
    public void testResolveDueDate() throws Exception {
        CycleBusinessCalendar cbc = new CycleBusinessCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy MM dd HH:mm");
        Date startDate = sdf.parse("2010 02 11 17:23");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 * * * ?", startDate))).isEqualTo((Object)"2010 02 11 18:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("*/10 * * * 2 ?", startDate))).isEqualTo((Object)"2010 02 11 17:23");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 8-10 * * ?", startDate))).isEqualTo((Object)"2010 02 12 08:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0/30 8-10 * * ?", startDate))).isEqualTo((Object)"2010 02 12 08:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 9-17 * * ?", startDate))).isEqualTo((Object)"2010 02 12 09:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 0 25 12 ?", startDate))).isEqualTo((Object)"2010 12 25 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 0 L 12 ?", startDate))).isEqualTo((Object)"2010 12 31 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 * 1|2 * ?", startDate))).isEqualTo((Object)"2010 03 01 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 6,19 * * ?", startDate))).isEqualTo((Object)"2010 02 11 19:00");
    }

    @Test
    public void testSpecialCharactersResolveDueDate() throws Exception {
        CycleBusinessCalendar cbc = new CycleBusinessCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy MM dd HH:mm");
        Date startDate = sdf.parse("2010 02 11 17:23");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 0 * * THUL", startDate))).isEqualTo((Object)"2010 02 25 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 0 1W * *", startDate))).isEqualTo((Object)"2010 03 01 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 0 ? * 5#2", startDate))).isEqualTo((Object)"2010 02 12 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("@monthly", startDate))).isEqualTo((Object)"2010 03 01 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("@annually", startDate))).isEqualTo((Object)"2011 01 01 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("@yearly", startDate))).isEqualTo((Object)"2011 01 01 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("@weekly", startDate))).isEqualTo((Object)"2010 02 14 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("@daily", startDate))).isEqualTo((Object)"2010 02 12 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("@midnight", startDate))).isEqualTo((Object)"2010 02 12 00:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("@hourly", startDate))).isEqualTo((Object)"2010 02 11 18:00");
    }

    @Test
    public void testEndOfMonthRelativeExpressions() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy MM dd HH:mm");
        CycleBusinessCalendar cbc = new CycleBusinessCalendar();
        Date startDate = sdf.parse("2025 02 14 12:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 37 14 L-22 * ?", startDate))).isEqualTo((Object)"2025 03 09 14:37");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 23 8 L-2 * ?", startDate))).isEqualTo((Object)"2025 02 26 08:23");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 37 8 L-1 * ?", startDate))).isEqualTo((Object)"2025 02 27 08:37");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 12 L-15 * ?", startDate))).isEqualTo((Object)"2025 03 16 12:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 0 12 L-27 * ?", startDate))).isEqualTo((Object)"2025 03 04 12:00");
        startDate = sdf.parse("2000 02 26 10:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 15 10 L-3 2 ?", startDate))).isEqualTo((Object)"2000 02 26 10:15");
        startDate = sdf.parse("2000 02 27 10:00");
        Assertions.assertThat((String)sdf.format(cbc.resolveDuedate("0 15 10 L-3 2 ?", startDate))).isEqualTo((Object)"2001 02 25 10:15");
    }

    @Test
    public void testTooManyArgumentExpressions() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy MM dd HH:mm");
        CycleBusinessCalendar cbc = new CycleBusinessCalendar();
        Date startDate = sdf.parse("2025 02 14 12:00");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> cbc.resolveDuedate("0 15 10 * * ? 2025 *", startDate)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Exception while parsing cycle expression");
    }
}

