/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.UserOperationLogQuery;
import org.eximeebpms.bpm.engine.impl.ManagementServiceImpl;
import org.eximeebpms.bpm.engine.impl.RuntimeServiceImpl;
import org.eximeebpms.bpm.engine.impl.TaskServiceImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestBaseRule;
import org.eximeebpms.bpm.engine.test.standalone.history.CustomHistoryLevelFullWithoutUserOperationLog;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CustomHistoryLevelWithoutUserOperationLogTest {
    public static final String USER_ID = "demo";
    private static final String ONE_TASK_PROCESS = "org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String ONE_TASK_CASE = "org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    static HistoryLevel customHistoryLevelFullWUOL = new CustomHistoryLevelFullWithoutUserOperationLog();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setJdbcUrl("jdbc:h2:mem:CustomHistoryLevelWithoutUserOperationLogTest");
        configuration.setCustomHistoryLevels(Arrays.asList(customHistoryLevelFullWUOL));
        configuration.setHistory("aCustomHistoryLevelWUOL");
        configuration.setDatabaseSchemaUpdate("create-drop");
    });
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public AuthorizationTestBaseRule authRule = new AuthorizationTestBaseRule(this.engineRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected ManagementServiceImpl managementService;
    protected IdentityService identityService;
    protected RepositoryService repositoryService;
    protected TaskService taskService;
    protected CaseService caseService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ProcessInstance process;
    protected Task userTask;
    protected String processTaskId;

    @Before
    public void setUp() throws Exception {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = (ManagementServiceImpl)this.engineRule.getManagementService();
        this.identityService = this.engineRule.getIdentityService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.taskService = this.engineRule.getTaskService();
        this.caseService = this.engineRule.getCaseService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService.setAuthenticatedUserId(USER_ID);
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceOperationsByProcessDefinitionKey() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey("oneTaskProcess");
        Assert.assertEquals((long)0L, (long)this.query().entityType("ProcessInstance").count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessDefinitionOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.repositoryService.suspendProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        this.repositoryService.activateProcessDefinitionById(this.process.getProcessDefinitionId(), true, null);
        Assert.assertEquals((long)0L, (long)this.query().entityType("ProcessDefinition").count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testQueryJobOperations() {
        this.process = this.runtimeService.startProcessInstanceByKey("process");
        this.managementService.suspendJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.activateJobDefinitionByProcessDefinitionId(this.process.getProcessDefinitionId());
        this.managementService.suspendJobByProcessInstanceId(this.process.getId());
        this.managementService.activateJobByProcessInstanceId(this.process.getId());
        Assert.assertEquals((long)0L, (long)this.query().entityType("JobDefinition").count());
        Assert.assertEquals((long)0L, (long)this.query().entityType("Job").count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/async/FoxJobRetryCmdTest.testFailedServiceTask.bpmn20.xml"})
    public void testQueryJobRetryOperationsById() {
        this.process = this.runtimeService.startProcessInstanceByKey("failedServiceTask");
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(this.process.getProcessInstanceId()).singleResult();
        this.managementService.setJobRetries(job.getId(), 10);
        Assert.assertEquals((long)0L, (long)this.query().entityType("Job").operationType("SetJobRetries").count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryProcessInstanceModificationOperation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        processInstance.getId();
        this.repositoryService.createProcessDefinitionQuery().singleResult();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute();
        UserOperationLogQuery logQuery = this.query().entityType("ProcessInstance").operationType("ModifyProcessInstance");
        Assert.assertEquals((long)0L, (long)logQuery.count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddExecutionVariablesMapOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(this.process.getId(), this.createMapForVariableAddition());
        this.verifyVariableOperationAsserts("SetVariable");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryAddTaskVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(this.processTaskId, "testVariable1", (Object)"THIS IS TESTVARIABLE!!!");
        this.verifyVariableOperationAsserts("SetVariable");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryPatchExecutionVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(this.process.getId(), this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts("ModifyVariable");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryPatchTaskVariablesOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(this.processTaskId, this.createMapForVariableAddition(), this.createCollectionForVariableDeletion());
        this.verifyVariableOperationAsserts("ModifyVariable");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryRemoveExecutionVariableOperation() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.removeVariable(this.process.getId(), "testVariable1");
        this.verifyVariableOperationAsserts("RemoveVariable");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByEntityTypes() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(this.processTaskId, "foo");
        this.taskService.setVariable(this.processTaskId, "foo", (Object)"bar");
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().entityTypeIn(new String[]{"Task", "Variable"});
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDeleteVariableHistoryOperationOnRunningInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test2");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyVariableOperationAsserts("DeleteHistory");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDeleteVariableHistoryOperationOnHistoryInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.deleteProcessInstance(this.process.getId(), "none");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyVariableOperationAsserts("DeleteHistory");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryDeleteVariableHistoryOperationOnCase() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase");
        this.caseService.setVariable(caseInstance.getId(), "myVariable", (Object)1);
        this.caseService.setVariable(caseInstance.getId(), "myVariable", (Object)2);
        this.caseService.setVariable(caseInstance.getId(), "myVariable", (Object)3);
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        this.verifyVariableOperationAsserts("DeleteHistory");
    }

    @Test
    public void testQueryDeleteVariableHistoryOperationOnStandaloneTask() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue");
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue2");
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        this.verifyVariableOperationAsserts("DeleteHistory");
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDeleteVariablesHistoryOperationOnRunningInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test2");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test2");
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(this.process.getId());
        this.verifyVariableOperationAsserts("DeleteHistory");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDeleteVariablesHistoryOperationOnHistoryInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test");
        this.runtimeService.deleteProcessInstance(this.process.getId(), "none");
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(this.process.getId());
        this.verifyVariableOperationAsserts("DeleteHistory");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDeleteVariableAndVariablesHistoryOperationOnRunningInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test2");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test2");
        this.runtimeService.setVariable(this.process.getId(), "testVariable3", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable3", (Object)"test2");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("testVariable").singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(this.process.getId());
        this.verifyVariableOperationAsserts("DeleteHistory");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryDeleteVariableAndVariablesHistoryOperationOnHistoryInstance() {
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariable(this.process.getId(), "testVariable", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable2", (Object)"test");
        this.runtimeService.setVariable(this.process.getId(), "testVariable3", (Object)"test");
        this.runtimeService.deleteProcessInstance(this.process.getId(), "none");
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("testVariable").singleResult()).getId();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(this.process.getId());
        this.verifyVariableOperationAsserts("DeleteHistory");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setAssignee(task.getId(), USER_ID);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseDefinitionId(caseDefinitionId);
        Assert.assertEquals((long)0L, (long)query.count());
        this.taskService.setAssignee(task.getId(), null);
    }

    @Test
    public void testQueryByDeploymentId() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource(ONE_TASK_PROCESS).deploy().getId();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().deploymentId(deploymentId);
        Assert.assertEquals((long)0L, (long)query.count());
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    protected Map<String, Object> createMapForVariableAddition() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("testVariable1", "THIS IS TESTVARIABLE!!!");
        variables.put("testVariable2", "OVER 9000!");
        return variables;
    }

    protected Collection<String> createCollectionForVariableDeletion() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("testVariable3");
        variables.add("testVariable4");
        return variables;
    }

    protected void verifyVariableOperationAsserts(String operationType) {
        UserOperationLogQuery logQuery = this.query().entityType("Variable").operationType(operationType);
        Assert.assertEquals((long)0L, (long)logQuery.count());
    }

    protected UserOperationLogQuery query() {
        return this.historyService.createUserOperationLogQuery();
    }
}

