/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.standalone.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.impl.history.event.HistoryEventType;

public class RecordHistoryLevel
implements HistoryLevel {
    protected List<HistoryEventType> recordedHistoryEventTypes = new ArrayList<HistoryEventType>();
    protected List<ProducedHistoryEvent> producedHistoryEvents = new ArrayList<ProducedHistoryEvent>();

    public RecordHistoryLevel() {
    }

    public RecordHistoryLevel(HistoryEventType ... filterHistoryEventType) {
        Collections.addAll(this.recordedHistoryEventTypes, filterHistoryEventType);
    }

    public int getId() {
        return 42;
    }

    public String getName() {
        return "recordHistoryLevel";
    }

    public List<HistoryEventType> getRecordedHistoryEventTypes() {
        return this.recordedHistoryEventTypes;
    }

    public List<ProducedHistoryEvent> getProducedHistoryEvents() {
        return this.producedHistoryEvents;
    }

    public boolean isHistoryEventProduced(HistoryEventType eventType, Object entity) {
        if (this.recordedHistoryEventTypes.isEmpty() || this.recordedHistoryEventTypes.contains(eventType)) {
            this.producedHistoryEvents.add(new ProducedHistoryEvent(eventType, entity));
        }
        return true;
    }

    public static class ProducedHistoryEvent {
        public final HistoryEventType eventType;
        public final Object entity;

        public ProducedHistoryEvent(HistoryEventType eventType, Object entity) {
            this.eventType = eventType;
            this.entity = entity;
        }
    }
}

