/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.util;

import java.lang.reflect.Method;
import java.util.Arrays;

public class MethodInvocation {
    private final Object object;
    private final Method method;
    private final Object[] args;

    private MethodInvocation(Object object, Method method, Object[] args) {
        this.object = object;
        this.method = method;
        this.args = args;
    }

    public static MethodInvocation of(Object object, String methodName, Object[] args) {
        Method method = MethodInvocation.getMethodByName(object, methodName, args);
        return new MethodInvocation(object, method, args);
    }

    public static MethodInvocation of(Object object, String methodName) {
        Method method = MethodInvocation.getMethodByName(object, methodName, null);
        return new MethodInvocation(object, method, null);
    }

    public Object invoke() {
        try {
            if (this.args != null) {
                return this.method.invoke(this.object, this.args);
            }
            return this.method.invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            throw new MethodInvocationException(this.object, this.method.getName(), this.args);
        }
    }

    private static Method getMethodByName(Object object, String methodName, Object[] args) {
        return Arrays.stream(object.getClass().getMethods()).filter(method -> methodName.equals(method.getName())).findFirst().orElseThrow(() -> new MethodInvocationException(object, methodName, args));
    }

    static class MethodInvocationException
    extends RuntimeException {
        private final Object object;
        private final String methodName;
        private final Object[] args;

        public MethodInvocationException(Object object, String methodName, Object[] args) {
            this.object = object;
            this.methodName = methodName;
            this.args = args;
        }

        @Override
        public String toString() {
            return "Failed to invoke method: " + this.methodName + ", object: " + String.valueOf(this.object) + ", with args: " + String.valueOf(this.args);
        }
    }
}

