/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eximeebpms.bpm.engine.migration.MigratingActivityInstanceValidationReport;
import org.eximeebpms.bpm.engine.migration.MigratingProcessInstanceValidationReport;
import org.eximeebpms.bpm.engine.migration.MigratingTransitionInstanceValidationReport;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class MigratingProcessInstanceValidationReportAssert {
    protected MigratingProcessInstanceValidationReport actual;

    public MigratingProcessInstanceValidationReportAssert(MigratingProcessInstanceValidationReport report) {
        this.actual = report;
    }

    public MigratingProcessInstanceValidationReportAssert isNotNull() {
        Assert.assertNotNull((String)"Expected report to be not null", (Object)this.actual);
        return this;
    }

    public MigratingProcessInstanceValidationReportAssert hasProcessInstance(ProcessInstance processInstance) {
        return this.hasProcessInstanceId(processInstance.getId());
    }

    public MigratingProcessInstanceValidationReportAssert hasProcessInstanceId(String processInstanceId) {
        this.isNotNull();
        Assert.assertEquals((String)"Expected report to be for process instance", (Object)processInstanceId, (Object)this.actual.getProcessInstanceId());
        return this;
    }

    public MigratingProcessInstanceValidationReportAssert hasFailures(String ... expectedFailures) {
        this.isNotNull();
        List actualFailures = this.actual.getFailures();
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (String expectedFailure : expectedFailures) {
            matchers.add(Matchers.containsString((String)expectedFailure));
        }
        Assert.assertThat((String)("Expected failures:\n" + this.joinFailures(Arrays.asList(expectedFailures)) + "But found failures:\n" + this.joinFailures(actualFailures)), (Object)actualFailures, (Matcher)Matchers.containsInAnyOrder(matchers));
        return this;
    }

    public MigratingProcessInstanceValidationReportAssert hasActivityInstanceFailures(String sourceScopeId, String ... expectedFailures) {
        this.isNotNull();
        MigratingActivityInstanceValidationReport actualReport = null;
        for (MigratingActivityInstanceValidationReport instanceReport : this.actual.getActivityInstanceReports()) {
            if (!sourceScopeId.equals(instanceReport.getSourceScopeId())) continue;
            actualReport = instanceReport;
            break;
        }
        Assert.assertNotNull((String)("No validation report found for source scope: " + sourceScopeId), actualReport);
        this.assertFailures(sourceScopeId, Arrays.asList(expectedFailures), actualReport.getFailures());
        return this;
    }

    public MigratingProcessInstanceValidationReportAssert hasTransitionInstanceFailures(String sourceScopeId, String ... expectedFailures) {
        this.isNotNull();
        MigratingTransitionInstanceValidationReport actualReport = null;
        for (MigratingTransitionInstanceValidationReport instanceReport : this.actual.getTransitionInstanceReports()) {
            if (!sourceScopeId.equals(instanceReport.getSourceScopeId())) continue;
            actualReport = instanceReport;
            break;
        }
        Assert.assertNotNull((String)("No validation report found for source scope: " + sourceScopeId), actualReport);
        this.assertFailures(sourceScopeId, Arrays.asList(expectedFailures), actualReport.getFailures());
        return this;
    }

    protected void assertFailures(String sourceScopeId, List<String> expectedFailures, List<String> actualFailures) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (String expectedFailure : expectedFailures) {
            matchers.add(Matchers.containsString((String)expectedFailure));
        }
        Assert.assertThat((String)("Expected failures for source scope: " + sourceScopeId + "\n" + this.joinFailures(expectedFailures) + "But found failures:\n" + this.joinFailures(actualFailures)), actualFailures, (Matcher)Matchers.containsInAnyOrder(matchers));
    }

    public static MigratingProcessInstanceValidationReportAssert assertThat(MigratingProcessInstanceValidationReport report) {
        return new MigratingProcessInstanceValidationReportAssert(report);
    }

    public String joinFailures(List<String> failures) {
        StringBuilder builder = new StringBuilder();
        for (String failure : failures) {
            builder.append("\t\t").append((Object)failure).append("\n");
        }
        return builder.toString();
    }
}

