/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;

import org.eximeebpms.bpm.engine.filter.Filter;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

/**
 * @author Sebastian Menski
 */
public class SaveFilterCmd implements Command<Filter>, Serializable {

  private static final long serialVersionUID = 1L;

  protected Filter filter;

  public SaveFilterCmd(Filter filter) {
    this.filter = filter;
  }

  public Filter execute(CommandContext commandContext) {
    EnsureUtil.ensureNotNull("filter", filter);
    
    String operation = filter.getId() == null ? UserOperationLogEntry.OPERATION_TYPE_CREATE : UserOperationLogEntry.OPERATION_TYPE_UPDATE;
    
    Filter savedFilter = commandContext
      .getFilterManager()
      .insertOrUpdateFilter(filter);
    
    commandContext.getOperationLogManager().logFilterOperation(operation, filter.getId());
    
    return savedFilter;
  }

}
