/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.Date;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;

/**
 * Command to change task priority to a new value.
 */
public class SetTaskDueDateCmd extends AbstractSetTaskPropertyCmd<Date> {

  /**
   * Public Constructor.
   *
   * @param taskId the id of the referenced task, non-null
   * @param value  the task dueDate value to set, non-null
   * @throws NullValueException in case the given taskId or the given dueDate value are null
   */
  public SetTaskDueDateCmd(String taskId, Date value) {
    super(taskId, value, true);
  }

  @Override
  protected String getUserOperationLogName() {
    return UserOperationLogEntry.OPERATION_TYPE_SET_DUEDATE;
  }

  @Override
  protected void executeSetOperation(TaskEntity task, Date value) {
    task.setDueDate(value);
  }
}
