/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eximeebpms.bpm.engine.test.dmn.feel.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import org.eximeebpms.bpm.dmn.feel.impl.scala.function.CustomFunction;
import org.eximeebpms.bpm.dmn.feel.impl.scala.function.FeelCustomFunctionProvider;

public class CustomFunctionProvider implements FeelCustomFunctionProvider {

  protected Map<String, CustomFunction> functions = new HashMap<>();

  public CustomFunctionProvider(String name, String value) {
    CustomFunction function = CustomFunction.create()
      .setReturnValue(value)
      .build();

    functions.put(name, function);
  }

  @Override
  public Optional<CustomFunction> resolveFunction(String functionName) {
    return Optional.ofNullable(functions.get(functionName));
  }

  @Override
  public Collection<String> getFunctionNames() {
    return functions.keySet();
  }

}
