/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.jobexecutor.setInitialRetries;

import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.jobexecutor.FailingDelegate;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LegacyJobDeclarationRetriesTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(config -> config.setLegacyJobRetryBehaviorEnabled(true));
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private ManagementService managementService;
    private RuntimeService runtimeService;

    @Before
    public void init() {
        this.managementService = this.engineRule.getProcessEngine().getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    public void testRetryTimeCycleWithZeroRetriesAndFailure() {
        String retryInterval = "R0/PT5M";
        String processDefinitionName = "testRetryTimeCycleWithZeroRetriesAndFailure";
        BpmnModelInstance bpmnModelInstance = LegacyJobDeclarationRetriesTest.getBpmnModelInstance(processDefinitionName, retryInterval);
        this.testRule.deploy(bpmnModelInstance);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(processDefinitionName).getId();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertEquals((long)3L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertEquals((long)0L, (long)job.getRetries());
    }

    @Test
    public void testRetryTimeCycleWithFailure() {
        String retryInterval = "R5/PT5M";
        String processDefinitionName = "testRetryTimeCycleWithFailure";
        BpmnModelInstance bpmnModelInstance = LegacyJobDeclarationRetriesTest.getBpmnModelInstance(processDefinitionName, retryInterval);
        this.testRule.deploy(bpmnModelInstance);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(processDefinitionName).getId();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertEquals((long)3L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertEquals((long)4L, (long)job.getRetries());
    }

    @Test
    public void testRetryIntervalsWithFailure() {
        String retryInterval = "PT10M,PT17M,PT20M";
        String processDefinitionName = "testRetryIntervalsWithFailure";
        BpmnModelInstance bpmnModelInstance = LegacyJobDeclarationRetriesTest.getBpmnModelInstance(processDefinitionName, retryInterval);
        this.testRule.deploy(bpmnModelInstance);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(processDefinitionName).getId();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        Assert.assertEquals((long)3L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)3L, (long)job.getRetries());
    }

    private static BpmnModelInstance getBpmnModelInstance(String processDefinitionName, String retryStrategy) {
        return ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)processDefinitionName).camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().serviceTask().camundaAsyncBefore()).camundaFailedJobRetryTimeCycle(retryStrategy)).camundaClass(FailingDelegate.class.getName())).endEvent().done();
    }
}

