/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.test;

import java.lang.reflect.Method;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.impl.test.TestHelper;
import org.junit.Test;

public class TestHelperTest {
    @Test
    public void shouldGetPublicMethod() throws NoSuchMethodException {
        Method methodName = TestHelper.getMethod(SomeTestClass.class, (String)"testSomethingWithPublicAccessor", (Class[])new Class[0]);
        Assertions.assertThat((String)((Object)methodName).toString()).isEqualTo((Object)"public void org.eximeebpms.bpm.engine.impl.test.TestHelperTest$SomeTestClass.testSomethingWithPublicAccessor()");
    }

    @Test
    public void shouldGetPublicMethodFromSuperClass() throws NoSuchMethodException {
        Method methodName = TestHelper.getMethod(SomeOtherTestClass.class, (String)"testSomethingWithPublicAccessor", (Class[])new Class[0]);
        Assertions.assertThat((String)((Object)methodName).toString()).isEqualTo((Object)"public void org.eximeebpms.bpm.engine.impl.test.TestHelperTest$SomeTestClass.testSomethingWithPublicAccessor()");
    }

    @Test
    public void shouldGetPackagePrivateMethod() throws NoSuchMethodException {
        Method methodName = TestHelper.getMethod(SomeTestClass.class, (String)"testSomethingWithPackagePrivateAccessor", (Class[])new Class[0]);
        Assertions.assertThat((String)((Object)methodName).toString()).isEqualTo((Object)"void org.eximeebpms.bpm.engine.impl.test.TestHelperTest$SomeTestClass.testSomethingWithPackagePrivateAccessor()");
    }

    @Test
    public void shouldGetPackagePrivateMethodFromSuperClass() throws NoSuchMethodException {
        Method methodName = TestHelper.getMethod(SomeOtherTestClass.class, (String)"testSomethingWithPackagePrivateAccessor", (Class[])new Class[0]);
        Assertions.assertThat((String)((Object)methodName).toString()).isEqualTo((Object)"void org.eximeebpms.bpm.engine.impl.test.TestHelperTest$SomeTestClass.testSomethingWithPackagePrivateAccessor()");
    }

    @Test
    public void shouldGetProtectedMethod() throws NoSuchMethodException {
        Method methodName = TestHelper.getMethod(SomeTestClass.class, (String)"testSomethingWithProtected", (Class[])new Class[0]);
        Assertions.assertThat((String)((Object)methodName).toString()).isEqualTo((Object)"protected void org.eximeebpms.bpm.engine.impl.test.TestHelperTest$SomeTestClass.testSomethingWithProtected()");
    }

    @Test
    public void shouldGetProtectedMethodFromSuperClass() throws NoSuchMethodException {
        Method methodName = TestHelper.getMethod(SomeOtherTestClass.class, (String)"testSomethingWithProtected", (Class[])new Class[0]);
        Assertions.assertThat((String)((Object)methodName).toString()).isEqualTo((Object)"protected void org.eximeebpms.bpm.engine.impl.test.TestHelperTest$SomeTestClass.testSomethingWithProtected()");
    }

    static class SomeTestClass {
        SomeTestClass() {
        }

        public void testSomethingWithPublicAccessor() {
        }

        void testSomethingWithPackagePrivateAccessor() {
        }

        protected void testSomethingWithProtected() {
        }
    }

    static class SomeOtherTestClass
    extends SomeTestClass {
        SomeOtherTestClass() {
        }
    }
}

