/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.Collections;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.Tenant;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DefaultPermissionForTenantMemberTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String USER_ID = "user";
    protected static final String GROUP_ID = "group";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected AuthorizationService authorizationService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.identityService = this.engineRule.getIdentityService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.createTenant(TENANT_ONE);
        User user = this.identityService.newUser(USER_ID);
        this.identityService.saveUser(user);
        Group group = this.identityService.newGroup(GROUP_ID);
        this.identityService.saveGroup(group);
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(true);
    }

    @After
    public void tearDown() {
        this.identityService.clearAuthentication();
        this.identityService.deleteUser(USER_ID);
        this.identityService.deleteGroup(GROUP_ID);
        this.identityService.deleteTenant(TENANT_ONE);
        this.identityService.deleteTenant(TENANT_TWO);
        this.engineRule.getProcessEngineConfiguration().setAuthorizationEnabled(false);
    }

    @Test
    public void testCreateTenantUserMembership() {
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ID);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{USER_ID}).resourceType((Resource)Resources.TENANT).resourceId(TENANT_ONE).hasPermission((Permission)Permissions.READ).count());
        this.identityService.setAuthenticatedUserId(USER_ID);
        Assert.assertEquals((Object)TENANT_ONE, (Object)((Tenant)this.identityService.createTenantQuery().singleResult()).getId());
    }

    @Test
    public void testCreateAndDeleteTenantUserMembership() {
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ID);
        this.identityService.deleteTenantUserMembership(TENANT_ONE, USER_ID);
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{USER_ID}).resourceType((Resource)Resources.TENANT).hasPermission((Permission)Permissions.READ).count());
        this.identityService.setAuthenticatedUserId(USER_ID);
        Assert.assertEquals((long)0L, (long)this.identityService.createTenantQuery().count());
    }

    @Test
    public void testCreateAndDeleteTenantUserMembershipForMultipleTenants() {
        this.createTenant(TENANT_TWO);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER_ID);
        this.identityService.createTenantUserMembership(TENANT_TWO, USER_ID);
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{USER_ID}).resourceType((Resource)Resources.TENANT).hasPermission((Permission)Permissions.READ).count());
        this.identityService.deleteTenantUserMembership(TENANT_ONE, USER_ID);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{USER_ID}).resourceType((Resource)Resources.TENANT).hasPermission((Permission)Permissions.READ).count());
    }

    @Test
    public void testCreateTenantGroupMembership() {
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ID);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{GROUP_ID}).resourceType((Resource)Resources.TENANT).resourceId(TENANT_ONE).hasPermission((Permission)Permissions.READ).count());
        this.identityService.setAuthentication(USER_ID, Collections.singletonList(GROUP_ID));
        Assert.assertEquals((Object)TENANT_ONE, (Object)((Tenant)this.identityService.createTenantQuery().singleResult()).getId());
    }

    @Test
    public void testCreateAndDeleteTenantGroupMembership() {
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ID);
        this.identityService.deleteTenantGroupMembership(TENANT_ONE, GROUP_ID);
        Assert.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{GROUP_ID}).resourceType((Resource)Resources.TENANT).hasPermission((Permission)Permissions.READ).count());
        this.identityService.setAuthentication(USER_ID, Collections.singletonList(GROUP_ID));
        Assert.assertEquals((long)0L, (long)this.identityService.createTenantQuery().count());
    }

    @Test
    public void testCreateAndDeleteTenantGroupMembershipForMultipleTenants() {
        this.createTenant(TENANT_TWO);
        this.identityService.createTenantGroupMembership(TENANT_ONE, GROUP_ID);
        this.identityService.createTenantGroupMembership(TENANT_TWO, GROUP_ID);
        Assert.assertEquals((long)2L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{GROUP_ID}).resourceType((Resource)Resources.TENANT).hasPermission((Permission)Permissions.READ).count());
        this.identityService.deleteTenantGroupMembership(TENANT_ONE, GROUP_ID);
        Assert.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{GROUP_ID}).resourceType((Resource)Resources.TENANT).hasPermission((Permission)Permissions.READ).count());
    }

    protected Tenant createTenant(String tenantId) {
        Tenant newTenant = this.identityService.newTenant(tenantId);
        this.identityService.saveTenant(newTenant);
        return newTenant;
    }
}

