/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.Date;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.JobQuery;
import org.eximeebpms.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobAuthorizationTest
extends AuthorizationTest {
    protected static final String TIMER_START_PROCESS_KEY = "timerStartProcess";
    protected static final String TIMER_BOUNDARY_PROCESS_KEY = "timerBoundaryProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/authorization/timerStartEventProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/timerBoundaryEventProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml");
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute(commandContext -> {
            commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-job-definition");
            return null;
        });
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithMultiple() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void shouldNotFindJobWithRevokedReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", "*", new Permission[]{Permissions.ALL});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadInstancePermissionOnTimerStartProcessDefinition() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Job job = (Job)query.singleResult();
        Assert.assertNull((Object)job.getProcessInstanceId());
        Assert.assertEquals((Object)TIMER_START_PROCESS_KEY, (Object)job.getProcessDefinitionKey());
    }

    @Test
    public void testQueryWithReadInstancePermissionOnTimerBoundaryProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Job job = (Job)query.singleResult();
        Assert.assertEquals((Object)processInstanceId, (Object)job.getProcessInstanceId());
        Assert.assertEquals((Object)TIMER_BOUNDARY_PROCESS_KEY, (Object)job.getProcessDefinitionKey());
    }

    @Test
    public void testQueryWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(TIMER_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testStandaloneJobQueryWithoutAuthorization() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, true, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Job job = (Job)query.singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertNull((Object)job.getProcessInstanceId());
        Assert.assertNull((Object)job.getProcessDefinitionKey());
        this.deleteJob(job.getId());
    }

    @Test
    public void testExecuteStandaloneJob() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        JobDefinition jobDefinition = this.selectJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY);
        Assert.assertTrue((boolean)jobDefinition.isSuspended());
    }

    @Test
    public void testDeleteStandaloneJob() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.deleteJob(jobId);
        Job job = this.selectJobById(jobId);
        Assert.assertNull((Object)job);
    }

    @Test
    public void testSetStandaloneJobRetries() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 1);
        Job job = this.selectJobById(jobId);
        Assert.assertEquals((long)1L, (long)job.getRetries());
        this.deleteJob(jobId);
    }

    @Test
    public void testSetStandaloneJobDueDate() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobDuedate(jobId, null);
        Job job = this.selectJobById(jobId);
        Assert.assertNull((Object)job.getDuedate());
        this.deleteJob(jobId);
    }

    @Test
    public void testGetExceptionStacktraceWithoutAuthorization() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        try {
            this.managementService.getJobExceptionStacktrace(jobId);
            Assert.fail((String)"Exception expected: It should not be possible to get the exception stacktrace");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName() + "' permission on resource '" + processInstanceId + "' of type '" + Resources.PROCESS_INSTANCE.resourceName() + "' or '", message);
            this.testRule.assertTextPresent(Permissions.READ_INSTANCE.getName() + "' permission on resource 'process' of type '" + Resources.PROCESS_DEFINITION.resourceName() + "'", message);
        }
    }

    @Test
    public void testGetExceptionStacktraceWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        Assert.assertNotNull((Object)jobExceptionStacktrace);
    }

    @Test
    public void testGetExceptionStacktraceReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        Assert.assertNotNull((Object)jobExceptionStacktrace);
    }

    @Test
    public void testGetExceptionStacktraceWithReadInstancePermissionOnTimerBoundaryProcessDefinition() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        Assert.assertNotNull((Object)jobExceptionStacktrace);
    }

    @Test
    public void testGetExceptionStacktraceWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY).getId();
        String jobId = this.selectJobByProcessInstanceId(processInstanceId).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        Assert.assertNotNull((Object)jobExceptionStacktrace);
    }

    @Test
    public void testStandaloneJobGetExceptionStacktrace() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        String jobExceptionStacktrace = this.managementService.getJobExceptionStacktrace(jobId);
        Assert.assertNull((Object)jobExceptionStacktrace);
        this.deleteJob(jobId);
    }

    @Test
    public void testSuspendStandaloneJobById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.suspendJobById(jobId);
        Job job = this.selectJobById(jobId);
        Assert.assertNotNull((Object)job);
        Assert.assertTrue((boolean)job.isSuspended());
        this.deleteJob(jobId);
    }

    @Test
    public void testActivateStandaloneJobById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, TIMER_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        long oneWeekFromStartTime = startTime.getTime() + 604800000L;
        this.disableAuthorization();
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(TIMER_START_PROCESS_KEY, false, new Date(oneWeekFromStartTime));
        this.enableAuthorization();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.suspendJobById(jobId);
        this.managementService.activateJobById(jobId);
        Job job = this.selectJobById(jobId);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isSuspended());
        this.deleteJob(jobId);
    }

    protected Job selectAnyJob() {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().listPage(0, 1).get(0);
        this.enableAuthorization();
        return job;
    }

    protected void deleteJob(String jobId) {
        this.disableAuthorization();
        this.managementService.deleteJob(jobId);
        this.enableAuthorization();
    }

    protected Job selectJobByProcessInstanceId(String processInstanceId) {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        this.enableAuthorization();
        return job;
    }

    protected Job selectJobById(String jobId) {
        this.disableAuthorization();
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        this.enableAuthorization();
        return job;
    }

    protected JobDefinition selectJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.disableAuthorization();
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
        this.enableAuthorization();
        return jobDefinition;
    }
}

