/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization;

import java.util.List;
import org.eximeebpms.bpm.engine.AuthorizationException;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.authorization.Authorization;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TaskCountByCandidateGroupAuthorizationTest {
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule processEngineTestRule = new ProcessEngineTestRule(this.processEngineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.processEngineTestRule).around((TestRule)this.processEngineRule);
    protected TaskService taskService;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected String userId = "user";

    @Before
    public void setUp() {
        this.taskService = this.processEngineRule.getTaskService();
        this.identityService = this.processEngineRule.getIdentityService();
        this.authorizationService = this.processEngineRule.getAuthorizationService();
        this.processEngineConfiguration = this.processEngineRule.getProcessEngineConfiguration();
    }

    @Test
    public void shouldFetchTaskCountWithAuthorization() {
        User user = this.identityService.newUser(this.userId);
        this.identityService.saveUser(user);
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.addPermission((Permission)Permissions.READ);
        authorization.setResource((Resource)Resources.TASK);
        authorization.setResourceId("*");
        authorization.setUserId(this.userId);
        this.authorizationService.saveAuthorization(authorization);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.authenticate();
        List results = this.taskService.createTaskReport().taskCountByCandidateGroup();
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.authorizationService.deleteAuthorization(authorization.getId());
        this.identityService.deleteUser(this.userId);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void shouldFailToFetchTaskCountWithMissingAuthorization() {
        boolean testFailed;
        block3: {
            testFailed = false;
            this.processEngineConfiguration.setAuthorizationEnabled(true);
            this.authenticate();
            try {
                this.taskService.createTaskReport().taskCountByCandidateGroup();
                testFailed = true;
            }
            catch (AuthorizationException aex) {
                if (aex.getMessage().contains(this.userId + "' does not have 'READ' permission on resource '*' of type 'Task'")) break block3;
                testFailed = true;
            }
        }
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        if (testFailed) {
            Assert.fail((String)("There should be an authorization exception for '" + this.userId + "' because of a missing 'READ' permission on 'Task'."));
        }
    }

    protected void authenticate() {
        this.identityService.setAuthentication(this.userId, null, null);
    }
}

