/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.externaltask;

import java.util.Collection;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runners.Parameterized;

public abstract class HandleExternalTaskAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstanceId", "userId", new Permission[]{Permissions.UPDATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstanceId", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.UPDATE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "processDefinitionKey", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "userId", new Permission[]{Permissions.UPDATE_INSTANCE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }
}

