/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.authorization.util;

import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;

public class AuthorizationScenario {
    protected static final String INDENTATION = "   ";
    protected AuthorizationSpec[] givenAuthorizations = new AuthorizationSpec[0];
    protected AuthorizationSpec[] missingAuthorizations = new AuthorizationSpec[0];

    public static AuthorizationScenario scenario() {
        return new AuthorizationScenario();
    }

    public AuthorizationScenario withoutAuthorizations() {
        return this;
    }

    public AuthorizationScenario withAuthorizations(AuthorizationSpec ... givenAuthorizations) {
        this.givenAuthorizations = givenAuthorizations;
        return this;
    }

    public AuthorizationScenario succeeds() {
        return this;
    }

    public AuthorizationScenario failsDueToRequired(AuthorizationSpec ... expectedMissingAuthorizations) {
        this.missingAuthorizations = expectedMissingAuthorizations;
        return this;
    }

    public AuthorizationSpec[] getGivenAuthorizations() {
        return this.givenAuthorizations;
    }

    public AuthorizationSpec[] getMissingAuthorizations() {
        return this.missingAuthorizations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Given Authorizations: \n");
        for (AuthorizationSpec spec : this.givenAuthorizations) {
            sb.append(INDENTATION);
            sb.append(spec);
            sb.append("\n");
        }
        sb.append("Expected missing authorizations: \n");
        for (AuthorizationSpec spec : this.missingAuthorizations) {
            sb.append(INDENTATION);
            sb.append(spec);
            sb.append("\n");
        }
        return sb.toString();
    }
}

