/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.cfg;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.junit.After;
import org.junit.Test;

public class HistoryLevelTest {
    protected ProcessEngine processEngine;

    @Test
    public void shouldInitHistoryLevelByObject() throws Exception {
        ProcessEngineConfigurationImpl config = this.createConfig();
        config.setHistoryLevel(HistoryLevel.HISTORY_LEVEL_FULL);
        ProcessEngineConfigurationImpl processEngineConfiguration = this.buildProcessEngine(config);
        Assertions.assertThat((List)processEngineConfiguration.getHistoryLevels()).hasSize(4);
        Assertions.assertThat((Object)processEngineConfiguration.getHistoryLevel()).isSameAs((Object)HistoryLevel.HISTORY_LEVEL_FULL);
        Assertions.assertThat((String)processEngineConfiguration.getHistory()).isEqualTo((Object)HistoryLevel.HISTORY_LEVEL_FULL.getName());
    }

    @Test
    public void shouldInitHistoryLevelByString() throws Exception {
        ProcessEngineConfigurationImpl config = this.createConfig();
        config.setHistory(HistoryLevel.HISTORY_LEVEL_FULL.getName());
        ProcessEngineConfigurationImpl processEngineConfiguration = this.buildProcessEngine(config);
        Assertions.assertThat((List)processEngineConfiguration.getHistoryLevels()).hasSize(4);
        Assertions.assertThat((Object)processEngineConfiguration.getHistoryLevel()).isSameAs((Object)HistoryLevel.HISTORY_LEVEL_FULL);
        Assertions.assertThat((String)processEngineConfiguration.getHistory()).isEqualTo((Object)HistoryLevel.HISTORY_LEVEL_FULL.getName());
    }

    protected ProcessEngineConfigurationImpl createConfig() {
        StandaloneInMemProcessEngineConfiguration configuration = new StandaloneInMemProcessEngineConfiguration();
        configuration.setProcessEngineName("process-engine-HistoryTest");
        configuration.setDbMetricsReporterActivate(false);
        configuration.setJdbcUrl("jdbc:h2:mem:HistoryTest");
        return configuration;
    }

    protected ProcessEngineConfigurationImpl buildProcessEngine(ProcessEngineConfigurationImpl config) {
        this.processEngine = config.buildProcessEngine();
        return (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
    }

    @After
    public void closeEngine() {
        this.processEngine.close();
    }
}

