/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.context;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.context.DelegateExecutionContext;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.delegate.JavaDelegate;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.EventSubscription;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.mock.Mocks;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DelegateExecutionContextTest {
    protected static final BpmnModelInstance SERVICE_TASK_DELEGATE_PROCESS = ((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().serviceTask("serviceTask1").camundaClass(DelegateClass.class.getName())).endEvent().done();
    protected static final BpmnModelInstance EXEUCTION_LISTENER_PROCESS = ((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().camundaExecutionListenerClass("start", ExecutionListenerImpl.class.getName())).endEvent().done();
    protected static final BpmnModelInstance SIGNAL_EVENT_PROCESS = ((IntermediateCatchEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().intermediateCatchEvent("catchSignal").signal("${delegateExecutionContextBean.getCurrentActivityId()}")).endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    RuntimeService runtimeService;
    TaskService taskService;

    protected static final BpmnModelInstance getSingleUserTaskProcessWithSignalStartEventSubprocess() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess();
        BpmnModelInstance model = ((ProcessBuilder)processBuilder.camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent("start").userTask("A").endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("catchSignal").signal("${delegateExecutionContextBean.getCurrentActivityId()}")).userTask("B").endEvent().subProcessDone();
        return model;
    }

    @Before
    public void setup() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @After
    public void tearDown() {
        Mocks.reset();
    }

    @Test
    public void testDelegateExecutionContext() {
        ProcessDefinition definition = this.testHelper.deployAndGetDefinition(SERVICE_TASK_DELEGATE_PROCESS);
        this.runtimeService.startProcessInstanceById(definition.getId());
        DelegateExecution execution = DelegateExecutionContext.getCurrentDelegationExecution();
        Assertions.assertThat((Object)execution).isNull();
    }

    @Test
    public void testDelegateExecutionContextWithExecutionListener() {
        ProcessDefinition definition = this.testHelper.deployAndGetDefinition(EXEUCTION_LISTENER_PROCESS);
        this.runtimeService.startProcessInstanceById(definition.getId());
        DelegateExecution execution = DelegateExecutionContext.getCurrentDelegationExecution();
        Assertions.assertThat((Object)execution).isNull();
    }

    @Test
    public void shouldCreateEventSubscription_IntermediateSignalEvent() {
        Mocks.register((String)"delegateExecutionContextBean", (Object)new DelegateExecutionContextBean());
        ProcessDefinition definition = this.testHelper.deployAndGetDefinition(SIGNAL_EVENT_PROCESS);
        this.runtimeService.startProcessInstanceById(definition.getId());
        Assertions.assertThat((String)((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getEventName()).isEqualTo((Object)"catchSignal");
    }

    @Test
    public void shouldCreateEventSubscription_EventSubprocess() {
        Mocks.register((String)"delegateExecutionContextBean", (Object)new DelegateExecutionContextBean());
        ProcessDefinition definition = this.testHelper.deployAndGetDefinition(DelegateExecutionContextTest.getSingleUserTaskProcessWithSignalStartEventSubprocess());
        this.runtimeService.startProcessInstanceById(definition.getId());
        Assertions.assertThat((String)((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getEventName()).isEqualTo((Object)"start");
    }

    @Deployment
    @Test
    public void shouldCreateEventSubscription_ProcessInstanceModification_EventSubprocess() {
        Mocks.register((String)"delegateExecutionContextBean", (Object)new DelegateExecutionContextBean());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        ActivityInstance activityTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("B")).cancelActivityInstance(activityTree.getActivityInstances("A")[0].getId()).execute();
        Assertions.assertThat((String)((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getEventName()).isEqualTo((Object)"subprocess");
    }

    @Deployment
    @Test
    public void shouldCreateEventSubscription_ProcessIstantiation_EventSubprocess() {
        Mocks.register((String)"delegateExecutionContextBean", (Object)new DelegateExecutionContextBean());
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").startBeforeActivity("A")).execute();
        Assertions.assertThat((String)((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getEventName()).isEqualTo((Object)"A");
    }

    public class DelegateExecutionContextBean {
        public String getCurrentActivityId() {
            return DelegateExecutionContext.getCurrentDelegationExecution().getCurrentActivityId();
        }
    }

    public static class DelegateClass
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            DelegateExecution delegateExecution = DelegateExecutionContext.getCurrentDelegationExecution();
            Assertions.assertThat((Object)delegateExecution).isNotNull();
            Assertions.assertThat((Object)delegateExecution).isEqualTo((Object)execution);
        }
    }

    public static class ExecutionListenerImpl
    implements ExecutionListener {
        public void notify(DelegateExecution execution) throws Exception {
            DelegateExecution delegateExecution = DelegateExecutionContext.getCurrentDelegationExecution();
            Assertions.assertThat((Object)delegateExecution).isNotNull();
            Assertions.assertThat((Object)delegateExecution).isEqualTo((Object)execution);
        }
    }
}

