/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.dmn;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.dmn.engine.DmnDecisionResult;
import org.eximeebpms.bpm.dmn.engine.DmnDecisionTableResult;
import org.eximeebpms.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ResetDmnConfigUtil;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DecisionServiceTest {
    protected static final String DMN_DECISION_TABLE = "org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn";
    protected static final String DMN_DECISION_TABLE_V2 = "org/eximeebpms/bpm/engine/test/api/dmn/Example_v2.dmn";
    protected static final String DMN_DECISION_LITERAL_EXPRESSION = "org/eximeebpms/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn";
    protected static final String DMN_DECISION_LITERAL_EXPRESSION_V2 = "org/eximeebpms/bpm/engine/test/api/dmn/DecisionWithLiteralExpression_v2.dmn";
    protected static final String DRD_DISH_DECISION_TABLE = "org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String RESULT_OF_FIRST_VERSION = "ok";
    protected static final String RESULT_OF_SECOND_VERSION = "notok";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected DecisionService decisionService;
    protected RepositoryService repositoryService;

    @Before
    public void init() {
        this.decisionService = this.engineRule.getDecisionService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Before
    public void enableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @After
    public void disableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionTableById() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableById(decisionDefinition.getId(), (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionTableByKey() {
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionTableByKeyAndLatestVersion() {
        this.testRule.deploy(DMN_DECISION_TABLE_V2);
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_SECOND_VERSION);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionTableByKeyAndVersion() {
        this.testRule.deploy(DMN_DECISION_TABLE_V2);
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKeyAndVersion(DECISION_DEFINITION_KEY, Integer.valueOf(1), (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionTableByKeyAndNullVersion() {
        this.testRule.deploy(DMN_DECISION_TABLE_V2);
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKeyAndVersion(DECISION_DEFINITION_KEY, null, (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_SECOND_VERSION);
    }

    @Test
    public void evaluateDecisionTableByNullId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionTableById(null, null)).isInstanceOf(NotValidException.class)).hasMessageContaining("either decision definition id or key must be set");
    }

    @Test
    public void evaluateDecisionTableByNonExistingId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionTableById("unknown", null)).isInstanceOf(NotFoundException.class)).hasMessageContaining("no deployed decision definition found with id 'unknown'");
    }

    @Test
    public void evaluateDecisionTableByNullKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionTableByKey(null, null)).isInstanceOf(NotValidException.class)).hasMessageContaining("either decision definition id or key must be set");
    }

    @Test
    public void evaluateDecisionTableByNonExistingKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionTableByKey("unknown", null)).isInstanceOf(NotFoundException.class)).hasMessageContaining("no decision definition deployed with key 'unknown'");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionTableByKeyWithNonExistingVersion() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionTableByKeyAndVersion(decisionDefinition.getKey(), Integer.valueOf(42), null)).isInstanceOf(NotFoundException.class)).hasMessageContaining("no decision definition deployed with key = 'decision' and version = '42'");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void evaluateDecisionById() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void evaluateDecisionByKey() {
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void evaluateDecisionByKeyAndLatestVersion() {
        this.testRule.deploy(DMN_DECISION_LITERAL_EXPRESSION_V2);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_SECOND_VERSION);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void evaluateDecisionByKeyAndVersion() {
        this.testRule.deploy(DMN_DECISION_LITERAL_EXPRESSION_V2);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).version(Integer.valueOf(1)).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void evaluateDecisionByKeyAndNullVersion() {
        this.testRule.deploy(DMN_DECISION_LITERAL_EXPRESSION_V2);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).version(null).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, (Object)RESULT_OF_SECOND_VERSION);
    }

    @Test
    public void evaluateDecisionByNullId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionById(null).evaluate()).isInstanceOf(NotValidException.class)).hasMessageContaining("either decision definition id or key must be set");
    }

    @Test
    public void evaluateDecisionByNonExistingId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionById("unknown").evaluate()).isInstanceOf(NotFoundException.class)).hasMessageContaining("no deployed decision definition found with id 'unknown'");
    }

    @Test
    public void evaluateDecisionByNullKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionByKey(null).evaluate()).isInstanceOf(NotValidException.class)).hasMessageContaining("either decision definition id or key must be set");
    }

    @Test
    public void evaluateDecisionByNonExistingKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionByKey("unknown").evaluate()).isInstanceOf(NotFoundException.class)).hasMessageContaining("no decision definition deployed with key 'unknown'");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void evaluateDecisionByKeyWithNonExistingVersion() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decisionService.evaluateDecisionByKey(decisionDefinition.getKey()).version(Integer.valueOf(42)).evaluate()).isInstanceOf(NotFoundException.class)).hasMessageContaining("no decision definition deployed with key = 'decision' and version = '42'");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void evaluateDecisionWithRequiredDecisions() {
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKey("dish-decision", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        this.assertThatDecisionHasResult(decisionResult, (Object)"Light salad");
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }

    protected void assertThatDecisionHasResult(DmnDecisionTableResult decisionResult, Object expectedValue) {
        Assertions.assertThat((List)decisionResult).isNotNull();
        Assertions.assertThat((List)decisionResult).hasSize(1);
        String value = (String)decisionResult.getSingleResult().getFirstEntry();
        Assertions.assertThat((String)value).isEqualTo(expectedValue);
    }

    protected void assertThatDecisionHasResult(DmnDecisionResult decisionResult, Object expectedValue) {
        Assertions.assertThat((List)decisionResult).isNotNull();
        Assertions.assertThat((List)decisionResult).hasSize(1);
        String value = (String)decisionResult.getSingleResult().getFirstEntry();
        Assertions.assertThat((String)value).isEqualTo(expectedValue);
    }
}

