/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.externaltask;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.externaltask.ExternalTask;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ExternalTaskQueryByPriorityTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    @Test
    public void testOrderByPriority() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        TestOrderingUtil.verifySortingAndCount(this.externalTaskService.createExternalTaskQuery().orderByPriority().asc(), 10, TestOrderingUtil.externalTaskByPriority());
        TestOrderingUtil.verifySortingAndCount(this.externalTaskService.createExternalTaskQuery().orderByPriority().desc(), 10, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByPriority()));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    @Test
    public void testFilterByExternalTaskPriorityLowerThanOrEquals() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List tasks = this.externalTaskService.createExternalTaskQuery().priorityLowerThanOrEquals(2L).list();
        Assert.assertEquals((long)8L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertTrue((task.getPriority() <= 2L ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    @Test
    public void testFilterByExternalTaskPriorityLowerThanOrEqualsAndHigherThanOrEqual() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().priorityLowerThanOrEquals(2L).priorityHigherThanOrEquals(3L).count());
        Assert.assertEquals((long)2L, (long)this.externalTaskService.createExternalTaskQuery().priorityHigherThanOrEquals(2L).priorityLowerThanOrEquals(3L).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    @Test
    public void testFilterByExternalTaskPriorityHigherThanOrEquals() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        List tasks = this.externalTaskService.createExternalTaskQuery().priorityHigherThanOrEquals(2L).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        HashSet<String> processInstanceIds = new HashSet<String>();
        processInstanceIds.add(((ProcessInstance)instances.get(2)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(3)).getId());
        processInstanceIds.add(((ProcessInstance)instances.get(4)).getId());
        for (ExternalTask task : tasks) {
            Assert.assertTrue((task.getPriority() >= 2L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)processInstanceIds.contains(task.getProcessInstanceId()));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml"})
    @Test
    public void testFilterByExternalTaskPriorityLowerAndHigher() {
        ArrayList<ProcessInstance> instances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < 5; ++i) {
            instances.add(this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", (Map)Variables.createVariables().putValue("priority", (Object)i)));
        }
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().priorityHigherThanOrEquals(2L).priorityLowerThanOrEquals(2L).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)2L, (long)task.getPriority());
        Assert.assertEquals((Object)((ProcessInstance)instances.get(2)).getId(), (Object)task.getProcessInstanceId());
    }
}

