/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.form;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.FormService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.form.CamundaFormRef;
import org.eximeebpms.bpm.engine.form.TaskFormData;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.util.ReflectUtil;
import org.eximeebpms.bpm.engine.repository.CamundaFormDefinition;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.CamundaFormUtils;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class RetrieveCamundaFormRefTest {
    protected static final String TASK_FORM_CONTENT_V1 = "{\"id\"=\"myTaskForm\",\"type\": \"default\",\"components\": []}";
    protected static final String TASK_FORM_CONTENT_V2 = "{\"id\"=\"myTaskForm\",\"type\": \"default\",\"components\":[{\"key\": \"textfield1\",\"label\": \"Text Field\",\"type\": \"textfield\"}]}";
    protected static final String START_FORM_CONTENT_V1 = "{\"id\"=\"myStartForm\",\"type\": \"default\",\"components\": []}";
    protected static final String START_FORM_CONTENT_V2 = "{\"id\"=\"myStartForm\",\"type\": \"default\",\"components\":[{\"key\": \"textfield1\",\"label\": \"Text Field\",\"type\": \"textfield\"}]}";
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.tempFolder);
    private RuntimeService runtimeService;
    private TaskService taskService;
    private RepositoryService repositoryService;
    private FormService formService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.formService = this.engineRule.getFormService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() throws Exception {
        List deployments = this.repositoryService.createDeploymentQuery().list();
        for (org.eximeebpms.bpm.engine.repository.Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void shouldRetrieveTaskFormBindingLatestWithSingleVersionSeparateDeloyments() throws IOException {
        this.deployClasspathResources(true, "org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.taskFormBindingLatest.bpmn", "org/eximeebpms/bpm/engine/test/api/form/task.form");
        this.runtimeService.startProcessInstanceByKey("taskFormBindingLatest");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        InputStream deployedForm = this.formService.getDeployedTaskForm(task.getId());
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat(definitions).hasSize(1);
        this.assertTaskFormData(taskFormData, "myTaskForm", "latest", null);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)this.getClasspathResourceContent("org/eximeebpms/bpm/engine/test/api/form/task.form"));
    }

    @Test
    public void shouldRetrieveTaskFormBindingLatestWithMultipleVersions() throws IOException {
        this.deployUpdateFormResource(TASK_FORM_CONTENT_V1, TASK_FORM_CONTENT_V2, "org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.taskFormBindingLatest.bpmn");
        this.runtimeService.startProcessInstanceByKey("taskFormBindingLatest");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        InputStream deployedForm = this.formService.getDeployedTaskForm(task.getId());
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat(definitions).hasSize(2);
        this.assertTaskFormData(taskFormData, "myTaskForm", "latest", null);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)TASK_FORM_CONTENT_V2);
    }

    @Test
    public void shouldRetrieveTaskFormBindingDeployment() throws IOException {
        this.deployUpdateFormResource(TASK_FORM_CONTENT_V1, TASK_FORM_CONTENT_V2, "org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.taskFormBindingDeployment.bpmn");
        this.runtimeService.startProcessInstanceByKey("taskFormBindingDeployment");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        InputStream deployedForm = this.formService.getDeployedTaskForm(task.getId());
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat(definitions).hasSize(2);
        this.assertTaskFormData(taskFormData, "myTaskForm", "deployment", null);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)TASK_FORM_CONTENT_V1);
    }

    @Test
    public void shouldRetrieveTaskFormBindingVersionWithMultipleVersions() throws IOException {
        this.deployUpdateFormResource(TASK_FORM_CONTENT_V1, TASK_FORM_CONTENT_V2, "org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.taskFormBindingVersion1.bpmn");
        this.runtimeService.startProcessInstanceByKey("taskFormBindingVersion");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        InputStream deployedForm = this.formService.getDeployedTaskForm(task.getId());
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat(definitions).hasSize(2);
        this.assertTaskFormData(taskFormData, "myTaskForm", "version", 1);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)TASK_FORM_CONTENT_V1);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.taskFormBindingLatest.bpmn"})
    public void shouldFailToRetrieveTaskFormBindingLatestUnexistingKey() throws IOException {
        this.runtimeService.startProcessInstanceByKey("taskFormBindingLatest");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat(definitions).hasSize(0);
        this.assertTaskFormData(taskFormData, "myTaskForm", "latest", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getDeployedTaskForm(task.getId())).isInstanceOf(NotFoundException.class)).hasMessageContaining("No Camunda Form Definition was found for Camunda Form Ref");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.taskFormBindingDeployment.bpmn"})
    public void shouldFailToRetrieveTaskFormBindingDeploymentUnexistingKey() throws IOException {
        this.runtimeService.startProcessInstanceByKey("taskFormBindingDeployment");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat(definitions).hasSize(0);
        this.assertTaskFormData(taskFormData, "myTaskForm", "deployment", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getDeployedTaskForm(task.getId())).isInstanceOf(NotFoundException.class)).hasMessageContaining("No Camunda Form Definition was found for Camunda Form Ref");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.taskFormBindingVersion2.bpmn", "org/eximeebpms/bpm/engine/test/api/form/task.form"})
    public void shouldFailToRetrieveTaskFormBindingVersionUnexistingVersion() throws IOException {
        this.runtimeService.startProcessInstanceByKey("taskFormBindingVersion");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat(definitions).hasSize(1);
        this.assertTaskFormData(taskFormData, "myTaskForm", "version", 2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getDeployedTaskForm(task.getId())).isInstanceOf(NotFoundException.class)).hasMessageContaining("No Camunda Form Definition was found for Camunda Form Ref");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.shouldRetrieveTaskFormBindingLatestWithKeyExpression.bpmn", "org/eximeebpms/bpm/engine/test/api/form/task.form"})
    public void shouldRetrieveTaskFormBindingLatestWithKeyExpression() throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", "myTaskForm");
        this.runtimeService.startProcessInstanceByKey("taskFormBindingLatest", parameters);
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        InputStream deployedForm = this.formService.getDeployedTaskForm(task.getId());
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat(definitions).hasSize(1);
        this.assertTaskFormData(taskFormData, "myTaskForm", "latest", null);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)this.getClasspathResourceContent("org/eximeebpms/bpm/engine/test/api/form/task.form"));
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.shouldRetrieveTaskFormBindingVersionWithExpression.bpmn", "org/eximeebpms/bpm/engine/test/api/form/task.form"})
    public void shouldRetrieveTaskFormBindingVersionWithExpression() throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("ver", "1");
        this.runtimeService.startProcessInstanceByKey("taskFormBindingVersion", parameters);
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData taskFormData = this.formService.getTaskFormData(task.getId());
        InputStream deployedForm = this.formService.getDeployedTaskForm(task.getId());
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat(definitions).hasSize(1);
        this.assertTaskFormData(taskFormData, "myTaskForm", "version", 1);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)this.getClasspathResourceContent("org/eximeebpms/bpm/engine/test/api/form/task.form"));
    }

    @Test
    public void shouldRetrieveStartFormBindingLatestWithSingleVersionSeparateDeloyments() throws IOException {
        this.deployClasspathResources(true, "org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.startFormBindingLatest.bpmn", "org/eximeebpms/bpm/engine/test/api/form/start.form");
        this.runtimeService.startProcessInstanceByKey("startFormBindingLatest");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        InputStream deployedForm = this.formService.getDeployedStartForm(processDefinition.getId());
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat(definitions).hasSize(1);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)this.getClasspathResourceContent("org/eximeebpms/bpm/engine/test/api/form/start.form"));
    }

    @Test
    public void shouldRetrieveStartFormBindingLatestWithMultipleVersions() throws IOException {
        this.deployUpdateFormResource(START_FORM_CONTENT_V1, START_FORM_CONTENT_V2, "org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.startFormBindingLatest.bpmn");
        this.runtimeService.startProcessInstanceByKey("startFormBindingLatest");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        InputStream deployedForm = this.formService.getDeployedStartForm(processDefinition.getId());
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat(definitions).hasSize(2);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)START_FORM_CONTENT_V2);
    }

    @Test
    public void shouldRetrieveStartFormBindingDeployment() throws IOException {
        this.deployUpdateFormResource(START_FORM_CONTENT_V1, START_FORM_CONTENT_V2, "org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.startFormBindingDeployment.bpmn");
        this.runtimeService.startProcessInstanceByKey("startFormBindingDeployment");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        InputStream deployedForm = this.formService.getDeployedStartForm(processDefinition.getId());
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat(definitions).hasSize(2);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)START_FORM_CONTENT_V1);
    }

    @Test
    public void shouldRetrieveStartFormBindingVersionWithMultipleVersions() throws IOException {
        this.deployUpdateFormResource(START_FORM_CONTENT_V1, START_FORM_CONTENT_V2, "org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.startFormBindingVersion1.bpmn");
        this.runtimeService.startProcessInstanceByKey("startFormBindingVersion");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        InputStream deployedForm = this.formService.getDeployedStartForm(processDefinition.getId());
        Assertions.assertThat((List)deployments).hasSize(2);
        Assertions.assertThat(definitions).hasSize(2);
        Assertions.assertThat((String)IOUtils.toString((InputStream)deployedForm, (Charset)StandardCharsets.UTF_8)).isEqualTo((Object)START_FORM_CONTENT_V1);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.startFormBindingLatest.bpmn"})
    public void shouldFailToRetrieveStartFormBindingLatestUnexistingKey() throws IOException {
        this.runtimeService.startProcessInstanceByKey("startFormBindingLatest");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat(definitions).hasSize(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getDeployedStartForm(processDefinition.getId())).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("No Camunda Form Definition was found for Camunda Form Ref");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.startFormBindingDeployment.bpmn"})
    public void shouldFailToRetrieveStartFormBindingDeploymentUnexistingKey() throws IOException {
        this.runtimeService.startProcessInstanceByKey("startFormBindingDeployment");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat(definitions).hasSize(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getDeployedStartForm(processDefinition.getId())).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("No Camunda Form Definition was found for Camunda Form Ref");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/form/RetrieveCamundaFormRefTest.startFormBindingVersion2.bpmn", "org/eximeebpms/bpm/engine/test/api/form/start.form"})
    public void shouldFailToRetrieveStartFormBindingVersionUnexistingVersion() throws IOException {
        this.runtimeService.startProcessInstanceByKey("startFormBindingVersion");
        List deployments = this.repositoryService.createDeploymentQuery().list();
        List<CamundaFormDefinition> definitions = CamundaFormUtils.findAllCamundaFormDefinitionEntities(this.processEngineConfiguration);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat(definitions).hasSize(1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getDeployedStartForm(processDefinition.getId())).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("No Camunda Form Definition was found for Camunda Form Ref");
    }

    private void assertTaskFormData(TaskFormData taskFormData, String expectedKey, String expectedBinding, Integer expectedVersion) {
        CamundaFormRef camundaFormRef = taskFormData.getCamundaFormRef();
        Assertions.assertThat((String)camundaFormRef.getKey()).isEqualTo((Object)expectedKey);
        Assertions.assertThat((String)camundaFormRef.getBinding()).isEqualTo((Object)expectedBinding);
        Assertions.assertThat((Integer)camundaFormRef.getVersion()).isEqualTo((Object)expectedVersion);
        Assertions.assertThat((String)taskFormData.getFormKey()).isNull();
    }

    private String getClasspathResourceContent(String path) throws IOException {
        InputStream inputStream = ReflectUtil.getResourceAsStream((String)path);
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    private void deployClasspathResources(boolean separateDeployments, String ... paths) {
        if (separateDeployments) {
            for (String path : paths) {
                this.testRule.deploy(path);
            }
        } else {
            this.testRule.deploy(paths);
        }
    }

    private void deployUpdateFormResource(String v1Content, String v2Content, String ... additionalResourcesForFirstDeployment) throws IOException {
        FileInputStream form = CamundaFormUtils.writeTempFormFile("form.form", v1Content, this.tempFolder);
        DeploymentBuilder builder = this.repositoryService.createDeployment().name(this.getClass().getSimpleName()).addInputStream("form", (InputStream)form);
        for (String path : additionalResourcesForFirstDeployment) {
            builder.addClasspathResource(path);
        }
        builder.deploy();
        form = CamundaFormUtils.writeTempFormFile("form.form", v2Content, this.tempFolder);
        this.repositoryService.createDeployment().name(this.getClass().getSimpleName()).addInputStream("form", (InputStream)form).deploy();
    }
}

