/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.authorization.BatchPermissions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatch;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RequiredHistoryLevel(value="full")
@RunWith(value=Parameterized.class)
public class BatchHistoricDecisionInstanceDeletionAuthorizationTest {
    protected static String DECISION = "decision";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected DecisionService decisionService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected List<String> decisionInstanceIds;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, "*", "userId", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, "*", "userId", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES}), AuthorizationSpec.grant((Resource)Resources.DECISION_DEFINITION, "*", "userId", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.revoke((Resource)Resources.BATCH, "*", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES}), AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_DELETE_DECISION_INSTANCES})).succeeds());
    }

    @Before
    public void setup() {
        this.historyService = this.engineRule.getHistoryService();
        this.decisionService = this.engineRule.getDecisionService();
        this.managementService = this.engineRule.getManagementService();
        this.decisionInstanceIds = new ArrayList<String>();
    }

    @Before
    public void executeDecisionInstances() {
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn");
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
        for (int i = 0; i < 10; ++i) {
            this.decisionService.evaluateDecisionByKey(DECISION).variables((Map)variables).evaluate();
        }
        List decisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance decisionInstance : decisionInstances) {
            this.decisionInstanceIds.add(decisionInstance.getId());
        }
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @After
    public void removeBatches() {
        for (Batch batch : this.managementService.createBatchQuery().list()) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        for (HistoricBatch historicBatch : this.historyService.createHistoricBatchQuery().list()) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void executeBatch() {
        this.authRule.init(this.scenario).withUser("userId").start();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION);
        Batch batch = this.historyService.deleteHistoricDecisionInstancesAsync(this.decisionInstanceIds, query, null);
        if (batch != null) {
            Job job = (Job)this.managementService.createJobQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).singleResult();
            this.managementService.executeJob(job.getId());
            for (Job pending : this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list()) {
                this.managementService.executeJob(pending.getId());
            }
        }
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((Object)"userId", (Object)batch.getCreateUserId());
        }
    }
}

