/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.history.HistoricDetailQuery;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstanceQuery;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableInstanceQuery;
import org.eximeebpms.bpm.engine.history.NativeHistoricActivityInstanceQuery;
import org.eximeebpms.bpm.engine.history.NativeHistoricProcessInstanceQuery;
import org.eximeebpms.bpm.engine.history.NativeHistoricTaskInstanceQuery;
import org.eximeebpms.bpm.engine.history.NativeHistoricVariableInstanceQuery;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstance;
import org.eximeebpms.bpm.engine.runtime.VariableInstanceQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.CallActivityBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

@RequiredHistoryLevel(value="audit")
public class HistoryServiceTest
extends PluggableProcessEngineTest {
    public static final String ONE_TASK_PROCESS = "oneTaskProcess";
    protected static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQuery() {
        Assert.assertTrue((this.historyService.createHistoricProcessInstanceQuery().count() == 0L ? 1 : 0) != 0);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        Assert.assertTrue((this.historyService.createHistoricProcessInstanceQuery().count() == 1L ? 1 : 0) != 0);
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Assert.assertTrue((this.historyService.createHistoricProcessInstanceQuery().count() == 1L ? 1 : 0) != 0);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessInstanceQueryOrderBy() {
        Assert.assertTrue((this.historyService.createHistoricProcessInstanceQuery().count() == 0L ? 1 : 0) != 0);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByDeleteReason().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByExecutionId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricTaskInstanceDuration().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricTaskInstanceEndTime().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessDefinitionId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByProcessInstanceId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskAssignee().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDefinitionKey().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskDescription().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskId().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskName().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskOwner().asc()).list();
        ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByTaskPriority().asc()).list();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryTaskNameCaseInsensitive() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        List historicTasks = this.historyService.createHistoricTaskInstanceQuery().taskName("my task").list();
        Assert.assertEquals((long)1L, (long)historicTasks.size());
        List historicTasksUcFirst = this.historyService.createHistoricTaskInstanceQuery().taskName("My task").list();
        Assert.assertEquals((long)1L, (long)historicTasksUcFirst.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryTaskNameLikeCaseInsensitive() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        List historicTasks = this.historyService.createHistoricTaskInstanceQuery().taskNameLike("my task").list();
        Assert.assertEquals((long)1L, (long)historicTasks.size());
        List historicTasksUcFirst = this.historyService.createHistoricTaskInstanceQuery().taskNameLike("My task").list();
        Assert.assertEquals((long)1L, (long)historicTasksUcFirst.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryTaskDescriptionCaseInsensitive() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        List historicTasks = this.historyService.createHistoricTaskInstanceQuery().taskDescription("my description").list();
        Assert.assertEquals((long)1L, (long)historicTasks.size());
        List historicTasksUcFirst = this.historyService.createHistoricTaskInstanceQuery().taskDescription("My description").list();
        Assert.assertEquals((long)1L, (long)historicTasksUcFirst.size());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryTaskDescriptionLikeCaseInsensitive() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        List historicTasks = this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("my description").list();
        Assert.assertEquals((long)1L, (long)historicTasks.size());
        List historicTasksUcFirst = this.historyService.createHistoricTaskInstanceQuery().taskDescriptionLike("My description").list();
        Assert.assertEquals((long)1L, (long)historicTasksUcFirst.size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testHistoricProcessInstanceUserIdAndActivityId() {
        this.identityService.setAuthenticatedUserId("johndoe");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)historicProcessInstance.getStartUserId());
        Assert.assertEquals((Object)"theStart", (Object)historicProcessInstance.getStartActivityId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertEquals((Object)"theEnd", (Object)historicProcessInstance.getEndActivityId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/history/orderProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/history/checkCreditProcess.bpmn20.xml"})
    @Test
    public void testOrderProcessWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("orderProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task verifyCreditTask = (Task)taskQuery.singleResult();
        this.taskService.complete(verifyCreditTask.getId(), CollectionUtil.singletonMap((String)"creditApproved", (Object)true));
        Task prepareAndShipTask = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"Prepare and Ship", (Object)prepareAndShipTask.getName());
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertTrue((boolean)historicProcessInstance.getProcessDefinitionId().contains("checkCreditProcess"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/history/orderProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/history/checkCreditProcess.bpmn20.xml"})
    @Test
    public void testHistoricProcessInstanceQueryByProcessDefinitionKey() {
        String processDefinitionKey = ONE_TASK_PROCESS;
        this.runtimeService.startProcessInstanceByKey(processDefinitionKey);
        this.runtimeService.startProcessInstanceByKey("orderProcess");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(processDefinitionKey).singleResult();
        Assert.assertNotNull((Object)historicProcessInstance);
        Assert.assertTrue((boolean)historicProcessInstance.getProcessDefinitionId().startsWith(processDefinitionKey));
        Assert.assertEquals((Object)"theStart", (Object)historicProcessInstance.getStartActivityId());
        Task task = (Task)this.taskService.createTaskQuery().processDefinitionKey("checkCreditProcess").singleResult();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("creditApproved", true);
        this.taskService.complete(task.getId(), map);
        HistoricProcessInstance historicProcessInstanceSub = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("checkCreditProcess").singleResult();
        HistoricProcessInstance historicProcessInstanceSuper = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("orderProcess").singleResult();
        Assert.assertEquals((Object)historicProcessInstanceSuper.getId(), (Object)historicProcessInstanceSub.getSuperProcessInstanceId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/runtime/otherOneTaskProcess.bpmn20.xml"})
    @Test
    public void testHistoricProcessInstanceQueryByProcessInstanceIds() {
        HashSet<String> processInstanceIds = new HashSet<String>();
        for (int i = 0; i < 4; ++i) {
            processInstanceIds.add(this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, "" + i).getId());
        }
        processInstanceIds.add(this.runtimeService.startProcessInstanceByKey("otherOneTaskProcess", "1").getId());
        this.runtimeService.startProcessInstanceByKey("otherOneTaskProcess", "2");
        HistoricProcessInstanceQuery processInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstanceIds);
        Assert.assertEquals((long)5L, (long)processInstanceQuery.count());
        List processInstances = processInstanceQuery.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)5L, (long)processInstances.size());
        for (HistoricProcessInstance historicProcessInstance : processInstances) {
            Assert.assertTrue((boolean)processInstanceIds.contains(historicProcessInstance.getId()));
        }
        Assert.assertEquals((long)0L, (long)processInstanceQuery.processInstanceId("dummy").count());
    }

    @Test
    public void testHistoricProcessInstanceQueryByProcessInstanceIdsEmpty() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(new HashSet());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("Set of process instance ids is empty", re.getMessage());
        }
    }

    @Test
    public void testHistoricProcessInstanceQueryByProcessInstanceIdsNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("Set of process instance ids is null", re.getMessage());
        }
    }

    @Test
    public void testQueryByRootProcessInstances() {
        String superProcess = "calling";
        String subProcess = "called";
        BpmnModelInstance callingInstance = ((CallActivityBuilder)ProcessModels.newModel(superProcess).startEvent().callActivity().calledElement(subProcess)).endEvent().done();
        BpmnModelInstance calledInstance = ProcessModels.newModel(subProcess).startEvent().userTask().endEvent().done();
        this.testRule.deploy(callingInstance, calledInstance);
        String processInstanceId1 = this.runtimeService.startProcessInstanceByKey(superProcess).getProcessInstanceId();
        List list = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances().list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)processInstanceId1, (Object)((HistoricProcessInstance)list.get(0)).getId());
    }

    @Test
    public void testQueryByRootProcessInstancesAndSuperProcess() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances().superProcessInstanceId("processInstanceId");
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid query usage: cannot set both rootProcessInstances and superProcessInstanceId"));
        }
        try {
            this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId("processInstanceId").rootProcessInstances();
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid query usage: cannot set both rootProcessInstances and superProcessInstanceId"));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/concurrentExecution.bpmn20.xml"})
    @Test
    public void testHistoricVariableInstancesOnParallelExecution() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("rootValue", "test");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("concurrent", vars);
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        for (Task task : tasks) {
            HashMap variables = new HashMap();
            LOG.debug("setting variables on task " + task.getId() + ", execution " + task.getExecutionId());
            this.runtimeService.setVariableLocal(task.getExecutionId(), "parallelValue1", (Object)task.getName());
            this.runtimeService.setVariableLocal(task.getExecutionId(), "parallelValue2", (Object)"test");
            this.taskService.complete(task.getId(), variables);
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult()).getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("rootValue", (Object)"test").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("parallelValue1", (Object)"Receive Payment").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("parallelValue1", (Object)"Ship Order").count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("parallelValue2", (Object)"test").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryStringVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("stringVar", "abcdef");
        String processInstance1 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars).getId();
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance1).singleResult()).getId());
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("stringVar2", "ghijkl");
        String processInstance2 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars).getId();
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance2).singleResult()).getId());
        vars = new HashMap();
        vars.put("stringVar", "azerty");
        String processInstance3 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars).getId();
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance3).singleResult()).getId());
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("stringVar", (Object)"abcdef");
        List processInstances = query.list();
        Assertions.assertThat((List)processInstances).hasSize(2);
        Assertions.assertThat((List)processInstances).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance1, processInstance2});
        query = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("stringVar", (Object)"abcdef").variableValueEquals("stringVar2", (Object)"ghijkl");
        HistoricProcessInstance resultInstance = (HistoricProcessInstance)query.singleResult();
        Assertions.assertThat((Object)resultInstance).isNotNull();
        Assertions.assertThat((String)resultInstance.getId()).isEqualTo((Object)processInstance2);
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("stringVar", (Object)"abcdef").singleResult();
        Assertions.assertThat((Object)resultInstance).isNotNull();
        Assertions.assertThat((String)resultInstance.getId()).isEqualTo((Object)processInstance3);
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("stringVar", (Object)"abcdef").singleResult();
        Assertions.assertThat((Object)resultInstance).isNotNull();
        Assertions.assertThat((String)resultInstance.getId()).isEqualTo((Object)processInstance3);
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("stringVar", (Object)"z").singleResult();
        Assertions.assertThat((Object)resultInstance).isNull();
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"abcdef").list();
        Assertions.assertThat((List)processInstances).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance1, processInstance2, processInstance3});
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("stringVar", (Object)"z").count());
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThan("stringVar", (Object)"abcdeg").list();
        Assertions.assertThat((List)processInstances).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance1, processInstance2});
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").list();
        Assertions.assertThat((List)processInstances).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance1, processInstance2, processInstance3});
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"abcdef").list();
        Assertions.assertThat((List)processInstances).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance1, processInstance2});
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"z").list();
        Assertions.assertThat((List)processInstances).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance1, processInstance2, processInstance3});
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("stringVar", (Object)"aa").count());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "azert%").singleResult();
        Assertions.assertThat((String)resultInstance.getId()).isEqualTo((Object)processInstance3);
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "%y").singleResult();
        Assertions.assertThat((String)resultInstance.getId()).isEqualTo((Object)processInstance3);
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "%zer%").singleResult();
        Assertions.assertThat((String)resultInstance.getId()).isEqualTo((Object)processInstance3);
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "a%").list();
        Assertions.assertThat((List)processInstances).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance1, processInstance2, processInstance3});
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLike("stringVar", "%x%").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryDateVariable() throws Exception {
        HashMap<String, Date> vars = new HashMap<String, Date>();
        Date date1 = Calendar.getInstance().getTime();
        vars.put("dateVar", date1);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance1.getId()).singleResult()).getId());
        Date date2 = Calendar.getInstance().getTime();
        vars = new HashMap();
        vars.put("dateVar", date1);
        vars.put("dateVar2", date2);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance2.getId()).singleResult()).getId());
        Calendar nextYear = Calendar.getInstance();
        nextYear.add(1, 1);
        vars = new HashMap();
        vars.put("dateVar", nextYear.getTime());
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        this.taskService.complete(((Task)this.taskService.createTaskQuery().processInstanceId(processInstance3.getId()).singleResult()).getId());
        Calendar nextMonth = Calendar.getInstance();
        nextMonth.add(2, 1);
        Calendar twoYearsLater = Calendar.getInstance();
        twoYearsLater.add(1, 2);
        Calendar oneYearAgo = Calendar.getInstance();
        oneYearAgo.add(1, -1);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("dateVar", (Object)date1);
        List processInstances = query.list();
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.size());
        query = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("dateVar", (Object)date1).variableValueEquals("dateVar2", (Object)date2);
        HistoricProcessInstance resultInstance = (HistoricProcessInstance)query.singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance2.getId(), (Object)resultInstance.getId());
        Date unexistingDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss").parse("01/01/1989 12:00:00");
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("dateVar", (Object)unexistingDate).singleResult();
        Assert.assertNull((Object)resultInstance);
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("dateVar", (Object)date1).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)nextYear.getTime()).count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("dateVar", (Object)oneYearAgo.getTime()).count());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextMonth.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        resultInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)nextYear.getTime()).singleResult();
        Assert.assertNotNull((Object)resultInstance);
        Assert.assertEquals((Object)processInstance3.getId(), (Object)resultInstance.getId());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThan("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
        List<String> expecedIds = Arrays.asList(processInstance1.getId(), processInstance2.getId());
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(((HistoricProcessInstance)processInstances.get(0)).getId(), ((HistoricProcessInstance)processInstances.get(1)).getId()));
        ids.removeAll(expecedIds);
        Assert.assertTrue((boolean)ids.isEmpty());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThan("dateVar", (Object)date1).count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThan("dateVar", (Object)twoYearsLater.getTime()).count());
        processInstances = this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("dateVar", (Object)nextYear.getTime()).list();
        Assert.assertEquals((long)3L, (long)processInstances.size());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueLessThanOrEqual("dateVar", (Object)oneYearAgo.getTime()).count());
        this.historyService.deleteHistoricProcessInstance(processInstance1.getId());
        this.historyService.deleteHistoricProcessInstance(processInstance2.getId());
        this.historyService.deleteHistoricProcessInstance(processInstance3.getId());
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryMultipleVariableValuesEquals() {
        String var1 = "var1";
        String var2 = "var2";
        String val1 = "val1";
        String val2 = "val2";
        String val3 = "val3";
        VariableMap variables = Variables.createVariables().putValue(var1, (Object)val1).putValue(var2, (Object)val1);
        String processInstance1 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, (Map)variables).getId();
        variables = Variables.createVariables().putValue(var1, (Object)val2).putValue(var2, (Object)val2);
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, (Map)variables).getId();
        variables = Variables.createVariables().putValue(var1, (Object)val3).putValue(var2, (Object)val3);
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, (Map)variables).getId();
        List instances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals(var1, (Object)val1).variableValueEquals(var2, (Object)val1).list();
        Assertions.assertThat((List)instances).extracting("id").containsExactly(new Object[]{processInstance1});
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryMultipleVariableValuesEqualsAndNotEquals() {
        String var1 = "var1";
        String var2 = "var2";
        String val1 = "val1";
        String val2 = "val2";
        VariableMap variables = Variables.createVariables().putValue(var1, (Object)val1).putValue(var2, (Object)val1);
        String processInstance1 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, (Map)variables).getId();
        variables = Variables.createVariables().putValue(var1, (Object)val1).putValue(var2, (Object)val2);
        String processInstance2 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, (Map)variables).getId();
        variables = Variables.createVariables().putValue(var1, (Object)val2).putValue(var2, (Object)val2);
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, (Map)variables).getId();
        List instances = this.historyService.createHistoricProcessInstanceQuery().variableValueEquals(var1, (Object)val1).variableValueNotEquals(var2, (Object)"yet another value").list();
        Assertions.assertThat((List)instances).extracting("id").containsExactlyInAnyOrder(new Object[]{processInstance1, processInstance2});
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testNativeHistoricProcessInstanceTest() {
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        Assert.assertEquals((long)1L, (long)((NativeHistoricProcessInstanceQuery)this.historyService.createNativeHistoricProcessInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).count());
        Assert.assertEquals((long)1L, (long)((NativeHistoricProcessInstanceQuery)this.historyService.createNativeHistoricProcessInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).list().size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testNativeHistoricTaskInstanceTest() {
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        Assert.assertEquals((long)1L, (long)((NativeHistoricTaskInstanceQuery)this.historyService.createNativeHistoricTaskInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).count());
        Assert.assertEquals((long)1L, (long)((NativeHistoricTaskInstanceQuery)this.historyService.createNativeHistoricTaskInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).list().size());
        Assert.assertEquals((long)1L, (long)((NativeHistoricTaskInstanceQuery)this.historyService.createNativeHistoricTaskInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).listPage(0, 1).size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testNativeHistoricActivityInstanceTest() {
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        Assert.assertEquals((long)1L, (long)((NativeHistoricActivityInstanceQuery)this.historyService.createNativeHistoricActivityInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).count());
        Assert.assertEquals((long)1L, (long)((NativeHistoricActivityInstanceQuery)this.historyService.createNativeHistoricActivityInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).list().size());
        Assert.assertEquals((long)1L, (long)((NativeHistoricActivityInstanceQuery)this.historyService.createNativeHistoricActivityInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricProcessInstance.class))).listPage(0, 1).size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testNativeHistoricVariableInstanceTest() {
        Date date = Calendar.getInstance().getTime();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("stringVar", "abcdef");
        vars.put("dateVar", date);
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, vars);
        Assert.assertEquals((long)2L, (long)((NativeHistoricVariableInstanceQuery)this.historyService.createNativeHistoricVariableInstanceQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(HistoricVariableInstance.class))).count());
        Assert.assertEquals((long)1L, (long)((NativeHistoricVariableInstanceQuery)this.historyService.createNativeHistoricVariableInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricVariableInstance.class))).listPage(0, 1).size());
        List variables = ((NativeHistoricVariableInstanceQuery)this.historyService.createNativeHistoricVariableInstanceQuery().sql("SELECT * FROM " + this.managementService.getTableName(HistoricVariableInstance.class))).list();
        Assert.assertEquals((long)2L, (long)variables.size());
        for (HistoricVariableInstance variable : variables) {
            Assert.assertTrue((boolean)vars.containsKey(variable.getName()));
            Assert.assertEquals(vars.get(variable.getName()), (Object)variable.getValue());
            vars.remove(variable.getName());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS, Collections.singletonMap("var", "123"));
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        this.historyService.deleteHistoricProcessInstance(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteRunningProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        try {
            this.historyService.deleteHistoricProcessInstance(processInstance.getId());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Process instance is still running, cannot delete historic process instance", ae.getMessage());
        }
    }

    @Test
    public void testDeleteProcessInstanceWithFake() {
        try {
            this.historyService.deleteHistoricProcessInstance("aFake");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("No historic process instance found with id", ae.getMessage());
        }
    }

    @Test
    public void testDeleteProcessInstanceIfExistsWithFake() {
        this.historyService.deleteHistoricProcessInstanceIfExists("aFake");
    }

    @Test
    public void testDeleteProcessInstanceNullId() {
        try {
            this.historyService.deleteHistoricProcessInstance(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("processInstanceId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstances() {
        List<String> ids = this.prepareHistoricProcesses();
        this.historyService.deleteHistoricProcessInstances(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesWithFake() {
        List<String> ids = this.prepareHistoricProcesses();
        ids.add("aFake");
        try {
            this.historyService.deleteHistoricProcessInstances(ids);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No historic process instance found with id: [aFake]"));
        }
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesIfExistsWithFake() {
        List<String> ids = this.prepareHistoricProcesses();
        ids.add("aFake");
        this.historyService.deleteHistoricProcessInstancesIfExists(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesWithNull() {
        try {
            this.historyService.deleteHistoricProcessInstances(null);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteHistoricVariableAndDetails() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        String executionId = processInstance.getId();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue1");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue2");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue3");
        this.runtimeService.setVariable(executionId, "mySecondVariable", (Object)5L);
        this.runtimeService.deleteProcessInstance(executionId, null);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        HistoricVariableInstanceQuery histVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("myVariable");
        HistoricVariableInstanceQuery secondHistVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("mySecondVariable");
        Assert.assertEquals((long)1L, (long)histVariableQuery.count());
        Assert.assertEquals((long)1L, (long)secondHistVariableQuery.count());
        String variableInstanceId = ((HistoricVariableInstance)histVariableQuery.singleResult()).getId();
        String secondVariableInstanceId = ((HistoricVariableInstance)secondHistVariableQuery.singleResult()).getId();
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(variableInstanceId);
        HistoricDetailQuery secondDetailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(secondVariableInstanceId);
        Assert.assertEquals((long)3L, (long)detailsQuery.count());
        Assert.assertEquals((long)1L, (long)secondDetailsQuery.count());
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        Assert.assertEquals((long)0L, (long)histVariableQuery.count());
        Assert.assertEquals((long)1L, (long)secondHistVariableQuery.count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
        Assert.assertEquals((long)1L, (long)secondDetailsQuery.count());
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteHistoricVariableAndDetailsOnRunningInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        String executionId = processInstance.getId();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue1");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue2");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue3");
        VariableInstanceQuery variableQuery = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{executionId}).variableName("myVariable");
        Assert.assertEquals((long)1L, (long)variableQuery.count());
        Assert.assertEquals((Object)"testValue3", (Object)((VariableInstance)variableQuery.singleResult()).getValue());
        HistoricVariableInstanceQuery histVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("myVariable");
        Assert.assertEquals((long)1L, (long)histVariableQuery.count());
        String variableInstanceId = ((HistoricVariableInstance)histVariableQuery.singleResult()).getId();
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(variableInstanceId);
        Assert.assertEquals((long)3L, (long)detailsQuery.count());
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        Assert.assertEquals((long)0L, (long)histVariableQuery.count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
        Assert.assertEquals((long)1L, (long)variableQuery.count());
        Assert.assertEquals((Object)"testValue3", (Object)((VariableInstance)variableQuery.singleResult()).getValue());
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteHistoricVariableAndDetailsOnRunningInstanceAndSetAgain() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        String executionId = processInstance.getId();
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue1");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue2");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue3");
        VariableInstanceQuery variableQuery = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{executionId}).variableName("myVariable");
        HistoricVariableInstanceQuery histVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("myVariable");
        String variableInstanceId = ((HistoricVariableInstance)histVariableQuery.singleResult()).getId();
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(variableInstanceId);
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        Assert.assertEquals((long)0L, (long)histVariableQuery.count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
        Assert.assertEquals((long)1L, (long)variableQuery.count());
        Assert.assertEquals((Object)"testValue3", (Object)((VariableInstance)variableQuery.singleResult()).getValue());
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue4");
        Assert.assertEquals((long)1L, (long)histVariableQuery.count());
        Assert.assertEquals((long)1L, (long)detailsQuery.count());
        Assert.assertEquals((long)1L, (long)variableQuery.count());
        Assert.assertEquals((Object)"testValue4", (Object)((VariableInstance)variableQuery.singleResult()).getValue());
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testDeleteHistoricVariableAndDetailsFromCase() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)1);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)2);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)3);
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().caseInstanceId(caseInstanceId).variableInstanceId(variableInstance.getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)3L, (long)detailsQuery.count());
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testDeleteHistoricVariableAndDetailsFromCaseAndSetAgain() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)1);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)2);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)3);
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().caseInstanceId(caseInstanceId).variableInstanceId(variableInstance.getId());
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)4);
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)detailsQuery.count());
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testDeleteHistoricVariableAndDetailsFromStandaloneTask() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue");
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue2");
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().taskId(task.getId()).variableInstanceId(variableInstance.getId());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)2L, (long)detailsQuery.count());
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
        this.taskService.deleteTask(task.getId(), true);
    }

    @RequiredHistoryLevel(value="full")
    @Test
    public void testDeleteHistoricVariableAndDetailsFromStandaloneTaskAndSetAgain() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue");
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue2");
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().taskId(task.getId()).variableInstanceId(variableInstance.getId());
        this.historyService.deleteHistoricVariableInstance(variableInstance.getId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
        this.taskService.setVariable(task.getId(), "testVariable", (Object)"testValue3");
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)detailsQuery.count());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testDeleteUnknownHistoricVariable() {
        try {
            this.historyService.deleteHistoricVariableInstance("fakeID");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("No historic variable instance found with id: fakeID", ae.getMessage());
        }
    }

    @Test
    public void testDeleteHistoricVariableWithNull() {
        try {
            this.historyService.deleteHistoricVariableInstance(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("variableInstanceId is null", ae.getMessage());
        }
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteAllHistoricVariablesAndDetails() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        String executionId = processInstance.getId();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue1");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue2");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue3");
        this.runtimeService.setVariable(executionId, "mySecondVariable", (Object)5L);
        this.runtimeService.setVariable(executionId, "mySecondVariable", (Object)7L);
        this.runtimeService.deleteProcessInstance(executionId, null);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        HistoricVariableInstanceQuery histVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("myVariable");
        HistoricVariableInstanceQuery secondHistVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("mySecondVariable");
        Assert.assertEquals((long)1L, (long)histVariableQuery.count());
        Assert.assertEquals((long)1L, (long)secondHistVariableQuery.count());
        String variableInstanceId = ((HistoricVariableInstance)histVariableQuery.singleResult()).getId();
        String secondVariableInstanceId = ((HistoricVariableInstance)secondHistVariableQuery.singleResult()).getId();
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(variableInstanceId);
        HistoricDetailQuery secondDetailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(secondVariableInstanceId);
        Assert.assertEquals((long)3L, (long)detailsQuery.count());
        Assert.assertEquals((long)2L, (long)secondDetailsQuery.count());
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(executionId);
        Assert.assertEquals((long)0L, (long)histVariableQuery.count());
        Assert.assertEquals((long)0L, (long)secondHistVariableQuery.count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
        Assert.assertEquals((long)0L, (long)secondDetailsQuery.count());
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteAllHistoricVariablesAndDetailsOnRunningInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        String executionId = processInstance.getId();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue1");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue2");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue3");
        this.runtimeService.setVariable(executionId, "mySecondVariable", (Object)"testValue1");
        this.runtimeService.setVariable(executionId, "mySecondVariable", (Object)"testValue2");
        VariableInstanceQuery variableQuery = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{executionId}).variableName("myVariable");
        VariableInstanceQuery secondVariableQuery = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{executionId}).variableName("mySecondVariable");
        Assert.assertEquals((long)1L, (long)variableQuery.count());
        Assert.assertEquals((long)1L, (long)secondVariableQuery.count());
        Assert.assertEquals((Object)"testValue3", (Object)((VariableInstance)variableQuery.singleResult()).getValue());
        Assert.assertEquals((Object)"testValue2", (Object)((VariableInstance)secondVariableQuery.singleResult()).getValue());
        HistoricVariableInstanceQuery histVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("myVariable");
        HistoricVariableInstanceQuery secondHistVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("mySecondVariable");
        Assert.assertEquals((long)1L, (long)histVariableQuery.count());
        Assert.assertEquals((long)1L, (long)secondHistVariableQuery.count());
        String variableInstanceId = ((HistoricVariableInstance)histVariableQuery.singleResult()).getId();
        String secondVariableInstanceId = ((HistoricVariableInstance)secondHistVariableQuery.singleResult()).getId();
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(variableInstanceId);
        HistoricDetailQuery secondDetailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(secondVariableInstanceId);
        Assert.assertEquals((long)3L, (long)detailsQuery.count());
        Assert.assertEquals((long)2L, (long)secondDetailsQuery.count());
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(executionId);
        HistoricVariableInstanceQuery allHistVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId);
        HistoricDetailQuery allDetailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId);
        Assert.assertEquals((long)0L, (long)histVariableQuery.count());
        Assert.assertEquals((long)0L, (long)secondHistVariableQuery.count());
        Assert.assertEquals((long)0L, (long)allHistVariableQuery.count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
        Assert.assertEquals((long)0L, (long)secondDetailsQuery.count());
        Assert.assertEquals((long)0L, (long)allDetailsQuery.count());
        Assert.assertEquals((long)1L, (long)variableQuery.count());
        Assert.assertEquals((Object)"testValue3", (Object)((VariableInstance)variableQuery.singleResult()).getValue());
        Assert.assertEquals((Object)"testValue2", (Object)((VariableInstance)secondVariableQuery.singleResult()).getValue());
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteAllHistoricVariablesAndDetailsOnRunningInstanceAndSetAgain() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        String executionId = processInstance.getId();
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue1");
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue2");
        this.runtimeService.setVariable(executionId, "mySecondVariable", (Object)"testValue1");
        this.runtimeService.setVariable(executionId, "mySecondVariable", (Object)"testValue2");
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(executionId);
        VariableInstanceQuery variableQuery = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{executionId}).variableName("myVariable");
        VariableInstanceQuery secondVariableQuery = this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{executionId}).variableName("mySecondVariable");
        HistoricVariableInstanceQuery allHistVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId);
        HistoricDetailQuery allDetailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId);
        Assert.assertEquals((long)0L, (long)allHistVariableQuery.count());
        Assert.assertEquals((long)0L, (long)allDetailsQuery.count());
        Assert.assertEquals((long)1L, (long)variableQuery.count());
        Assert.assertEquals((long)1L, (long)secondVariableQuery.count());
        Assert.assertEquals((Object)"testValue2", (Object)((VariableInstance)variableQuery.singleResult()).getValue());
        Assert.assertEquals((Object)"testValue2", (Object)((VariableInstance)secondVariableQuery.singleResult()).getValue());
        this.runtimeService.setVariable(executionId, "myVariable", (Object)"testValue3");
        this.runtimeService.setVariable(executionId, "mySecondVariable", (Object)"testValue3");
        HistoricVariableInstanceQuery histVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("myVariable");
        HistoricVariableInstanceQuery secondHistVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId).variableName("mySecondVariable");
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(((HistoricVariableInstance)histVariableQuery.singleResult()).getId());
        HistoricDetailQuery secondDetailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId).variableInstanceId(((HistoricVariableInstance)secondHistVariableQuery.singleResult()).getId());
        Assert.assertEquals((long)1L, (long)histVariableQuery.count());
        Assert.assertEquals((long)1L, (long)secondHistVariableQuery.count());
        Assert.assertEquals((long)2L, (long)allHistVariableQuery.count());
        Assert.assertEquals((long)1L, (long)detailsQuery.count());
        Assert.assertEquals((long)1L, (long)secondDetailsQuery.count());
        Assert.assertEquals((long)2L, (long)allDetailsQuery.count());
        Assert.assertEquals((long)1L, (long)variableQuery.count());
        Assert.assertEquals((long)1L, (long)secondVariableQuery.count());
        Assert.assertEquals((Object)"testValue3", (Object)((VariableInstance)variableQuery.singleResult()).getValue());
        Assert.assertEquals((Object)"testValue3", (Object)((VariableInstance)secondVariableQuery.singleResult()).getValue());
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteAllHistoricVariablesOnEmpty() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        String executionId = processInstance.getId();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        this.runtimeService.deleteProcessInstance(executionId, null);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey(ONE_TASK_PROCESS).count());
        HistoricVariableInstanceQuery histVariableQuery = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(executionId);
        Assert.assertEquals((long)0L, (long)histVariableQuery.count());
        HistoricDetailQuery detailsQuery = this.historyService.createHistoricDetailQuery().processInstanceId(executionId);
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
        this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(executionId);
        Assert.assertEquals((long)0L, (long)histVariableQuery.count());
        Assert.assertEquals((long)0L, (long)detailsQuery.count());
    }

    @Test
    public void testDeleteAllHistoricVariablesOnUnkownProcessInstance() {
        try {
            this.historyService.deleteHistoricVariableInstancesByProcessInstanceId("fakeID");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("No historic process instance found with id: fakeID", ae.getMessage());
        }
    }

    @Test
    public void testDeleteAllHistoricVariablesWithNull() {
        try {
            this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("processInstanceId is null", ae.getMessage());
        }
    }

    protected List<String> prepareHistoricProcesses() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS);
        ArrayList<String> processInstanceIds = new ArrayList<String>(Arrays.asList(processInstance.getId(), processInstance2.getId()));
        this.runtimeService.deleteProcessInstances(processInstanceIds, null, true, true);
        return processInstanceIds;
    }
}

