/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.history.removaltime;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import org.eximeebpms.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.ExternalTaskService;
import org.eximeebpms.bpm.engine.FormService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.history.HistoricIncident;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.task.Attachment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ResetDmnConfigUtil;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public abstract class AbstractRemovalTimeTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected FormService formService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected ManagementService managementService;
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ExternalTaskService externalTaskService;
    protected DecisionService decisionService;
    protected AuthorizationService authorizationService;
    protected static ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.formService = this.engineRule.getFormService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.managementService = this.engineRule.getManagementService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.decisionService = this.engineRule.getDecisionService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        DefaultDmnEngineConfiguration dmnEngineConfiguration = processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @AfterClass
    public static void tearDownAfterAll() {
        if (processEngineConfiguration != null) {
            processEngineConfiguration.setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy(null).initHistoryRemovalTime();
            processEngineConfiguration.setBatchOperationHistoryTimeToLive(null);
            processEngineConfiguration.setBatchOperationsForHistoryCleanup(null);
            processEngineConfiguration.initHistoryCleanup();
            DefaultDmnEngineConfiguration dmnEngineConfiguration = processEngineConfiguration.getDmnEngineConfiguration();
            ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
            processEngineConfiguration.setEnableHistoricInstancePermissions(false);
            processEngineConfiguration.setAuthorizationEnabled(false);
        }
        ClockUtil.reset();
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        return (ByteArrayEntity)commandExecutor.execute((Command)new GetByteArrayCommand(byteArrayId));
    }

    protected void clearAttachment(final Attachment attachment) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getAttachmentManager().delete((DbEntity)((AttachmentEntity)attachment));
                return null;
            }
        });
    }

    protected void clearCommentByTaskId(final String taskId) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getCommentManager().deleteCommentsByTaskId(taskId);
                return null;
            }
        });
    }

    protected void clearCommentByProcessInstanceId(final String processInstanceId) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getCommentManager().deleteCommentsByProcessInstanceIds(Collections.singletonList(processInstanceId));
                return null;
            }
        });
    }

    protected void clearHistoricTaskInst(final String taskId) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(taskId);
                commandContext.getHistoricIdentityLinkManager().deleteHistoricIdentityLinksLogByTaskId(taskId);
                return null;
            }
        });
    }

    protected void clearJobLog(final String jobId) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                return null;
            }
        });
    }

    protected void clearHistoricIncident(final HistoricIncident historicIncident) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricIncidentManager().delete((DbEntity)((HistoricIncidentEntity)historicIncident));
                return null;
            }
        });
    }

    protected void clearAuthorization() {
        this.authorizationService.createAuthorizationQuery().list().forEach(authorization -> this.authorizationService.deleteAuthorization(authorization.getId()));
    }

    protected Date addDays(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, amount);
        return c.getTime();
    }

    protected void enabledAuth() {
        processEngineConfiguration.setAuthorizationEnabled(true);
    }

    protected void disableAuth() {
        processEngineConfiguration.setAuthorizationEnabled(false);
    }
}

