/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.identity;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.OptimisticLockingException;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class IdentityServiceWithJdbcSimpleProcessingTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setJdbcBatchProcessing(false));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected IdentityService identityService;

    @Before
    public void init() {
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
    }

    @Test
    public void testUserOptimisticLockingException() {
        User user = this.identityService.newUser("kermit");
        this.identityService.saveUser(user);
        User user1 = (User)this.identityService.createUserQuery().singleResult();
        User user2 = (User)this.identityService.createUserQuery().singleResult();
        user1.setFirstName("name one");
        this.identityService.saveUser(user1);
        user2.setFirstName("name two");
        Assertions.assertThatThrownBy(() -> this.identityService.saveUser(user2)).isInstanceOf(OptimisticLockingException.class);
    }

    @Test
    public void testGroupOptimisticLockingException() {
        Group group = this.identityService.newGroup("group");
        this.identityService.saveGroup(group);
        Group group1 = (Group)this.identityService.createGroupQuery().singleResult();
        Group group2 = (Group)this.identityService.createGroupQuery().singleResult();
        group1.setName("name one");
        this.identityService.saveGroup(group1);
        group2.setName("name two");
        Assertions.assertThatThrownBy(() -> this.identityService.saveGroup(group2)).isInstanceOf(OptimisticLockingException.class);
    }
}

