/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.identity;

import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.identity.NativeUserQuery;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.identity.UserQuery;
import org.eximeebpms.bpm.engine.impl.persistence.entity.UserEntity;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserQueryTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        this.createUser("kermit", "Kermit_", "The_frog", "kermit_@muppetshow.com");
        this.createUser("fozzie", "Fozzie", "Bear", "fozzie@muppetshow.com");
        this.createUser("gonzo", "Gonzo", "The great", "gonzo@muppetshow.com");
        this.identityService.saveGroup(this.identityService.newGroup("muppets"));
        this.identityService.saveGroup(this.identityService.newGroup("frogs"));
        this.identityService.saveTenant(this.identityService.newTenant("tenant"));
        this.identityService.createMembership("kermit", "muppets");
        this.identityService.createMembership("kermit", "frogs");
        this.identityService.createMembership("fozzie", "muppets");
        this.identityService.createMembership("gonzo", "muppets");
        this.identityService.createTenantUserMembership("tenant", "kermit");
    }

    private User createUser(String id, String firstName, String lastName, String email) {
        User user = this.identityService.newUser(id);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmail(email);
        this.identityService.saveUser(user);
        return user;
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("gonzo");
        this.identityService.deleteGroup("muppets");
        this.identityService.deleteGroup("frogs");
        this.identityService.deleteTenant("tenant");
    }

    @Test
    public void testQueryByNoCriteria() {
        UserQuery query = this.identityService.createUserQuery();
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryById() {
        UserQuery query = this.identityService.createUserQuery().userId("kermit");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidId() {
        UserQuery query = this.identityService.createUserQuery().userId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userId(null).singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByFirstName() {
        UserQuery query = this.identityService.createUserQuery().userFirstName("Gonzo");
        this.verifyQueryResults(query, 1);
        User result = (User)query.singleResult();
        Assert.assertEquals((Object)"gonzo", (Object)result.getId());
    }

    @Test
    public void testQueryByInvalidFirstName() {
        UserQuery query = this.identityService.createUserQuery().userFirstName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userFirstName(null).singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByFirstNameLike() {
        UserQuery query = this.identityService.createUserQuery().userFirstNameLike("%o%");
        this.verifyQueryResults(query, 2);
        query = this.identityService.createUserQuery().userFirstNameLike("Ker%");
        this.verifyQueryResults(query, 1);
        this.identityService.createUserQuery().userFirstNameLike("%mit\\_");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidFirstNameLike() {
        UserQuery query = this.identityService.createUserQuery().userFirstNameLike("%mispiggy%");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userFirstNameLike(null).singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByLastName() {
        UserQuery query = this.identityService.createUserQuery().userLastName("Bear");
        this.verifyQueryResults(query, 1);
        User result = (User)query.singleResult();
        Assert.assertEquals((Object)"fozzie", (Object)result.getId());
    }

    @Test
    public void testQueryByInvalidLastName() {
        UserQuery query = this.identityService.createUserQuery().userLastName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userLastName(null).singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByLastNameLike() {
        UserQuery query = this.identityService.createUserQuery().userLastNameLike("%\\_frog%");
        this.verifyQueryResults(query, 1);
        query = this.identityService.createUserQuery().userLastNameLike("%ea%");
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByInvalidLastNameLike() {
        UserQuery query = this.identityService.createUserQuery().userLastNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userLastNameLike(null).singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByEmail() {
        UserQuery query = this.identityService.createUserQuery().userEmail("kermit_@muppetshow.com");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidEmail() {
        UserQuery query = this.identityService.createUserQuery().userEmail("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userEmail(null).singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByEmailLike() {
        UserQuery query = this.identityService.createUserQuery().userEmailLike("%muppetshow.com");
        this.verifyQueryResults(query, 3);
        query = this.identityService.createUserQuery().userEmailLike("%kermit\\_%");
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidEmailLike() {
        UserQuery query = this.identityService.createUserQuery().userEmailLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().userEmailLike(null).singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySorting() {
        Assert.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserId().asc()).count());
        Assert.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserEmail().asc()).count());
        Assert.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserFirstName().asc()).count());
        Assert.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserLastName().asc()).count());
        Assert.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserId().desc()).count());
        Assert.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserEmail().desc()).count());
        Assert.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserFirstName().desc()).count());
        Assert.assertEquals((long)3L, (long)((UserQuery)this.identityService.createUserQuery().orderByUserLastName().desc()).count());
        UserQuery query = (UserQuery)this.identityService.createUserQuery().userLastNameLike("%ea%").orderByUserFirstName().asc();
        List users = query.list();
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)"Fozzie", (Object)((User)users.get(0)).getFirstName());
        Assert.assertEquals((Object)"Gonzo", (Object)((User)users.get(1)).getFirstName());
    }

    @Test
    public void testQueryInvalidSortingUsage() {
        try {
            this.identityService.createUserQuery().orderByUserId().list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.identityService.createUserQuery().orderByUserId().orderByUserEmail().list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByMemberOfGroup() {
        UserQuery query = this.identityService.createUserQuery().memberOfGroup("muppets");
        this.verifyQueryResults(query, 3);
        query = this.identityService.createUserQuery().memberOfGroup("frogs");
        this.verifyQueryResults(query, 1);
        User result = (User)query.singleResult();
        Assert.assertEquals((Object)"kermit", (Object)result.getId());
    }

    @Test
    public void testQueryByInvalidMemberOfGoup() {
        UserQuery query = this.identityService.createUserQuery().memberOfGroup("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createUserQuery().memberOfGroup(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByMemberOfTenant() {
        UserQuery query = this.identityService.createUserQuery().memberOfTenant("nonExisting");
        this.verifyQueryResults(query, 0);
        query = this.identityService.createUserQuery().memberOfTenant("tenant");
        this.verifyQueryResults(query, 1);
        User result = (User)query.singleResult();
        Assert.assertEquals((Object)"kermit", (Object)result.getId());
    }

    private void verifyQueryResults(UserQuery query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(UserQuery query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByIdIn() {
        Assert.assertTrue((boolean)this.identityService.createUserQuery().userIdIn(new String[]{"a", "b"}).list().isEmpty());
        List list = this.identityService.createUserQuery().list();
        String[] ids = new String[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((User)list.get(i)).getId();
        }
        List idInList = this.identityService.createUserQuery().userIdIn(ids).list();
        for (User user : idInList) {
            boolean found = false;
            for (User otherUser : list) {
                if (!otherUser.getId().equals(user.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail((String)("Expected to find user " + String.valueOf(user)));
        }
    }

    @Test
    public void testNativeQuery() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        Assert.assertEquals((Object)(tablePrefix + "ACT_ID_USER"), (Object)this.managementService.getTableName(UserEntity.class));
        long userCount = this.identityService.createUserQuery().count();
        Assert.assertEquals((long)userCount, (long)((NativeUserQuery)this.identityService.createNativeUserQuery().sql("SELECT * FROM " + this.managementService.getTableName(UserEntity.class))).list().size());
        Assert.assertEquals((long)userCount, (long)((NativeUserQuery)this.identityService.createNativeUserQuery().sql("SELECT count(*) FROM " + this.managementService.getTableName(UserEntity.class))).count());
    }

    @Test
    public void testNativeQueryOrLike() {
        String searchPattern = "%frog";
        String fromWhereClauses = String.format("FROM %s WHERE FIRST_ LIKE #{searchPattern} OR LAST_ LIKE #{searchPattern} OR EMAIL_ LIKE #{searchPattern}", this.managementService.getTableName(UserEntity.class));
        Assert.assertEquals((long)1L, (long)((NativeUserQuery)((NativeUserQuery)this.identityService.createNativeUserQuery().sql("SELECT * " + fromWhereClauses)).parameter("searchPattern", (Object)searchPattern)).list().size());
        Assert.assertEquals((long)1L, (long)((NativeUserQuery)((NativeUserQuery)this.identityService.createNativeUserQuery().sql("SELECT count(*) " + fromWhereClauses)).parameter("searchPattern", (Object)searchPattern)).count());
    }

    @Test
    public void testNativeQueryPaging() {
        Assert.assertEquals((long)2L, (long)((NativeUserQuery)this.identityService.createNativeUserQuery().sql("SELECT * FROM " + this.managementService.getTableName(UserEntity.class))).listPage(1, 2).size());
        Assert.assertEquals((long)1L, (long)((NativeUserQuery)this.identityService.createNativeUserQuery().sql("SELECT * FROM " + this.managementService.getTableName(UserEntity.class))).listPage(2, 1).size());
    }
}

