/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.dmn.engine.DmnDecisionResult;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyDecisionEvaluationTest
extends PluggableProcessEngineTest {
    protected static final String DMN_FILE = "org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn";
    protected static final String DMN_FILE_SECOND_VERSION = "org/eximeebpms/bpm/engine/test/api/dmn/Example_v2.dmn";
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String RESULT_OF_FIRST_VERSION = "ok";
    protected static final String RESULT_OF_SECOND_VERSION = "notok";

    @Test
    public void testFailToEvaluateDecisionByIdWithoutTenantId() {
        this.testRule.deploy(DMN_FILE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        try {
            this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).decisionDefinitionWithoutTenantId().evaluate();
            Assert.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot specify a tenant-id"});
        }
    }

    @Test
    public void testFailToEvaluateDecisionByIdWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        try {
            this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).decisionDefinitionTenantId(TENANT_ONE).evaluate();
            Assert.fail((String)"BadUserRequestException exception");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot specify a tenant-id"});
        }
    }

    @Test
    public void testFailToEvaluateDecisionByKeyForNonExistingTenantID() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE);
        try {
            this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).decisionDefinitionTenantId("nonExistingTenantId").evaluate();
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no decision definition deployed with key 'decision' and tenant-id 'nonExistingTenantId'"});
        }
    }

    @Test
    public void testFailToEvaluateDecisionByKeyForMultipleTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE);
        try {
            this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"multiple tenants."});
        }
    }

    @Test
    public void testEvaluateDecisionByKeyWithoutTenantId() {
        this.testRule.deploy(DMN_FILE);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).decisionDefinitionWithoutTenantId().evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Test
    public void testEvaluateDecisionByKeyForAnyTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Test
    public void testEvaluateDecisionByKeyAndTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE_SECOND_VERSION);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).decisionDefinitionTenantId(TENANT_ONE).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Test
    public void testEvaluateDecisionByKeyLatestVersionAndTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE_SECOND_VERSION);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).decisionDefinitionTenantId(TENANT_ONE).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_SECOND_VERSION);
    }

    @Test
    public void testEvaluateDecisionByKeyVersionAndTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE_SECOND_VERSION);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).version(Integer.valueOf(1)).decisionDefinitionTenantId(TENANT_TWO).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Test
    public void testEvaluateDecisionByKeyWithoutTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deploy(DMN_FILE);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).decisionDefinitionWithoutTenantId().variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Test
    public void testFailToEvaluateDecisionByKeyNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        try {
            this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no decision definition deployed with key 'decision'"});
        }
    }

    @Test
    public void testFailToEvaluateDecisionByKeyWithTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        try {
            this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).decisionDefinitionTenantId(TENANT_ONE).variables((Map)this.createVariables()).evaluate();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot evaluate the decision"});
        }
    }

    @Test
    public void testFailToEvaluateDecisionByIdNoAuthenticatedTenants() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, null);
        try {
            this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).evaluate();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot evaluate the decision"});
        }
    }

    @Test
    public void testEvaluateDecisionByKeyWithTenantIdAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).decisionDefinitionTenantId(TENANT_ONE).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Test
    public void testEvaluateDecisionByIdAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Test
    public void testEvaluateDecisionByKeyWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE_SECOND_VERSION);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Test
    public void testEvaluateDecisionByKeyWithTenantIdDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        DmnDecisionResult decisionResult = this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).decisionDefinitionTenantId(TENANT_ONE).variables((Map)this.createVariables()).evaluate();
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }

    protected void assertThatDecisionHasResult(DmnDecisionResult decisionResult, Object expectedValue) {
        Assertions.assertThat((List)decisionResult).isNotNull();
        Assertions.assertThat((int)decisionResult.size()).isEqualTo(1);
        String value = (String)decisionResult.getSingleResult().getFirstEntry();
        Assertions.assertThat((String)value).isEqualTo(expectedValue);
    }
}

