/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.management.JobDefinition;
import org.eximeebpms.bpm.engine.management.JobDefinitionQuery;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyJobDefinitionQueryTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().timerWithDuration("PT1M")).userTask().endEvent().done();
        this.testRule.deploy(process);
        this.testRule.deployForTenant(TENANT_ONE, process);
        this.testRule.deployForTenant(TENANT_TWO, process);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByTenantId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIds() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryByDefinitionsWithoutTenantIds() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeJobDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeJobDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeJobDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List jobDefinitions = ((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((List)jobDefinitions).hasSize(2);
        Assertions.assertThat((String)((JobDefinition)jobDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((JobDefinition)jobDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void testQuerySortingDesc() {
        List jobDefinitions = ((JobDefinitionQuery)this.managementService.createJobDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((List)jobDefinitions).hasSize(2);
        Assertions.assertThat((String)((JobDefinition)jobDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((JobDefinition)jobDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeJobDefinitionsWithoutTenantId().count()).isEqualTo(2L);
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        JobDefinitionQuery query = this.managementService.createJobDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }
}

