/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyTaskQueryTest
extends PluggableProcessEngineTest {
    private static final String TENANT_ONE = "tenant1";
    private static final String TENANT_TWO = "tenant2";
    private static final String TENANT_NON_EXISTING = "nonExistingTenant";
    private final List<String> taskIds = new ArrayList<String>();

    @Before
    public void setUp() throws Exception {
        this.createTaskWithoutTenant();
        this.createTaskForTenant(TENANT_ONE);
        this.createTaskForTenant(TENANT_TWO);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIds() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_NON_EXISTING});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTasksWithoutTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryWithAndWithoutTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().or().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).withoutTenantId().endOr();
        Assertions.assertThat((int)query.list().size()).isEqualTo(3);
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        TaskQuery query = this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_NON_EXISTING});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testQueryByTenantIdNullFails() {
        try {
            Assert.assertEquals((Object)0, (Object)this.taskService.createTaskQuery().tenantIdIn(new String[]{null}));
            Assert.fail((String)"Exception expected");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((int)tasks.size()).isEqualTo(2);
        Assertions.assertThat((String)((Task)tasks.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((Task)tasks.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void testQuerySortingDesc() {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((List)tasks).hasSize(2);
        Assertions.assertThat((String)((Task)tasks.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((Task)tasks.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(1L);
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)this.taskService.createTaskQuery().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        TaskQuery query = this.taskService.createTaskQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected String createTaskWithoutTenant() {
        return this.createTaskForTenant(null);
    }

    protected String createTaskForTenant(String tenantId) {
        Task task = this.taskService.newTask();
        if (tenantId != null) {
            task.setTenantId(tenantId);
        }
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskIds.add(taskId);
        return taskId;
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        for (String taskId : this.taskIds) {
            this.taskService.deleteTask(taskId, true);
        }
        this.taskIds.clear();
    }
}

