/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMigrationPlanCreateTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    @Test
    public void canCreateMigrationPlanForDefinitionsOfAuthenticatedTenant() {
        ProcessDefinition tenant1Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenant2Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(tenant1Definition.getId(), tenant2Definition.getId()).mapEqualActivities().build();
        Assert.assertNotNull((Object)migrationPlan);
    }

    @Test
    public void cannotCreateMigrationPlanForDefinitionsOfNonAuthenticatedTenantsCase1() {
        ProcessDefinition tenant1Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenant2Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_TWO));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMigrationPlan(tenant1Definition.getId(), tenant2Definition.getId()).mapEqualActivities().build()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get process definition '" + tenant1Definition.getId() + "' because it belongs to no authenticated tenant");
    }

    @Test
    public void cannotCreateMigrationPlanForDefinitionsOfNonAuthenticatedTenantsCase2() {
        ProcessDefinition tenant1Definition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenant2Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_TWO));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMigrationPlan(tenant1Definition.getId(), tenant2Definition.getId()).mapEqualActivities().build()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get process definition '" + tenant2Definition.getId() + "' because it belongs to no authenticated tenant");
    }

    @Test
    public void cannotCreateMigrationPlanForDefinitionsOfNonAuthenticatedTenantsCase3() {
        ProcessDefinition sourceDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get process definition '" + sourceDefinition.getId() + "' because it belongs to no authenticated tenant");
    }

    @Test
    public void canCreateMigrationPlanForSharedDefinitionsWithNoAuthenticatedTenants() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        Assert.assertNotNull((Object)migrationPlan);
    }

    @Test
    public void canCreateMigrationPlanWithDisabledTenantCheck() {
        ProcessDefinition tenant1Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition tenant2Definition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(tenant1Definition.getId(), tenant2Definition.getId()).mapEqualActivities().build();
        Assert.assertNotNull((Object)migrationPlan);
    }
}

