/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.repository;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.query.Query;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.CaseDefinitionQuery;
import org.eximeebpms.bpm.engine.test.api.repository.AbstractDefinitionQueryTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CaseDefinitionQueryTest
extends AbstractDefinitionQueryTest {
    private String deploymentThreeId;

    @Override
    protected String getResourceOnePath() {
        return "org/eximeebpms/bpm/engine/test/repository/one.cmmn";
    }

    @Override
    protected String getResourceTwoPath() {
        return "org/eximeebpms/bpm/engine/test/repository/two.cmmn";
    }

    protected String getResourceThreePath() {
        return "org/eximeebpms/bpm/engine/test/api/repository/three_.cmmn";
    }

    @Before
    public void setUp() throws Exception {
        this.deploymentThreeId = this.repositoryService.createDeployment().name("thirdDeployment").addClasspathResource(this.getResourceThreePath()).deploy().getId();
    }

    @After
    public void tearDown() throws Exception {
        this.repositoryService.deleteDeployment(this.deploymentThreeId, true);
    }

    @Test
    public void testCaseDefinitionProperties() {
        List caseDefinitions = ((CaseDefinitionQuery)((CaseDefinitionQuery)((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().orderByCaseDefinitionName().asc()).orderByCaseDefinitionVersion().asc()).orderByCaseDefinitionCategory().asc()).list();
        CaseDefinition caseDefinition = (CaseDefinition)caseDefinitions.get(0);
        Assertions.assertThat((String)caseDefinition.getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((String)caseDefinition.getName()).isEqualTo((Object)"One");
        Assertions.assertThat((String)caseDefinition.getId()).startsWith((CharSequence)"one:1");
        Assertions.assertThat((String)caseDefinition.getCategory()).isEqualTo((Object)"Examples");
        Assertions.assertThat((int)caseDefinition.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)caseDefinition.getResourceName()).isEqualTo((Object)"org/eximeebpms/bpm/engine/test/repository/one.cmmn");
        Assertions.assertThat((String)caseDefinition.getDeploymentId()).isEqualTo((Object)this.deploymentOneId);
        caseDefinition = (CaseDefinition)caseDefinitions.get(1);
        Assertions.assertThat((String)caseDefinition.getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((String)caseDefinition.getName()).isEqualTo((Object)"One");
        Assertions.assertThat((String)caseDefinition.getId()).startsWith((CharSequence)"one:2");
        Assertions.assertThat((String)caseDefinition.getCategory()).isEqualTo((Object)"Examples");
        Assertions.assertThat((int)caseDefinition.getVersion()).isEqualTo(2);
        Assertions.assertThat((String)caseDefinition.getResourceName()).isEqualTo((Object)"org/eximeebpms/bpm/engine/test/repository/one.cmmn");
        Assertions.assertThat((String)caseDefinition.getDeploymentId()).isEqualTo((Object)this.deploymentTwoId);
        caseDefinition = (CaseDefinition)caseDefinitions.get(2);
        Assertions.assertThat((String)caseDefinition.getKey()).isEqualTo((Object)"two");
        Assertions.assertThat((String)caseDefinition.getName()).isEqualTo((Object)"Two");
        Assertions.assertThat((String)caseDefinition.getId()).startsWith((CharSequence)"two:1");
        Assertions.assertThat((String)caseDefinition.getCategory()).isEqualTo((Object)"Examples2");
        Assertions.assertThat((int)caseDefinition.getVersion()).isEqualTo(1);
        Assertions.assertThat((String)caseDefinition.getResourceName()).isEqualTo((Object)"org/eximeebpms/bpm/engine/test/repository/two.cmmn");
        Assertions.assertThat((String)caseDefinition.getDeploymentId()).isEqualTo((Object)this.deploymentOneId);
    }

    @Test
    public void testQueryByCaseDefinitionIds() {
        Assertions.assertThat((List)this.repositoryService.createCaseDefinitionQuery().caseDefinitionIdIn(new String[]{"a", "b"}).list()).isEmpty();
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().list();
        Assertions.assertThat((List)caseDefinitions).isNotEmpty();
        ArrayList<String> ids = new ArrayList<String>();
        for (CaseDefinition caseDefinition : caseDefinitions) {
            ids.add(caseDefinition.getId());
        }
        caseDefinitions = this.repositoryService.createCaseDefinitionQuery().caseDefinitionIdIn(ids.toArray(new String[ids.size()])).list();
        Assertions.assertThat((int)ids.size()).isEqualTo(caseDefinitions.size());
        for (CaseDefinition caseDefinition : caseDefinitions) {
            Assertions.assertThat(ids).contains((Object[])new String[]{caseDefinition.getId()}).withFailMessage("Expected to find case definition " + String.valueOf(caseDefinition), new Object[0]);
        }
        Assertions.assertThat((long)this.repositoryService.createCaseDefinitionQuery().caseDefinitionIdIn(ids.toArray(new String[ids.size()])).caseDefinitionId("nonExistent").count()).isEqualTo(0L);
    }

    @Test
    public void testQueryByDeploymentId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.deploymentId(this.deploymentOneId);
        this.verifyQueryResults((Query)query, 2);
    }

    @Test
    public void testQueryByInvalidDeploymentId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.deploymentId("invalid");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> query.deploymentId(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByName() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionName("Two");
        this.verifyQueryResults((Query)query, 1);
        query.caseDefinitionName("One");
        this.verifyQueryResults((Query)query, 2);
    }

    @Test
    public void testQueryByInvalidName() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionName("invalid");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionName(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByNameLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionNameLike("%w%");
        this.verifyQueryResults((Query)query, 1);
        query.caseDefinitionNameLike("%z\\_");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidNameLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionNameLike("%invalid%");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionNameLike(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByResourceNameLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionResourceNameLike("%ree%");
        this.verifyQueryResults((Query)query, 1);
        query.caseDefinitionResourceNameLike("%e\\_%");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidResourceNameLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionResourceNameLike("%invalid%");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionNameLike(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByKey() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionKey("one");
        this.verifyQueryResults((Query)query, 2);
        query.caseDefinitionKey("two");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidKey() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionKey("invalid");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionKey(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByKeyLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionKeyLike("%o%");
        this.verifyQueryResults((Query)query, 3);
        query.caseDefinitionKeyLike("%z\\_");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidKeyLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionKeyLike("%invalid%");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionKeyLike(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByCategory() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionCategory("Examples");
        this.verifyQueryResults((Query)query, 2);
    }

    @Test
    public void testQueryByInvalidCategory() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionCategory("invalid");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionCategory(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByCategoryLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionCategoryLike("%Example%");
        this.verifyQueryResults((Query)query, 3);
        query.caseDefinitionCategoryLike("%amples2");
        this.verifyQueryResults((Query)query, 1);
        query.caseDefinitionCategoryLike("%z\\_");
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testQueryByInvalidCategoryLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionCategoryLike("invalid");
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionCategoryLike(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByVersion() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults((Query)query, 1);
        query.caseDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults((Query)query, 3);
    }

    @Test
    public void testQueryByInvalidVersion() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults((Query)query, 0);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionVersion(Integer.valueOf(-1))).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionVersion(null)).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQueryByLatest() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.latestVersion();
        this.verifyQueryResults((Query)query, 3);
        query.caseDefinitionKey("one").latestVersion();
        this.verifyQueryResults((Query)query, 1);
        query.caseDefinitionKey("two").latestVersion();
        this.verifyQueryResults((Query)query, 1);
    }

    @Test
    public void testInvalidUsageOfLatest() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        Assertions.assertThatThrownBy(() -> query.caseDefinitionId("test").latestVersion().list()).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionName("test").latestVersion().list()).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionNameLike("test").latestVersion().list()).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.caseDefinitionVersion(Integer.valueOf(1)).latestVersion().list()).isInstanceOf(NotValidException.class);
        Assertions.assertThatThrownBy(() -> query.deploymentId("test").latestVersion().list()).isInstanceOf(NotValidException.class);
    }

    @Test
    public void testQuerySorting() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionId().asc();
        this.verifyQueryResults((Query)query, 4);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByDeploymentId().asc();
        this.verifyQueryResults((Query)query, 4);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionKey().asc();
        this.verifyQueryResults((Query)query, 4);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionVersion().asc();
        this.verifyQueryResults((Query)query, 4);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionId().desc();
        this.verifyQueryResults((Query)query, 4);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByDeploymentId().desc();
        this.verifyQueryResults((Query)query, 4);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionKey().desc();
        this.verifyQueryResults((Query)query, 4);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionVersion().desc();
        this.verifyQueryResults((Query)query, 4);
        query = this.repositoryService.createCaseDefinitionQuery();
        ((CaseDefinitionQuery)query.orderByCaseDefinitionKey().asc()).orderByCaseDefinitionVersion().desc();
        List caseDefinitions = query.list();
        Assertions.assertThat((int)caseDefinitions.size()).isEqualTo(4);
        Assertions.assertThat((String)((CaseDefinition)caseDefinitions.get(0)).getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((int)((CaseDefinition)caseDefinitions.get(0)).getVersion()).isEqualTo(2);
        Assertions.assertThat((String)((CaseDefinition)caseDefinitions.get(1)).getKey()).isEqualTo((Object)"one");
        Assertions.assertThat((int)((CaseDefinition)caseDefinitions.get(1)).getVersion()).isEqualTo(1);
        Assertions.assertThat((String)((CaseDefinition)caseDefinitions.get(2)).getKey()).isEqualTo((Object)"two");
        Assertions.assertThat((int)((CaseDefinition)caseDefinitions.get(2)).getVersion()).isEqualTo(1);
    }
}

