/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.repository;

import ch.qos.logback.classic.Level;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.dmn.engine.impl.transform.DmnTransformException;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ParseException;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryTimeToLiveDeploymentTest {
    protected static final String CONFIG_LOGGER = "org.eximeebpms.bpm.engine.cfg";
    protected static final String EXPECTED_DEFAULT_CONFIG_MSG = "History Time To Live (TTL) cannot be null. ";
    protected static final String EXPECTED_LONGER_TTL_MSG = "The specified Time To Live (TTL) in the model is longer than the global TTL configuration. The historic data related to this model will be cleaned up at later point comparing to the other processes.";
    protected static final String HTTL_CONFIG_VALUE = "180";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.eximeebpms.bpm.engine.cfg"}).level(Level.DEBUG);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected ProcessEngine processEngine;
    protected String historyTimeToLive;

    @Before
    public void setUp() throws Exception {
        this.processEngine = this.engineRule.getProcessEngine();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.managementService = this.engineRule.getManagementService();
        this.historyTimeToLive = this.processEngineConfiguration.getHistoryTimeToLive();
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setHistoryTimeToLive(this.historyTimeToLive);
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(false);
        ClockUtil.reset();
    }

    @Test
    public void processWithoutHTTLShouldFail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"))).isInstanceOf(ParseException.class)).hasMessageContaining(EXPECTED_DEFAULT_CONFIG_MSG).hasMessageContaining("TTL is necessary for the History Cleanup to work. The following options are possible:").hasMessageContaining("* Set historyTimeToLive in the model").hasMessageContaining("* Set a default historyTimeToLive as a global process engine configuration").hasMessageContaining("* (Not recommended) Deactivate the enforceTTL config to disable this check");
    }

    @Test
    public void processWithHTTLShouldSucceed() {
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version3.bpmn20.xml"));
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
    }

    @Test
    public void caseWithHTTLShouldSucceed() {
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCaseWithHistoryTimeToLive.cmmn"));
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
    }

    @Test
    public void caseWithoutHTTLShouldFail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase2.cmmn"))).isInstanceOf(ProcessEngineException.class)).hasCauseInstanceOf(NotValidException.class).hasStackTraceContaining(EXPECTED_DEFAULT_CONFIG_MSG);
    }

    @Test
    public void decisionWithHTTLShouldSucceed() {
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"));
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
    }

    @Test
    public void decisionWithoutHTTLShouldFail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/dmn/Another_Example.dmn"))).isInstanceOf(ProcessEngineException.class)).hasCauseInstanceOf(DmnTransformException.class).hasStackTraceContaining(EXPECTED_DEFAULT_CONFIG_MSG);
    }

    @Test
    public void shouldDeploySuccessfullyDueToProcessEngineConfigFallback() {
        this.processEngineConfiguration.setHistoryTimeToLive("5");
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
    }

    @Test
    public void shouldNotLogMessageOnDefaultConfigOriginatingFromConfig() {
        this.processEngineConfiguration.setHistoryTimeToLive(HTTL_CONFIG_VALUE);
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        Assertions.assertThat((List)this.loggingRule.getFilteredLog(EXPECTED_DEFAULT_CONFIG_MSG)).hasSize(0);
    }

    @Test
    public void shouldGetDeployedProcess() {
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(false);
        Object definitions = this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
        this.processEngineConfiguration.getDeploymentCache().purgeCache();
        this.repositoryService.getProcessDefinition(((ProcessDefinition)definitions.getDeployedProcessDefinitions().get(0)).getId());
    }

    @Test
    public void shouldGetDeployedDecision() {
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(false);
        Object definitions = this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/dmn/Another_Example.dmn"));
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
        this.processEngineConfiguration.getDeploymentCache().purgeCache();
        this.repositoryService.getDecisionDefinition(((DecisionDefinition)definitions.getDeployedDecisionDefinitions().get(0)).getId());
    }

    @Test
    public void shouldGetDeployedCase() {
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(false);
        Object definitions = this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase2.cmmn"));
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
        this.processEngineConfiguration.getDeploymentCache().purgeCache();
        this.repositoryService.getCaseDefinition(((CaseDefinition)definitions.getDeployedCaseDefinitions().get(0)).getId());
    }

    @Test
    public void shouldLogMessageOnLongerTTLInProcessModel() {
        String nonDefaultValue = "179";
        this.processEngineConfiguration.setHistoryTimeToLive(nonDefaultValue);
        this.deployProcessDefinitions();
        Assertions.assertThat((List)this.loggingRule.getFilteredLog("definitionKey: process; The specified Time To Live (TTL) in the model is longer than the global TTL configuration. The historic data related to this model will be cleaned up at later point comparing to the other processes.")).hasSize(1);
    }

    @Test
    public void shouldLogMessageOnLongerTTLInfCaseModel() {
        String nonDefaultValue = "179";
        this.processEngineConfiguration.setHistoryTimeToLive(nonDefaultValue);
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/case_with_365_httl.cmmn"));
        Assertions.assertThat((List)this.loggingRule.getFilteredLog("definitionKey: testCase; The specified Time To Live (TTL) in the model is longer than the global TTL configuration. The historic data related to this model will be cleaned up at later point comparing to the other processes.")).hasSize(1);
    }

    @Test
    public void shouldLogMessageOnLongerTTLInDecisionModel() {
        String nonDefaultValue = "179";
        this.processEngineConfiguration.setHistoryTimeToLive(nonDefaultValue);
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/decision_with_365_httl.dmn"));
        Assertions.assertThat((List)this.loggingRule.getFilteredLog("definitionKey: testDecision; The specified Time To Live (TTL) in the model is longer than the global TTL configuration. The historic data related to this model will be cleaned up at later point comparing to the other processes.")).hasSize(1);
    }

    protected void deployProcessDefinitions() {
        this.testRule.deploy(((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(365))).startEvent().userTask().endEvent().done());
    }
}

