/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.repository;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.delegate.VariableScope;
import org.eximeebpms.bpm.engine.exception.NotAllowedException;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.history.UserOperationLogQuery;
import org.eximeebpms.bpm.engine.impl.RepositoryServiceImpl;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.core.model.CallableElement;
import org.eximeebpms.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.history.event.UserOperationLogEntryEventEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.eximeebpms.bpm.engine.impl.pvm.PvmActivity;
import org.eximeebpms.bpm.engine.impl.pvm.PvmTransition;
import org.eximeebpms.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.repository.CalledProcessDefinition;
import org.eximeebpms.bpm.engine.repository.CaseDefinition;
import org.eximeebpms.bpm.engine.repository.CaseDefinitionQuery;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionDefinitionQuery;
import org.eximeebpms.bpm.engine.repository.DecisionRequirementsDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.repository.ProcessDefinitionQuery;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.engine.test.util.TestExecutionListener;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.ProcessBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RepositoryServiceTest
extends PluggableProcessEngineTest {
    private static final String NAMESPACE = "xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL'";
    private static final String TARGET_NAMESPACE = "targetNamespace='" + String.valueOf(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS) + "'";
    private boolean enforceHistoryTimeToLiveBefore;

    @Before
    public void setUp() {
        this.enforceHistoryTimeToLiveBefore = this.processEngineConfiguration.isEnforceHistoryTimeToLive();
    }

    @After
    public void tearDown() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute(commandContext -> {
            commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-processdefinition");
            return null;
        });
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(this.enforceHistoryTimeToLiveBefore);
    }

    private void checkDeployedBytes(InputStream deployedResource, byte[] utf8Bytes) throws IOException {
        byte[] deployedBytes = new byte[utf8Bytes.length];
        deployedResource.read(deployedBytes);
        for (int i = 0; i < utf8Bytes.length; ++i) {
            Assert.assertEquals((long)utf8Bytes[i], (long)deployedBytes[i]);
        }
    }

    @Test
    public void testUTF8DeploymentMethod() throws IOException {
        Charset utf8Charset = Charset.forName("UTF-8");
        Charset defaultCharset = this.processEngineConfiguration.getDefaultCharset();
        this.processEngineConfiguration.setDefaultCharset(utf8Charset);
        String umlautsString = "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df";
        String resourceName = "deployment.bpmn";
        BpmnModelInstance instance = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"umlautsProcess").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent(umlautsString).done();
        String instanceAsString = Bpmn.convertToString((BpmnModelInstance)instance);
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addString(resourceName, instanceAsString).deploy();
        InputStream inputStream = this.repositoryService.getResourceAsStream(deployment.getId(), resourceName);
        byte[] utf8Bytes = instanceAsString.getBytes(utf8Charset);
        this.checkDeployedBytes(inputStream, utf8Bytes);
        this.repositoryService.deleteDeployment(deployment.getId());
        deployment = this.repositoryService.createDeployment().addModelInstance(resourceName, instance).deploy();
        inputStream = this.repositoryService.getResourceAsStream(deployment.getId(), resourceName);
        this.checkDeployedBytes(inputStream, utf8Bytes);
        this.repositoryService.deleteDeployment(deployment.getId());
        this.processEngineConfiguration.setDefaultCharset(defaultCharset);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testStartProcessInstanceById() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Assert.assertEquals((Object)"oneTaskProcess", (Object)processDefinition.getKey());
        Assert.assertNotNull((Object)processDefinition.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testFindProcessDefinitionById() {
        List definitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)definitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(((ProcessDefinition)definitions.get(0)).getId()).singleResult();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertNotNull((Object)processDefinition);
        Assert.assertEquals((Object)"oneTaskProcess", (Object)processDefinition.getKey());
        Assert.assertEquals((Object)"The One Task Process", (Object)processDefinition.getName());
        processDefinition = this.repositoryService.getProcessDefinition(((ProcessDefinition)definitions.get(0)).getId());
        Assert.assertEquals((Object)"This is a process for testing purposes", (Object)processDefinition.getDescription());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteDeploymentWithRunningInstances() {
        block2: {
            List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
            Assert.assertEquals((long)1L, (long)processDefinitions.size());
            ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
            this.runtimeService.startProcessInstanceById(processDefinition.getId());
            try {
                this.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
                Assert.fail((String)"Exception expected");
            }
            catch (ProcessEngineException pex) {
                if ($assertionsDisabled || pex.getMessage().contains("Deletion of process definition without cascading failed.")) break block2;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testDeleteDeploymentSkipCustomListeners() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteProcessInstanceSkipCustomListeners.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.repositoryService.deleteDeployment(deploymentId, true, false);
        Assert.assertEquals((long)1L, (long)TestExecutionListener.collectedEvents.size());
        TestExecutionListener.reset();
        deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.repositoryService.deleteDeployment(deploymentId, true, true);
        Assert.assertTrue((boolean)TestExecutionListener.collectedEvents.isEmpty());
        TestExecutionListener.reset();
    }

    @Test
    public void testDeleteDeploymentSkipCustomTaskListeners() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteProcessInstanceSkipCustomTaskListeners.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        RecorderTaskListener.getRecordedEvents().clear();
        this.repositoryService.deleteDeployment(deploymentId, true, false);
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getRecordedEvents().size());
        RecorderTaskListener.clear();
        deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.repositoryService.deleteDeployment(deploymentId, true, true);
        Assert.assertTrue((boolean)RecorderTaskListener.getRecordedEvents().isEmpty());
        RecorderTaskListener.clear();
    }

    @Test
    public void testDeleteDeploymentSkipIoMappings() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteDeploymentSkipIoMappings.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        try {
            this.repositoryService.deleteDeployment(deploymentId, true, false, true);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception is not expected when deleting deployment with running process", (Throwable)e);
        }
    }

    @Test
    public void testDeleteDeploymentWithoutSkipIoMappings() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteDeploymentSkipIoMappings.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        try {
            this.repositoryService.deleteDeployment(deploymentId, true, false, false);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            this.testRule.assertTextPresent("Exception when output mapping is executed", e.getMessage());
        }
        this.repositoryService.deleteDeployment(deploymentId, true, false, true);
    }

    @Test
    public void testDeleteDeploymentNullDeploymentId() {
        try {
            this.repositoryService.deleteDeployment(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    @Test
    public void testDeleteDeploymentCascadeNullDeploymentId() {
        try {
            this.repositoryService.deleteDeployment(null, true);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteDeploymentCascadeWithRunningInstances() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.repositoryService.deleteDeployment(processDefinition.getDeploymentId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/repository/one.cmmn"})
    @Test
    public void testDeleteDeploymentClearsCache() {
        String deploymentId = ((org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.repositoryService.getCmmnModelInstance(caseDefinitionId);
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        Assert.assertNotNull((Object)deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionId));
        Assert.assertNotNull((Object)deploymentCache.getBpmnModelInstanceCache().get((Object)processDefinitionId));
        Assert.assertNotNull((Object)deploymentCache.getCaseDefinitionCache().get((Object)caseDefinitionId));
        Assert.assertNotNull((Object)deploymentCache.getCmmnModelInstanceCache().get((Object)caseDefinitionId));
        this.repositoryService.deleteDeployment(deploymentId, true);
        Assert.assertNull((Object)deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionId));
        Assert.assertNull((Object)deploymentCache.getBpmnModelInstanceCache().get((Object)processDefinitionId));
        Assert.assertNull((Object)deploymentCache.getCaseDefinitionCache().get((Object)caseDefinitionId));
        Assert.assertNull((Object)deploymentCache.getCmmnModelInstanceCache().get((Object)caseDefinitionId));
    }

    @Test
    public void testFindDeploymentResourceNamesNullDeploymentId() {
        try {
            this.repositoryService.getDeploymentResourceNames(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    @Test
    public void testFindDeploymentResourcesNullDeploymentId() {
        try {
            this.repositoryService.getDeploymentResources(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("deploymentId is null", e.getMessage());
        }
    }

    @Test
    public void testDeploymentWithDelayedProcessDefinitionActivation() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        Date inThreeDays = new Date(startTime.getTime() + 259200000L);
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").addClasspathResource("org/eximeebpms/bpm/engine/test/api/twoTasksProcess.bpmn20.xml").activateProcessDefinitionsOn(inThreeDays).deploy();
        Assert.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        List jobs = this.managementService.createJobQuery().list();
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        Assert.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testDeploymentWithDelayedProcessDefinitionAndJobDefinitionActivation() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        Date inThreeDays = new Date(startTime.getTime() + 259200000L);
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/oneAsyncTask.bpmn").activateProcessDefinitionsOn(inThreeDays).deploy();
        Assert.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().active().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetResourceAsStreamUnexistingResourceInExistingDeployment() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = (org.eximeebpms.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        try {
            this.repositoryService.getResourceAsStream(deployment.getId(), "org/eximeebpms/bpm/engine/test/api/unexistingProcess.bpmn.xml");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("no resource found with name", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetResourceAsStreamUnexistingDeployment() {
        try {
            this.repositoryService.getResourceAsStream("unexistingdeployment", "org/eximeebpms/bpm/engine/test/api/unexistingProcess.bpmn.xml");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("no resource found with name", ae.getMessage());
        }
    }

    @Test
    public void testGetResourceAsStreamNullArguments() {
        try {
            this.repositoryService.getResourceAsStream(null, "resource");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("deploymentId is null", ae.getMessage());
        }
        try {
            this.repositoryService.getResourceAsStream("deployment", null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("resourceName is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/repository/one.cmmn"})
    @Test
    public void testGetCaseDefinition() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        String caseDefinitionId = caseDefinition.getId();
        CaseDefinition definition = this.repositoryService.getCaseDefinition(caseDefinitionId);
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)caseDefinitionId, (Object)definition.getId());
    }

    @Test
    public void testGetCaseDefinitionByInvalidId() {
        try {
            this.repositoryService.getCaseDefinition("invalid");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("no deployed case definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getCaseDefinition(null);
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("caseDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/repository/one.cmmn"})
    @Test
    public void testGetCaseModel() throws Exception {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        String caseDefinitionId = caseDefinition.getId();
        InputStream caseModel = this.repositoryService.getCaseModel(caseDefinitionId);
        Assert.assertNotNull((Object)caseModel);
        byte[] readInputStream = IoUtil.readInputStream((InputStream)caseModel, (String)"caseModel");
        String model = new String(readInputStream, "UTF-8");
        Assert.assertTrue((boolean)model.contains("<case id=\"one\" name=\"One\">"));
        IoUtil.closeSilently((Closeable)caseModel);
    }

    @Test
    public void testGetCaseModelByInvalidId() throws Exception {
        try {
            this.repositoryService.getCaseModel("invalid");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("no deployed case definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getCaseModel(null);
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("caseDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/repository/one.dmn"})
    @Test
    public void testGetDecisionDefinition() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        String decisionDefinitionId = decisionDefinition.getId();
        DecisionDefinition definition = this.repositoryService.getDecisionDefinition(decisionDefinitionId);
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)decisionDefinitionId, (Object)definition.getId());
    }

    @Test
    public void testGetDecisionDefinitionByInvalidId() {
        try {
            this.repositoryService.getDecisionDefinition("invalid");
            Assert.fail();
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("no deployed decision definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionDefinition(null);
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("decisionDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/repository/drg.dmn"})
    @Test
    public void testGetDecisionRequirementsDefinition() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        String decisionRequirementsDefinitionId = decisionRequirementsDefinition.getId();
        DecisionRequirementsDefinition definition = this.repositoryService.getDecisionRequirementsDefinition(decisionRequirementsDefinitionId);
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)decisionRequirementsDefinitionId, (Object)definition.getId());
    }

    @Test
    public void testGetDecisionRequirementsDefinitionByInvalidId() {
        try {
            this.repositoryService.getDecisionRequirementsDefinition("invalid");
            Assert.fail();
        }
        catch (Exception e) {
            this.testRule.assertTextPresent("no deployed decision requirements definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionRequirementsDefinition(null);
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("decisionRequirementsDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/repository/one.dmn"})
    @Test
    public void testGetDecisionModel() throws Exception {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        String decisionDefinitionId = decisionDefinition.getId();
        InputStream decisionModel = this.repositoryService.getDecisionModel(decisionDefinitionId);
        Assert.assertNotNull((Object)decisionModel);
        byte[] readInputStream = IoUtil.readInputStream((InputStream)decisionModel, (String)"decisionModel");
        String model = new String(readInputStream, "UTF-8");
        Assert.assertTrue((boolean)model.contains("<decision id=\"one\" name=\"One\">"));
        IoUtil.closeSilently((Closeable)decisionModel);
    }

    @Test
    public void testGetDecisionModelByInvalidId() throws Exception {
        try {
            this.repositoryService.getDecisionModel("invalid");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("no deployed decision definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionModel(null);
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("decisionDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/repository/drg.dmn"})
    @Test
    public void testGetDecisionRequirementsModel() throws Exception {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        String decisionRequirementsDefinitionId = decisionRequirementsDefinition.getId();
        InputStream decisionRequirementsModel = this.repositoryService.getDecisionRequirementsModel(decisionRequirementsDefinitionId);
        Assert.assertNotNull((Object)decisionRequirementsModel);
        byte[] readInputStream = IoUtil.readInputStream((InputStream)decisionRequirementsModel, (String)"decisionRequirementsModel");
        String model = new String(readInputStream, "UTF-8");
        Assert.assertTrue((boolean)model.contains("<definitions id=\"dish\" name=\"Dish\" namespace=\"test-drg\""));
        IoUtil.closeSilently((Closeable)decisionRequirementsModel);
    }

    @Test
    public void testGetDecisionRequirementsModelByInvalidId() throws Exception {
        try {
            this.repositoryService.getDecisionRequirementsModel("invalid");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("no deployed decision requirements definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionRequirementsModel(null);
            Assert.fail();
        }
        catch (NotValidException e) {
            this.testRule.assertTextPresent("decisionRequirementsDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/repository/drg.dmn", "org/eximeebpms/bpm/engine/test/repository/drg.png"})
    @Test
    public void testGetDecisionRequirementsDiagram() throws Exception {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        String decisionRequirementsDefinitionId = decisionRequirementsDefinition.getId();
        InputStream actualDrd = this.repositoryService.getDecisionRequirementsDiagram(decisionRequirementsDefinitionId);
        Assert.assertNotNull((Object)actualDrd);
    }

    @Test
    public void testGetDecisionRequirementsDiagramByInvalidId() throws Exception {
        try {
            this.repositoryService.getDecisionRequirementsDiagram("invalid");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("no deployed decision requirements definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionRequirementsDiagram(null);
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("decisionRequirementsDefinitionId is null", e.getMessage());
        }
    }

    @Test
    public void testDeployRevisedProcessAfterDeleteOnOtherProcessEngine() {
        ProcessEngine processEngine1 = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test-schema").setDatabaseSchemaUpdate("true").setJdbcUrl("jdbc:h2:mem:activiti-process-cache-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).setEnforceHistoryTimeToLive(false).buildProcessEngine();
        RepositoryService repositoryService1 = processEngine1.getRepositoryService();
        ProcessEngine processEngine2 = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test").setDatabaseSchemaUpdate("false").setJdbcUrl("jdbc:h2:mem:activiti-process-cache-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).setEnforceHistoryTimeToLive(false).buildProcessEngine();
        RepositoryService repositoryService2 = processEngine2.getRepositoryService();
        RuntimeService runtimeService2 = processEngine2.getRuntimeService();
        TaskService taskService2 = processEngine2.getTaskService();
        String deploymentId = repositoryService1.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/RepositoryServiceTest.testDeployRevisedProcessAfterDeleteOnOtherProcessEngine.v1.bpmn20.xml").deploy().getId();
        String processDefinitionId = ((ProcessDefinition)repositoryService2.createProcessDefinitionQuery().singleResult()).getId();
        runtimeService2.startProcessInstanceById(processDefinitionId);
        Task task = (Task)taskService2.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"original task", (Object)task.getName());
        repositoryService2.deleteDeployment(deploymentId, true);
        Assert.assertEquals((long)0L, (long)repositoryService2.createDeploymentQuery().count());
        Assert.assertEquals((long)0L, (long)runtimeService2.createProcessInstanceQuery().count());
        deploymentId = repositoryService1.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/RepositoryServiceTest.testDeployRevisedProcessAfterDeleteOnOtherProcessEngine.v2.bpmn20.xml").deploy().getId();
        processDefinitionId = ((ProcessDefinition)repositoryService2.createProcessDefinitionQuery().singleResult()).getId();
        runtimeService2.startProcessInstanceByKey("oneTaskProcess");
        task = (Task)taskService2.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"revised task", (Object)task.getName());
        repositoryService1.deleteDeployment(deploymentId, true);
        processEngine1.close();
        processEngine2.close();
    }

    @Test
    public void testDeploymentPersistence() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().name("strings").addString("org/eximeebpms/bpm/engine/test/test/HelloWorld.string", "hello world").addString("org/eximeebpms/bpm/engine/test/test/TheAnswer.string", "42").deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        Assert.assertEquals((long)1L, (long)deployments.size());
        deployment = (org.eximeebpms.bpm.engine.repository.Deployment)deployments.get(0);
        Assert.assertEquals((Object)"strings", (Object)deployment.getName());
        Assert.assertNotNull((Object)deployment.getDeploymentTime());
        String deploymentId = deployment.getId();
        List resourceNames = this.repositoryService.getDeploymentResourceNames(deploymentId);
        HashSet<String> expectedResourceNames = new HashSet<String>();
        expectedResourceNames.add("org/eximeebpms/bpm/engine/test/test/HelloWorld.string");
        expectedResourceNames.add("org/eximeebpms/bpm/engine/test/test/TheAnswer.string");
        Assert.assertEquals(expectedResourceNames, new HashSet(resourceNames));
        InputStream resourceStream = this.repositoryService.getResourceAsStream(deploymentId, "org/eximeebpms/bpm/engine/test/test/HelloWorld.string");
        Assert.assertTrue((boolean)Arrays.equals("hello world".getBytes(), IoUtil.readInputStream((InputStream)resourceStream, (String)"test")));
        resourceStream = this.repositoryService.getResourceAsStream(deploymentId, "org/eximeebpms/bpm/engine/test/test/TheAnswer.string");
        Assert.assertTrue((boolean)Arrays.equals("42".getBytes(), IoUtil.readInputStream((InputStream)resourceStream, (String)"test")));
        this.repositoryService.deleteDeployment(deploymentId);
    }

    @Test
    public void testProcessDefinitionPersistence() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/processTwo.bpmn20.xml").deploy().getId();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertEquals((long)2L, (long)processDefinitions.size());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void testDecisionDefinitionUpdateTimeToLiveWithUserOperationLog() {
        this.identityService.setAuthenticatedUserId("userId");
        DecisionDefinition decisionDefinition = this.findOnlyDecisionDefinition();
        Integer orgTtl = decisionDefinition.getHistoryTimeToLive();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(6));
        decisionDefinition = this.findOnlyDecisionDefinition();
        Assert.assertEquals((long)6L, (long)decisionDefinition.getHistoryTimeToLive().intValue());
        UserOperationLogQuery operationLogQuery = this.historyService.createUserOperationLogQuery().operationType("UpdateHistoryTimeToLive").entityType("DecisionDefinition");
        UserOperationLogEntry ttlEntry = (UserOperationLogEntry)operationLogQuery.property("historyTimeToLive").singleResult();
        UserOperationLogEntry definitionIdEntry = (UserOperationLogEntry)operationLogQuery.property("decisionDefinitionId").singleResult();
        UserOperationLogEntry definitionKeyEntry = (UserOperationLogEntry)operationLogQuery.property("decisionDefinitionKey").singleResult();
        Assert.assertNotNull((Object)ttlEntry);
        Assert.assertNotNull((Object)definitionIdEntry);
        Assert.assertNotNull((Object)definitionKeyEntry);
        Assert.assertEquals((Object)orgTtl.toString(), (Object)ttlEntry.getOrgValue());
        Assert.assertEquals((Object)"6", (Object)ttlEntry.getNewValue());
        Assert.assertEquals((Object)decisionDefinition.getId(), (Object)definitionIdEntry.getNewValue());
        Assert.assertEquals((Object)decisionDefinition.getKey(), (Object)definitionKeyEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)ttlEntry.getCategory());
        Assert.assertEquals((Object)"Operator", (Object)definitionIdEntry.getCategory());
        Assert.assertEquals((Object)"Operator", (Object)definitionKeyEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void testDecisionDefinitionUpdateTimeToLiveNull() {
        DecisionDefinition decisionDefinition = this.findOnlyDecisionDefinition();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), null);
        decisionDefinition = (DecisionDefinitionEntity)this.repositoryService.getDecisionDefinition(decisionDefinition.getId());
        Assert.assertEquals(null, (Object)decisionDefinition.getHistoryTimeToLive());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void testDecisionDefinitionUpdateTimeToLiveNegative() {
        DecisionDefinition decisionDefinition = this.findOnlyDecisionDefinition();
        try {
            this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(-1));
            Assert.fail((String)"Exception is expected, that negative value is not allowed.");
        }
        catch (BadUserRequestException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("greater than"));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionUpdateTimeToLive() {
        ProcessDefinition processDefinition = this.findOnlyProcessDefinition();
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), Integer.valueOf(6));
        processDefinition = this.findOnlyProcessDefinition();
        Assert.assertEquals((long)6L, (long)processDefinition.getHistoryTimeToLive().intValue());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionUpdateTimeToLiveNull() {
        ProcessDefinition processDefinition = this.findOnlyProcessDefinition();
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), null);
        processDefinition = this.findOnlyProcessDefinition();
        Assert.assertEquals(null, (Object)processDefinition.getHistoryTimeToLive());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionUpdateTimeToLiveNegative() {
        ProcessDefinition processDefinition = this.findOnlyProcessDefinition();
        try {
            this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), Integer.valueOf(-1));
            Assert.fail((String)"Exception is expected, that negative value is not allowed.");
        }
        catch (BadUserRequestException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("greater than"));
        }
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionUpdateHistoryTimeToLiveWithUserOperationLog() {
        ProcessDefinition processDefinition = this.findOnlyProcessDefinition();
        Integer timeToLiveOrgValue = processDefinition.getHistoryTimeToLive();
        this.processEngine.getIdentityService().setAuthenticatedUserId("userId");
        Integer timeToLiveNewValue = 6;
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), timeToLiveNewValue);
        List opLogEntries = this.processEngine.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)1L, (long)opLogEntries.size());
        UserOperationLogEntryEventEntity userOperationLogEntry = (UserOperationLogEntryEventEntity)opLogEntries.get(0);
        Assert.assertEquals((Object)"UpdateHistoryTimeToLive", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)processDefinition.getKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)processDefinition.getId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)"historyTimeToLive", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)timeToLiveOrgValue, (Object)Integer.valueOf(userOperationLogEntry.getOrgValue()));
        Assert.assertEquals((Object)timeToLiveNewValue, (Object)Integer.valueOf(userOperationLogEntry.getNewValue()));
    }

    @Test
    public void testGetProcessModelByInvalidId() throws Exception {
        try {
            this.repositoryService.getProcessModel("invalid");
            Assert.fail();
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresent("no deployed process definition found with id 'invalid'", e.getMessage());
        }
    }

    @Test
    public void testGetProcessModelByNullId() throws Exception {
        try {
            this.repositoryService.getProcessModel(null);
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("The process definition id is mandatory", e.getMessage());
        }
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCaseDefinitionUpdateHistoryTimeToLiveWithUserOperationLog() {
        this.identityService.setAuthenticatedUserId("userId");
        CaseDefinition caseDefinition = this.findOnlyCaseDefinition();
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), Integer.valueOf(6));
        caseDefinition = this.findOnlyCaseDefinition();
        Assert.assertEquals((long)6L, (long)caseDefinition.getHistoryTimeToLive().intValue());
        UserOperationLogQuery operationLogQuery = this.historyService.createUserOperationLogQuery().operationType("UpdateHistoryTimeToLive").entityType("CaseDefinition").caseDefinitionId(caseDefinition.getId());
        UserOperationLogEntry ttlEntry = (UserOperationLogEntry)operationLogQuery.property("historyTimeToLive").singleResult();
        UserOperationLogEntry definitionKeyEntry = (UserOperationLogEntry)operationLogQuery.property("caseDefinitionKey").singleResult();
        Assert.assertNotNull((Object)ttlEntry);
        Assert.assertNotNull((Object)definitionKeyEntry);
        Assert.assertNull((Object)ttlEntry.getOrgValue());
        Assert.assertEquals((Object)"6", (Object)ttlEntry.getNewValue());
        Assert.assertEquals((Object)caseDefinition.getKey(), (Object)definitionKeyEntry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)ttlEntry.getCategory());
        Assert.assertEquals((Object)"Operator", (Object)definitionKeyEntry.getCategory());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testUpdateHistoryTimeToLiveNull() {
        CaseDefinition caseDefinition = this.findOnlyCaseDefinition();
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), null);
        caseDefinition = this.findOnlyCaseDefinition();
        Assert.assertEquals(null, (Object)caseDefinition.getHistoryTimeToLive());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void shouldFailToUpdateHistoryTimeToLiveOnCaseDefinitionHTTLUpdate() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            CaseDefinition caseDefinition = this.findOnlyCaseDefinition();
            this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
            this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), null);
        }).isInstanceOf(NotAllowedException.class)).hasMessage("Null historyTimeToLive values are not allowed");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void shouldFailToUpdateHistoryTimeToLiveOnProcessDefinitionHTTLUpdate() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ProcessDefinition processDefinition = this.findOnlyProcessDefinition();
            this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
            this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), null);
        }).isInstanceOf(NotAllowedException.class)).hasMessage("Null historyTimeToLive values are not allowed");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void shouldFailToUpdateHistoryTimeToLiveOnDecisionDefinitionHTTLUpdate() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            DecisionDefinition decisionDefinition = this.findOnlyDecisionDefinition();
            this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
            this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), null);
        }).isInstanceOf(NotAllowedException.class)).hasMessage("Null historyTimeToLive values are not allowed");
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testUpdateHistoryTimeToLiveNegative() {
        CaseDefinition caseDefinition = this.findOnlyCaseDefinition();
        try {
            this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), Integer.valueOf(-1));
            Assert.fail((String)"Exception is expected, that negative value is not allowed.");
        }
        catch (BadUserRequestException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("greater than"));
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testUpdateHistoryTimeToLiveInCache() {
        CaseDefinition caseDefinition = this.findOnlyCaseDefinition();
        Assert.assertNull((Object)caseDefinition.getHistoryTimeToLive());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), Integer.valueOf(10));
        CaseDefinition definition = this.repositoryService.getCaseDefinition(caseDefinition.getId());
        Assert.assertEquals((Object)10, (Object)definition.getHistoryTimeToLive());
    }

    private CaseDefinition findOnlyCaseDefinition() {
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().list();
        Assert.assertNotNull((Object)caseDefinitions);
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        return (CaseDefinition)caseDefinitions.get(0);
    }

    private ProcessDefinition findOnlyProcessDefinition() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        return (ProcessDefinition)processDefinitions.get(0);
    }

    private DecisionDefinition findOnlyDecisionDefinition() {
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().list();
        Assert.assertNotNull((Object)decisionDefinitions);
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        return (DecisionDefinition)decisionDefinitions.get(0);
    }

    @Test
    public void testProcessDefinitionIntrospection() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml").deploy().getId();
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ReadOnlyProcessDefinition processDefinition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(procDefId);
        Assert.assertEquals((Object)procDefId, (Object)processDefinition.getId());
        Assert.assertEquals((Object)"Process One", (Object)processDefinition.getName());
        Assert.assertEquals((Object)"the first process", (Object)processDefinition.getProperty("documentation"));
        PvmActivity start = processDefinition.findActivity("start");
        Assert.assertNotNull((Object)start);
        Assert.assertEquals((Object)"start", (Object)start.getId());
        Assert.assertEquals((Object)"S t a r t", (Object)start.getProperty("name"));
        Assert.assertEquals((Object)"the start event", (Object)start.getProperty("documentation"));
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)start.getActivities());
        List outgoingTransitions = start.getOutgoingTransitions();
        Assert.assertEquals((long)1L, (long)outgoingTransitions.size());
        Assert.assertEquals((Object)"${a == b}", (Object)((PvmTransition)outgoingTransitions.get(0)).getProperty("conditionText"));
        PvmActivity end = processDefinition.findActivity("end");
        Assert.assertNotNull((Object)end);
        Assert.assertEquals((Object)"end", (Object)end.getId());
        PvmTransition transition = (PvmTransition)outgoingTransitions.get(0);
        Assert.assertEquals((Object)"flow1", (Object)transition.getId());
        Assert.assertEquals((Object)"Flow One", (Object)transition.getProperty("name"));
        Assert.assertEquals((Object)"The only transitions in the process", (Object)transition.getProperty("documentation"));
        Assert.assertSame((Object)start, (Object)transition.getSource());
        Assert.assertSame((Object)end, (Object)transition.getDestination());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    @Test
    public void testProcessDefinitionQuery() {
        String deployment1Id = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/processTwo.bpmn20.xml").deploy().getId();
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).orderByProcessDefinitionVersion().asc()).list();
        Assert.assertEquals((long)2L, (long)processDefinitions.size());
        String deployment2Id = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml").addClasspathResource("org/eximeebpms/bpm/engine/test/api/repository/processTwo.bpmn20.xml").deploy().getId();
        Assert.assertEquals((long)4L, (long)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).count());
        Assert.assertEquals((long)2L, (long)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionName().asc()).count());
        this.deleteDeployments(Arrays.asList(deployment1Id, deployment2Id));
    }

    @Test
    public void testGetProcessDefinitions() {
        ArrayList<String> deploymentIds = new ArrayList<String>();
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='IDR' name='Insurance Damage Report 1' isExecutable='true'><startEvent id='start'/></process></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='IDR' name='Insurance Damage Report 2' isExecutable='true'><startEvent id='start'/></process></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='IDR' name='Insurance Damage Report 3' isExecutable='true'><startEvent id='start'/></process></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='EN' name='Expense Note 1' isExecutable='true'><startEvent id='start'/></process></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='EN' name='Expense Note 2' isExecutable='true'><startEvent id='start'/></process></definitions>"));
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByProcessDefinitionVersion().desc()).list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)5L, (long)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Assert.assertEquals((Object)"EN", (Object)processDefinition.getKey());
        Assert.assertEquals((Object)"Expense Note 2", (Object)processDefinition.getName());
        Assert.assertTrue((boolean)processDefinition.getId().startsWith("EN:2"));
        Assert.assertEquals((long)2L, (long)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(1);
        Assert.assertEquals((Object)"EN", (Object)processDefinition.getKey());
        Assert.assertEquals((Object)"Expense Note 1", (Object)processDefinition.getName());
        Assert.assertTrue((boolean)processDefinition.getId().startsWith("EN:1"));
        Assert.assertEquals((long)1L, (long)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(2);
        Assert.assertEquals((Object)"IDR", (Object)processDefinition.getKey());
        Assert.assertEquals((Object)"Insurance Damage Report 3", (Object)processDefinition.getName());
        Assert.assertTrue((boolean)processDefinition.getId().startsWith("IDR:3"));
        Assert.assertEquals((long)3L, (long)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(3);
        Assert.assertEquals((Object)"IDR", (Object)processDefinition.getKey());
        Assert.assertEquals((Object)"Insurance Damage Report 2", (Object)processDefinition.getName());
        Assert.assertTrue((boolean)processDefinition.getId().startsWith("IDR:2"));
        Assert.assertEquals((long)2L, (long)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(4);
        Assert.assertEquals((Object)"IDR", (Object)processDefinition.getKey());
        Assert.assertEquals((Object)"Insurance Damage Report 1", (Object)processDefinition.getName());
        Assert.assertTrue((boolean)processDefinition.getId().startsWith("IDR:1"));
        Assert.assertEquals((long)1L, (long)processDefinition.getVersion());
        this.deleteDeployments(deploymentIds);
    }

    @Test
    public void testDeployIdenticalProcessDefinitions() {
        ArrayList<String> deploymentIds = new ArrayList<String>();
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + "><process id='IDR' name='Insurance Damage Report' isExecutable='true'><startEvent id='start'/></process></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + "><process id='IDR' name='Insurance Damage Report' isExecutable='true'><startEvent id='start'/></process></definitions>"));
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByProcessDefinitionVersion().desc()).list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)2L, (long)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Assert.assertEquals((Object)"IDR", (Object)processDefinition.getKey());
        Assert.assertEquals((Object)"Insurance Damage Report", (Object)processDefinition.getName());
        Assert.assertTrue((boolean)processDefinition.getId().startsWith("IDR:2"));
        Assert.assertEquals((long)2L, (long)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(1);
        Assert.assertEquals((Object)"IDR", (Object)processDefinition.getKey());
        Assert.assertEquals((Object)"Insurance Damage Report", (Object)processDefinition.getName());
        Assert.assertTrue((boolean)processDefinition.getId().startsWith("IDR:1"));
        Assert.assertEquals((long)1L, (long)processDefinition.getVersion());
        this.deleteDeployments(deploymentIds);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/call-activities-with-references.bpmn", "org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/repository/first-process.bpmn20.xml", "org/eximeebpms/bpm/engine/test/api/repository/three_.cmmn"})
    public void shouldReturnStaticCalledProcessDefinitions() {
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/repository/second-process.bpmn20.xml");
        this.testRule.deployForTenant("someTenant", "org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml");
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("TestCallActivitiesWithReferences").singleResult();
        String callingProcessId = processDefinition.getId();
        Collection mappings = this.repositoryService.getStaticCalledProcessDefinitions(callingProcessId);
        Assertions.assertThat((Iterable)mappings).hasSize(4);
        Assertions.assertThat(mappings.stream().filter(def -> def.getId().startsWith("process:1:")).flatMap(def -> def.getCalledFromActivityIds().stream()).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"deployment_1", "version_1"});
        Assertions.assertThat((Iterable)mappings).extracting(new String[]{"name", "version", "key", "calledFromActivityIds", "versionTag", "callingProcessDefinitionId"}).contains((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"Process One", 1, "processOne", Arrays.asList("tenant_reference_1"), null, callingProcessId}), Tuple.tuple((Object[])new Object[]{"Second Test Process", 2, "process", Arrays.asList("latest_reference_1"), null, callingProcessId}), Tuple.tuple((Object[])new Object[]{"Failing Process", 1, "failingProcess", Arrays.asList("version_tag_reference_1"), "ver_tag_2", callingProcessId})});
        for (CalledProcessDefinition called : mappings) {
            Assertions.assertThat((Object)called).isEqualToIgnoringGivenFields((Object)this.repositoryService.getProcessDefinition(called.getId()), new String[]{"calledFromActivityIds", "callingProcessDefinitionId"});
        }
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/dynamic-call-activities.bpmn"})
    public void shouldNotTryToResolveDynamicCalledElementBinding() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("DynamicCallActivities").singleResult();
        List callActivities = ((ProcessDefinitionImpl)this.repositoryService.getProcessDefinition(processDefinition.getId())).getActivities().stream().filter(act -> act.getActivityBehavior() instanceof CallActivityBehavior).map(activity -> {
            CallableElement callableElement = ((CallActivityBehavior)activity.getActivityBehavior()).getCallableElement();
            CallableElement spy = (CallableElement)Mockito.spy((Object)callableElement);
            ((CallActivityBehavior)activity.getActivityBehavior()).setCallableElement(spy);
            return activity;
        }).collect(Collectors.toList());
        Collection mappings = this.repositoryService.getStaticCalledProcessDefinitions(processDefinition.getId());
        for (ActivityImpl activity2 : callActivities) {
            CallableElement callableElement = ((CallActivityBehavior)activity2.getActivityBehavior()).getCallableElement();
            ((CallableElement)Mockito.verify((Object)callableElement, (VerificationMode)Mockito.never())).getDefinitionKey((VariableScope)Mockito.any());
            ((CallableElement)Mockito.verify((Object)callableElement, (VerificationMode)Mockito.never())).getVersion((VariableScope)Mockito.any());
            ((CallableElement)Mockito.verify((Object)callableElement, (VerificationMode)Mockito.never())).getVersionTag((VariableScope)Mockito.any());
            ((CallableElement)Mockito.verify((Object)callableElement, (VerificationMode)Mockito.never())).getDefinitionTenantId((VariableScope)Mockito.any(), Mockito.anyString());
            ((CallableElement)Mockito.verify((Object)callableElement, (VerificationMode)Mockito.times((int)1))).hasDynamicReferences();
        }
        Assertions.assertThat((Iterable)mappings).isEmpty();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/first-process.bpmn20.xml"})
    public void shouldReturnEmptyListIfNoCallActivityExists() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult();
        Collection maps = this.repositoryService.getStaticCalledProcessDefinitions(processDefinition.getId());
        Assertions.assertThat((Iterable)maps).isEmpty();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/repository/nested-call-activities.bpmn", "org/eximeebpms/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void shouldReturnCalledProcessDefinitionsForNestedCallActivities() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("nested-call-activities").singleResult();
        Collection calledProcessDefinitions = this.repositoryService.getStaticCalledProcessDefinitions(processDefinition.getId());
        Assertions.assertThat((Iterable)calledProcessDefinitions).hasSize(1);
        CalledProcessDefinition calledProcessDefinition = (CalledProcessDefinition)new ArrayList(calledProcessDefinitions).get(0);
        Assertions.assertThat((String)calledProcessDefinition.getKey()).isEqualTo((Object)"failingProcess");
        Assertions.assertThat(calledProcessDefinition.getCalledFromActivityIds().stream().distinct().collect(Collectors.toList())).hasSize(8);
    }

    @Test
    public void testGetStaticCallActivityMappingShouldThrowIfProcessDoesNotExist() {
        Assert.assertThrows(NotFoundException.class, () -> this.repositoryService.getStaticCalledProcessDefinitions("notExistingId"));
    }

    @Test
    public void shouldReturnCorrectProcessesForCallActivityWithTenantId() {
        String processOne = "org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml";
        String processTwo = "org/eximeebpms/bpm/engine/test/api/repository/processTwo.bpmn20.xml";
        String aTenant = "aTenant";
        String anotherTenant = "anotherTenant";
        String id = this.testRule.deployForTenantAndGetDefinition("aTenant", "org/eximeebpms/bpm/engine/test/api/repository/call_activities_with_tenants.bpmn").getId();
        this.testRule.deployForTenant("anotherTenant", "org/eximeebpms/bpm/engine/test/api/repository/processTwo.bpmn20.xml");
        String sameTenantProcessOne = this.testRule.deployForTenantAndGetDefinition("aTenant", "org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml").getId();
        String otherTenantProcessOne = this.testRule.deployForTenantAndGetDefinition("anotherTenant", "org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml").getId();
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/repository/processOne.bpmn20.xml");
        this.testRule.deploy("org/eximeebpms/bpm/engine/test/api/repository/processTwo.bpmn20.xml");
        Collection mappings = this.repositoryService.getStaticCalledProcessDefinitions(id);
        Assertions.assertThat((Iterable)mappings).hasSize(2);
        Assertions.assertThat(mappings.stream().filter(def -> def.getId().equals(sameTenantProcessOne)).flatMap(def -> def.getCalledFromActivityIds().stream()).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"null_tenant_reference_same_tenant", "explicit_same_tenant_reference"});
        Assertions.assertThat((Iterable)mappings).extracting(new String[]{"id", "calledFromActivityIds", "callingProcessDefinitionId"}).contains((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{otherTenantProcessOne, Arrays.asList("explicit_other_tenant_reference"), id})});
    }

    private String deployProcessString(String processString) {
        String resourceName = "xmlString." + BpmnDeployer.BPMN_RESOURCE_SUFFIXES[0];
        return this.repositoryService.createDeployment().addString(resourceName, processString).deploy().getId();
    }

    private void deleteDeployments(Collection<String> deploymentIds) {
        for (String deploymentId : deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId);
        }
    }
}

