/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.Collection;
import org.eximeebpms.bpm.engine.authorization.BatchPermissions;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatch;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.eximeebpms.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.BatchModificationHelper;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RequiredHistoryLevel(value="full")
@RunWith(value=Parameterized.class)
public class BatchRestartAuthorizationTest {
    protected static final String TEST_REASON = "test reason";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchModificationHelper helper = new BatchModificationHelper(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_RESTART_PROCESS_INSTANCES})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_HISTORY})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.CREATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_HISTORY, Permissions.CREATE_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.CREATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_RESTART_PROCESS_INSTANCES}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_HISTORY, Permissions.CREATE_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.CREATE})).succeeds());
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.engineRule.getManagementService().createBatchQuery().singleResult();
        if (batch != null) {
            this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().singleResult()) != null) {
            this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
        }
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void executeBatch() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        this.engineRule.getRuntimeService().deleteProcessInstance(processInstance1.getId(), TEST_REASON);
        this.engineRule.getRuntimeService().deleteProcessInstance(processInstance2.getId(), TEST_REASON);
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance1", processInstance1.getId()).bindResource("restartedProcessInstance", "*").bindResource("processInstance2", processInstance2.getId()).bindResource("processDefinition", "Process").bindResource("batchId", "*").start();
        Batch batch = ((RestartProcessInstanceBuilder)this.engineRule.getRuntimeService().restartProcessInstances(processDefinition.getId()).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).startAfterActivity("userTask1")).executeAsync();
        if (batch != null) {
            Job job = (Job)this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).singleResult();
            this.engineRule.getManagementService().executeJob(job.getId());
            for (Job pending : this.engineRule.getManagementService().createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list()) {
                this.engineRule.getManagementService().executeJob(pending.getId());
            }
        }
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((Object)"userId", (Object)batch.getCreateUserId());
        }
    }
}

