/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatch;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstanceQuery;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceQuery;
import org.eximeebpms.bpm.engine.runtime.VariableInstanceQuery;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.runtime.BatchHelper;
import org.eximeebpms.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.eximeebpms.bpm.engine.test.util.BatchRule;
import org.eximeebpms.bpm.engine.test.util.ExecutableProcessUtil;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.value.SerializationDataFormat;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class SetVariablesBatchTest {
    protected static final String PROCESS_KEY = "process";
    protected static final Date TEST_DATE = new Date(1457326800000L);
    protected static final VariableMap SINGLE_VARIABLE = Variables.putValue((String)"foo", (Object)"bar");
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchRule batchRule = new BatchRule(this.engineRule, this.engineTestRule);
    protected BatchHelper helper = new BatchHelper(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule).around((TestRule)this.batchRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ManagementService managementService;

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Before
    public void deployProcess() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask().endEvent().done();
        this.engineTestRule.deploy(process);
    }

    @After
    public void clearAuthentication() {
        ClockUtil.reset();
        this.engineRule.getIdentityService().setAuthenticatedUserId(null);
    }

    @Test
    public void shouldSetByIds() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.setVariablesAsync(processInstances, (Map)SINGLE_VARIABLE);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", "bar", batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", "bar"})});
    }

    @Test
    public void shouldSetByIds_TypedValue() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.setVariablesAsync(processInstances, (Map)Variables.putValue((String)"foo", (Object)Variables.stringValue((String)"bar")));
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", "bar", batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", "bar"})});
    }

    @Test
    public void shouldSetByIds_MixedTypedAndUntypedValues() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.setVariablesAsync(processInstances, (Map)Variables.putValue((String)"foo", (Object)Variables.stringValue((String)"bar")).putValue("bar", (Object)"foo"));
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", "bar", batch.getId()}), Assertions.tuple((Object[])new Object[]{null, "bar", "foo", batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "bar", "foo"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "bar", "foo"})});
    }

    @Test
    public void shouldSetByIds_ObjectValue() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        TestPojo pojo = new TestPojo("bar", 3.0);
        Batch batch = this.runtimeService.setVariablesAsync(processInstances, (Map)Variables.putValue((String)"foo", (Object)Variables.objectValue((Object)pojo)));
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", pojo, batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "foo", pojo}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", pojo})});
    }

    @Test
    public void shouldSetByIds_MultipleVariables() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        List<String> processInstances = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.setVariablesAsync(processInstances, (Map)Variables.putValue((String)"variableOne", (Object)"string").putValue("variableTwo", (Object)42).putValue("variableThree", (Object)3));
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "variableOne", "string", batch.getId()}), Assertions.tuple((Object[])new Object[]{null, "variableTwo", 42, batch.getId()}), Assertions.tuple((Object[])new Object[]{null, "variableThree", (short)3, batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "variableOne", "string"}), Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "variableTwo", 42}), Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "variableThree", (short)3}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "variableOne", "string"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "variableTwo", 42}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "variableThree", (short)3})});
    }

    @Test
    public void shouldSetByIds_VariablesAsMap() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        List<String> processInstanceIds = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        variablesMap.put("foo", "bar");
        variablesMap.put("bar", "foo");
        Batch batch = this.runtimeService.setVariablesAsync(processInstanceIds, variablesMap);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", "bar", batch.getId()}), Assertions.tuple((Object[])new Object[]{null, "bar", "foo", batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "bar", "foo"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "bar", "foo"})});
    }

    @Test
    public void shouldSetByRuntimeQuery() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.runtimeService.setVariablesAsync(runtimeQuery, (Map)SINGLE_VARIABLE);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", "bar", batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", "bar"})});
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void shouldSetByIdsAndQueries() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdThree = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceIdTwo);
        HistoricProcessInstanceQuery historyQuery = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceIdThree);
        Batch batch = this.runtimeService.setVariablesAsync(Collections.singletonList(processInstanceIdOne), runtimeQuery, historyQuery, (Map)SINGLE_VARIABLE);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", "bar", batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdThree, "foo", "bar"})});
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void shouldSetByHistoryQuery() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        HistoricProcessInstanceQuery historyQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.runtimeService.setVariablesAsync(historyQuery, (Map)SINGLE_VARIABLE);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", "bar", batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdOne, "foo", "bar"}), Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", "bar"})});
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void shouldSetByHistoryQuery_WithFinishedInstances() {
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.deleteProcessInstance(processInstanceIdOne, "dunno");
        HistoricProcessInstanceQuery historyQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.runtimeService.setVariablesAsync(historyQuery, (Map)SINGLE_VARIABLE);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value", "batchId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "foo", "bar", batch.getId()})});
        this.batchRule.syncExec(batch);
        Assertions.assertThat((List)query.list()).extracting(new String[]{"processInstanceId", "name", "value"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstanceIdTwo, "foo", "bar"})});
    }

    @Test
    public void shouldThrowException_TransientVariable() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setVariablesAsync(Collections.singletonList(processInstanceId), (Map)Variables.putValue((String)"foo", (Object)Variables.stringValue((String)"bar", (boolean)true)))).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("ENGINE-13044 Setting transient variable 'foo' asynchronously is currently not supported.");
    }

    @Test
    public void shouldThrowException_JavaSerializationForbidden() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setVariablesAsync(runtimeQuery, (Map)Variables.putValue((String)"foo", (Object)Variables.serializedObjectValue().serializedValue("foo").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()))).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("ENGINE-17007 Cannot set variable with name foo. Java serialization format is prohibited");
    }

    @Test
    public void shouldThrowException_NoProcessInstancesFound() {
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setVariablesAsync(runtimeQuery, (Map)SINGLE_VARIABLE)).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("processInstanceIds is empty");
    }

    @Test
    public void shouldThrowException_QueriesAndIdsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setVariablesAsync(null, null, null, (Map)SINGLE_VARIABLE)).isInstanceOf(NullValueException.class)).hasMessageContaining("No process instances found.");
    }

    @Test
    public void shouldThrowException_VariablesNull() {
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setVariablesAsync(runtimeQuery, null)).isInstanceOf(NullValueException.class)).hasMessageContaining("variables is null");
    }

    @Test
    public void shouldThrowException_VariablesEmpty() {
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setVariablesAsync(runtimeQuery, Collections.emptyMap())).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("variables is empty");
    }

    @Test
    public void shouldCreateDeploymentAwareBatchJobs_ByIds() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.deployProcess();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        List list = this.engineRule.getRepositoryService().createDeploymentQuery().list();
        String deploymentIdOne = ((Deployment)list.get(0)).getId();
        String deploymentIdTwo = ((Deployment)list.get(1)).getId();
        List<String> processInstanceIds = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.setVariablesAsync(processInstanceIds, (Map)SINGLE_VARIABLE);
        this.batchRule.executeSeedJobs(batch);
        List<Job> executionJobs = this.batchRule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("deploymentId").containsExactlyInAnyOrder(new Object[]{deploymentIdOne, deploymentIdTwo});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldCreateDeploymentAwareBatchJobs_ByRuntimeQuery() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        this.deployProcess();
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        List list = this.engineRule.getRepositoryService().createDeploymentQuery().list();
        String deploymentIdOne = ((Deployment)list.get(0)).getId();
        String deploymentIdTwo = ((Deployment)list.get(1)).getId();
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.runtimeService.setVariablesAsync(runtimeQuery, (Map)SINGLE_VARIABLE);
        this.batchRule.executeSeedJobs(batch);
        List<Job> executionJobs = this.batchRule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("deploymentId").containsExactlyInAnyOrder(new Object[]{deploymentIdOne, deploymentIdTwo});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @RequiredHistoryLevel(value="activity")
    public void shouldCreateDeploymentAwareBatchJobs_ByHistoryQuery() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        this.deployProcess();
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        List list = this.engineRule.getRepositoryService().createDeploymentQuery().list();
        String deploymentIdOne = ((Deployment)list.get(0)).getId();
        String deploymentIdTwo = ((Deployment)list.get(1)).getId();
        HistoricProcessInstanceQuery historyQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.runtimeService.setVariablesAsync(historyQuery, (Map)SINGLE_VARIABLE);
        this.batchRule.executeSeedJobs(batch);
        List<Job> executionJobs = this.batchRule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("deploymentId").containsExactlyInAnyOrder(new Object[]{deploymentIdOne, deploymentIdTwo});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldLogOperation() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        this.engineRule.getIdentityService().setAuthenticatedUserId("demo");
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.runtimeService.setVariablesAsync(runtimeQuery, (Map)SINGLE_VARIABLE);
        List logs = this.historyService.createUserOperationLogQuery().list();
        Assertions.assertThat((List)logs).extracting(new String[]{"property", "orgValue", "newValue", "operationType", "entityType", "category", "userId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"nrOfInstances", null, "1", "SetVariables", "ProcessInstance", "Operator", "demo"}), Assertions.tuple((Object[])new Object[]{"nrOfVariables", null, "1", "SetVariables", "ProcessInstance", "Operator", "demo"}), Assertions.tuple((Object[])new Object[]{"async", null, "true", "SetVariables", "ProcessInstance", "Operator", "demo"})});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldNotLogInstanceOperation() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstanceQuery runtimeQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.runtimeService.setVariablesAsync(runtimeQuery, (Map)SINGLE_VARIABLE);
        this.engineRule.getIdentityService().setAuthenticatedUserId("demo");
        this.batchRule.syncExec(batch);
        List logs = this.historyService.createUserOperationLogQuery().operationType("SetVariable").list();
        Assertions.assertThat((int)logs.size()).isEqualTo(0);
    }

    @Test
    public void shouldCreateProcessInstanceRelatedBatchJobsForSingleInvocations() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        List<String> processInstanceIds = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.setVariablesAsync(processInstanceIds, (Map)SINGLE_VARIABLE);
        this.batchRule.executeSeedJobs(batch);
        List<Job> executionJobs = this.batchRule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("processInstanceId").containsExactlyInAnyOrder(new Object[]{processInstanceIdOne, processInstanceIdTwo});
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldNotCreateProcessInstanceRelatedBatchJobsForMultipleInvocations() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        String processInstanceIdOne = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        List<String> processInstanceIds = Arrays.asList(processInstanceIdOne, processInstanceIdTwo);
        Batch batch = this.runtimeService.setVariablesAsync(processInstanceIds, (Map)SINGLE_VARIABLE);
        this.batchRule.executeSeedJobs(batch);
        List<Job> executionJobs = this.batchRule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).extracting("processInstanceId").containsOnlyNulls();
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldSetExecutionStartTimeInBatchAndHistory() {
        ClockUtil.setCurrentTime((Date)TEST_DATE);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        Batch batch = this.runtimeService.setVariablesAsync(this.runtimeService.createProcessInstanceQuery(), (Map)SINGLE_VARIABLE);
        this.helper.executeSeedJob(batch);
        List<Job> executionJobs = this.helper.getExecutionJobs(batch, "set-variables");
        this.helper.executeJob(executionJobs.get(0));
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        batch = (Batch)this.managementService.createBatchQuery().singleResult();
        Assertions.assertThat((Date)batch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
        Assertions.assertThat((Date)historicBatch.getExecutionStartTime()).isEqualToIgnoringMillis(TEST_DATE);
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void setVariablesAsyncOnCompletedProcessInstance() {
        this.engineTestRule.deploy(ExecutableProcessUtil.USER_TASK_PROCESS);
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        Batch batch = this.runtimeService.setVariablesAsync(List.of(id), (Map)SINGLE_VARIABLE);
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(id).singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        this.batchRule.syncExec(batch);
    }

    @Test
    public void setVariablesAsyncOnCompletedProcessInstanceWithQuery() {
        this.engineTestRule.deploy(ExecutableProcessUtil.USER_TASK_PROCESS);
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        Batch batch = this.runtimeService.setVariablesAsync(this.runtimeService.createProcessInstanceQuery().processInstanceId(id), (Map)SINGLE_VARIABLE);
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(id).singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        this.batchRule.syncExec(batch);
    }

    @Test
    public void setVariablesAsyncOnCompletedProcessInstanceWithHistoricQuery() {
        this.engineTestRule.deploy(ExecutableProcessUtil.USER_TASK_PROCESS);
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        Batch batch = this.runtimeService.setVariablesAsync(this.historyService.createHistoricProcessInstanceQuery().processInstanceId(id), (Map)SINGLE_VARIABLE);
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(id).singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        this.batchRule.syncExec(batch);
    }

    @Test
    public void setVariablesSyncOnCompletedProcessInstance() {
        this.engineTestRule.deploy(ExecutableProcessUtil.USER_TASK_PROCESS);
        String id = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(id).singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        Assertions.assertThatThrownBy(() -> this.runtimeService.setVariables(id, (Map)SINGLE_VARIABLE)).isInstanceOf(NullValueException.class);
    }

    @Test
    public void setVariablesAsyncOnBatchWithOneCompletedInstance() {
        this.engineTestRule.deploy(ExecutableProcessUtil.USER_TASK_PROCESS);
        String id1 = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        String id2 = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        Batch batch = this.runtimeService.setVariablesAsync(List.of(id1, id2), (Map)SINGLE_VARIABLE);
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().processInstanceId(id1).singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        this.batchRule.syncExec(batch);
        Assertions.assertThat((boolean)this.runtimeService.getVariables(id2).equals(SINGLE_VARIABLE));
    }
}

