/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.runtime.migration;

import org.eximeebpms.bpm.engine.migration.MigrationPlan;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.eximeebpms.bpm.engine.test.bpmn.event.conditional.SetVariableDelegate;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SubProcessBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationWithoutTriggerConditionTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testIntermediateConditionalEventWithSetVariableOnEndListener() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((ConditionalEventDefinitionBuilder)((SubProcessBuilder)Bpmn.createExecutableProcess().startEvent().subProcess().camundaExecutionListenerClass("end", SetVariableDelegate.class.getName())).embeddedSubProcess().startEvent().intermediateCatchEvent("conditionCatch").conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask("afterConditionId").endEvent().subProcessDone().endEvent().done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess().startEvent().intermediateCatchEvent("conditionCatch").conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask("afterConditionId").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("conditionCatch", "conditionCatch").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("conditionCatch", "conditionCatch", null);
        Assert.assertEquals((Object)1, (Object)this.rule.getRuntimeService().getVariable(processInstance.getId(), "variable"));
        Assert.assertNull((Object)this.rule.getTaskService().createTaskQuery().singleResult());
        this.testHelper.setAnyVariable(processInstance.getId());
        this.testHelper.completeTask("afterConditionId");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testIntermediateConditionalEventWithSetVariableOnStartListener() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((ConditionalEventDefinitionBuilder)Bpmn.createExecutableProcess().startEvent().intermediateCatchEvent("conditionCatch").conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask("afterConditionId").endEvent().done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((ConditionalEventDefinitionBuilder)((SubProcessBuilder)Bpmn.createExecutableProcess().startEvent().subProcess().camundaExecutionListenerClass("start", SetVariableDelegate.class.getName())).embeddedSubProcess().startEvent().intermediateCatchEvent("conditionCatch").conditionalEventDefinition().condition("${variable == 1}")).conditionalEventDefinitionDone().userTask("afterConditionId").endEvent().subProcessDone().endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("conditionCatch", "conditionCatch").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("conditionCatch", "conditionCatch", null);
        Assert.assertEquals((Object)1, (Object)this.rule.getRuntimeService().getVariable(processInstance.getId(), "variable"));
        Assert.assertNull((Object)this.rule.getTaskService().createTaskQuery().singleResult());
        this.testHelper.setAnyVariable(processInstance.getId());
        this.testHelper.completeTask("afterConditionId");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testBoundaryConditionalEventWithSetVariableOnStartListener() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).userTaskBuilder("userTask").boundaryEvent("boundaryId").condition("${variable == 1}")).userTask("afterConditionId").endEvent().done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(((SubProcessBuilder)Bpmn.createExecutableProcess().startEvent().subProcess("subProcess").camundaExecutionListenerClass("start", SetVariableDelegate.class.getName())).embeddedSubProcess().startEvent().userTask("userTask").endEvent().subProcessDone().endEvent().done()).userTaskBuilder("userTask").boundaryEvent("boundaryId").condition("${variable == 1}")).endEvent().moveToActivity("subProcess").boundaryEvent().condition("${variable == 1}")).userTask("afterConditionId").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundaryId", "boundaryId").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundaryId", "boundaryId", null);
        Assert.assertEquals((Object)1, (Object)this.rule.getRuntimeService().getVariable(processInstance.getId(), "variable"));
        Assert.assertEquals((Object)"userTask", (Object)((Task)this.rule.getTaskService().createTaskQuery().singleResult()).getTaskDefinitionKey());
        this.testHelper.setAnyVariable(processInstance.getId());
        this.testHelper.completeTask("afterConditionId");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testBoundaryConditionalEventWithSetVariableOnEndListener() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(((SubProcessBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().subProcess("subProcess").camundaExecutionListenerClass("end", SetVariableDelegate.class.getName())).embeddedSubProcess().startEvent().userTask("userTask").endEvent().subProcessDone().endEvent().done()).userTaskBuilder("userTask").boundaryEvent("boundaryId").condition("${variable == 1}")).endEvent().moveToActivity("subProcess").boundaryEvent().condition("${variable == 1}")).userTask("afterConditionId").endEvent().done());
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).userTaskBuilder("userTask").boundaryEvent("boundaryId").condition("${variable == 1}")).userTask("afterConditionId").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundaryId", "boundaryId").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundaryId", "boundaryId", null);
        Assert.assertEquals((Object)1, (Object)this.rule.getRuntimeService().getVariable(processInstance.getId(), "variable"));
        Assert.assertEquals((Object)"userTask", (Object)((Task)this.rule.getTaskService().createTaskQuery().singleResult()).getTaskDefinitionKey());
        this.testHelper.setAnyVariable(processInstance.getId());
        this.testHelper.completeTask("afterConditionId");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void tesConditionalEventSubProcessWithSetVariableOnStartListener() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSubProcessTo("Process").triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").condition("${variable == 1}")).userTask("afterConditionId").endEvent().done());
        BpmnModelInstance targetModel = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(((SubProcessBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().subProcess("subProcess").camundaExecutionListenerClass("start", SetVariableDelegate.class.getName())).embeddedSubProcess().startEvent().userTask("userTask").endEvent().subProcessDone().endEvent().done()).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent().condition("${variable == 1}")).endEvent().done();
        targetModel = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(targetModel).addSubProcessTo("Process").triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").condition("${variable == 1}")).userTask("afterConditionId").endEvent().done();
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetModel);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcessStart", "eventSubProcessStart", null);
        Assert.assertEquals((Object)1, (Object)this.rule.getRuntimeService().getVariable(processInstance.getId(), "variable"));
        Assert.assertEquals((Object)"userTask", (Object)((Task)this.rule.getTaskService().createTaskQuery().singleResult()).getTaskDefinitionKey());
        this.testHelper.setAnyVariable(processInstance.getId());
        this.testHelper.completeTask("afterConditionId");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void testConditionalEventSubProcessWithSetVariableOnEndListener() {
        BpmnModelInstance sourceModel = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(((SubProcessBuilder)Bpmn.createExecutableProcess((String)"Process").startEvent().subProcess("subProcess").camundaExecutionListenerClass("end", SetVariableDelegate.class.getName())).embeddedSubProcess().startEvent().userTask("userTask").endEvent().subProcessDone().endEvent().done()).addSubProcessTo("Process").triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").condition("${variable == 1}")).endEvent().done();
        sourceModel = ((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(sourceModel).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent().condition("${variable == 1}")).userTask("afterConditionId").endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceModel);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).addSubProcessTo("Process").triggerByEvent()).embeddedSubProcess().startEvent("eventSubProcessStart").condition("${variable == 1}")).userTask("afterConditionId").endEvent().done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("eventSubProcessStart", "eventSubProcessStart").updateEventTrigger().build();
        ProcessInstance processInstance = this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("eventSubProcessStart", "eventSubProcessStart", null);
        Assert.assertEquals((Object)1, (Object)this.rule.getRuntimeService().getVariable(processInstance.getId(), "variable"));
        Assert.assertEquals((Object)"userTask", (Object)((Task)this.rule.getTaskService().createTaskQuery().singleResult()).getTaskDefinitionKey());
        this.testHelper.setAnyVariable(processInstance.getId());
        this.testHelper.completeTask("afterConditionId");
        this.testHelper.assertProcessEnded(processInstance.getId());
    }
}

