/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.task;

import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.OptimisticLockingException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StandaloneTaskTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("gonzo");
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Test
    public void testCreateToComplete() {
        Task task = this.taskService.newTask();
        task.setName("testTask");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.addCandidateUser(taskId, "kermit");
        this.taskService.addCandidateUser(taskId, "gonzo");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"testTask", (Object)((Task)tasks.get(0)).getName());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("gonzo").list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"testTask", (Object)((Task)tasks.get(0)).getName());
        this.taskService.claim(taskId, "kermit");
        Assert.assertTrue((boolean)this.taskService.createTaskQuery().taskCandidateUser("kermit").list().isEmpty());
        Assert.assertTrue((boolean)this.taskService.createTaskQuery().taskCandidateUser("gonzo").list().isEmpty());
        this.taskService.deleteTask(taskId, true);
        Assert.assertNull((Object)this.taskService.createTaskQuery().taskId(taskId).singleResult());
    }

    @Test
    public void testOptimisticLockingThrownOnMultipleUpdates() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        Task task1 = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        task1.setDescription("first modification");
        this.taskService.saveTask(task1);
        task2.setDescription("second modification");
        try {
            this.taskService.saveTask(task2);
            Assert.fail((String)"should get an exception here as the task was modified by someone else.");
        }
        catch (OptimisticLockingException optimisticLockingException) {
            // empty catch block
        }
    }

    @Test
    public void testRevisionUpdatedOnSave() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        Assert.assertEquals((long)1L, (long)((TaskEntity)task).getRevision());
        task.setDescription("first modification");
        this.taskService.saveTask(task);
        Assert.assertEquals((long)2L, (long)((TaskEntity)task).getRevision());
        task.setDescription("second modification");
        this.taskService.saveTask(task);
        Assert.assertEquals((long)3L, (long)((TaskEntity)task).getRevision());
    }

    @Test
    public void testSaveTaskWithGenericResourceId() {
        Task task = this.taskService.newTask("*");
        try {
            this.taskService.saveTask(task);
            Assert.fail((String)"it should not be possible to save a task with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Entity Task[*] has an invalid id: id cannot be *. * is a reserved identifier", e.getMessage());
        }
    }

    @Test
    public void shouldSetLastUpdatedOnUpdate() {
        Task task = this.taskService.newTask("shouldSetLastUpdatedOnUpdate");
        task.setAssignee("myself");
        this.taskService.saveTask(task);
        ClockUtil.offset((Long)1000L);
        this.taskService.setVariable(task.getId(), "myVar", (Object)"varVal");
        Task taskResult = (Task)this.taskService.createTaskQuery().taskId("shouldSetLastUpdatedOnUpdate").singleResult();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isNotNull();
        Assertions.assertThat((Date)taskResult.getCreateTime()).isBefore(taskResult.getLastUpdated());
    }

    @Test
    public void shouldNotSetLastUpdatedOnCreate() {
        Task task = this.taskService.newTask("shouldNotSetLastUpdatedOnCreate");
        task.setAssignee("myself");
        this.taskService.saveTask(task);
        Task taskResult = (Task)this.taskService.createTaskQuery().taskId("shouldNotSetLastUpdatedOnCreate").singleResult();
        Assertions.assertThat((Date)taskResult.getLastUpdated()).isNull();
    }
}

