/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.variables;

import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.history.HistoricCaseInstance;
import org.eximeebpms.bpm.engine.impl.HistoricCaseInstanceQueryImpl;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.api.variables.AbstractVariableIgnoreCaseTest;
import org.junit.After;
import org.junit.Before;

@RequiredHistoryLevel(value="audit")
public class HistoricCaseInstanceQueryVariableIgnoreCaseTest
extends AbstractVariableIgnoreCaseTest<HistoricCaseInstanceQueryImpl, HistoricCaseInstance> {
    RepositoryService repositoryService;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/api/cmmn/oneTaskCase.cmmn").deploy();
        this.engineRule.getCaseService().withCaseDefinitionByKey("oneTaskCase").setVariables(VARIABLES).businessKey("oneTaskCase").create();
        this.instance = this.engineRule.getHistoryService().createHistoricCaseInstanceQuery().singleResult();
    }

    @After
    public void tearDown() {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Override
    protected HistoricCaseInstanceQueryImpl createQuery() {
        return (HistoricCaseInstanceQueryImpl)this.engineRule.getHistoryService().createHistoricCaseInstanceQuery();
    }

    @Override
    protected void assertThatTwoInstancesAreEqual(HistoricCaseInstance one, HistoricCaseInstance two) {
        Assertions.assertThat((String)one.getId()).isEqualTo((Object)two.getId());
    }
}

