/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.api.variables;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PrimitiveTypeValueSerializationTest {
    protected static final String BPMN_FILE = "org/eximeebpms/bpm/engine/test/api/variables/oneTaskProcess.bpmn20.xml";
    protected static final String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    protected static final String VARIABLE_NAME = "variable";
    @Parameterized.Parameter(value=0)
    public TypedValue typedValue;
    @Parameterized.Parameter(value=1)
    public TypedValue nullValue;
    private RuntimeService runtimeService;
    private RepositoryService repositoryService;
    private String deploymentId;
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();

    @Parameterized.Parameters(name="{index}: variable = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({Variables.stringValue((String)"a"), Variables.stringValue(null)}, {Variables.booleanValue((Boolean)true), Variables.booleanValue(null)}, {Variables.integerValue((Integer)4), Variables.integerValue(null)}, {Variables.shortValue((Short)2), Variables.shortValue(null)}, {Variables.longValue((Long)6L), Variables.longValue(null)}, {Variables.doubleValue((Double)4.2), Variables.doubleValue(null)}, {Variables.dateValue((Date)new Date()), Variables.dateValue(null)});
    }

    @Before
    public void setup() {
        this.runtimeService = this.rule.getRuntimeService();
        this.repositoryService = this.rule.getRepositoryService();
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource(BPMN_FILE).deploy().getId();
    }

    @After
    public void teardown() {
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    @Test
    public void shouldGetUntypedVariable() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.runtimeService.setVariable(instance.getId(), VARIABLE_NAME, (Object)this.typedValue);
        Object variableValue = this.runtimeService.getVariable(instance.getId(), VARIABLE_NAME);
        Assert.assertEquals((Object)this.typedValue.getValue(), (Object)variableValue);
    }

    @Test
    public void shouldGetTypedVariable() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.runtimeService.setVariable(instance.getId(), VARIABLE_NAME, (Object)this.typedValue);
        TypedValue typedVariableValue = this.runtimeService.getVariableTyped(instance.getId(), VARIABLE_NAME);
        Assert.assertEquals((Object)this.typedValue.getType(), (Object)typedVariableValue.getType());
        Assert.assertEquals((Object)this.typedValue.getValue(), (Object)typedVariableValue.getValue());
    }

    @Test
    public void shouldGetTypedNullVariable() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.runtimeService.setVariable(instance.getId(), VARIABLE_NAME, (Object)this.nullValue);
        Assert.assertEquals(null, (Object)this.runtimeService.getVariable(instance.getId(), VARIABLE_NAME));
        TypedValue typedVariableValue = this.runtimeService.getVariableTyped(instance.getId(), VARIABLE_NAME);
        Assert.assertEquals((Object)this.nullValue.getType(), (Object)typedVariableValue.getType());
        Assert.assertEquals(null, (Object)typedVariableValue.getValue());
    }
}

