/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.behavior;

import ch.qos.logback.classic.Level;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;

public class BpmnBehaviorLoggerTest
extends PluggableProcessEngineTest {
    @Rule
    public ProcessEngineLoggingRule processEngineLoggingRule = new ProcessEngineLoggingRule().watch("org.eximeebpms.bpm.engine.bpmn.behavior", Level.INFO);

    @After
    public void tearDown() {
        this.processEngineConfiguration.setEnableExceptionsAfterUnhandledBpmnError(false);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/behavior/BpmnBehaviorLoggerTest.UnhandledBpmnError.bpmn20.xml"})
    public void shouldIncludeBpmnErrorMessageInUnhandledBpmnError() {
        this.processEngineConfiguration.setEnableExceptionsAfterUnhandledBpmnError(true);
        String errorMessage = "Execution with id 'serviceTask' throws an error event with errorCode 'errorCode' and errorMessage 'ouch!', but no error handler was defined";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.startProcessInstanceByKey("testProcess")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining(errorMessage);
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/behavior/BpmnBehaviorLoggerTest.UnhandledBpmnError.bpmn20.xml"})
    public void shouldLogBpmnErrorMessageInUnhandledBpmnErrorWithoutException() {
        String logMessage = "Execution with id 'serviceTask' throws an error event with errorCode 'errorCode' and errorMessage 'ouch!'";
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Assertions.assertThat((List)this.processEngineLoggingRule.getFilteredLog(logMessage)).hasSize(1);
    }
}

