/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.conditional;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.eximeebpms.bpm.engine.test.bpmn.event.conditional.AbstractConditionalEventTestCase;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.ConditionalEventDefinitionBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.StartEventBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.SubProcessBuilder;
import org.eximeebpms.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConditionalEventWithSpecificVariableEventTest
extends AbstractConditionalEventTestCase {
    @Parameterized.Parameter
    public ConditionalProcessVarSpecification specifier;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new ConditionalProcessVarSpecification(){

            @Override
            public BpmnModelInstance getProcessWithVarName(boolean interrupting, String condition) {
                return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(AbstractConditionalEventTestCase.TASK_MODEL).userTaskBuilder("beforeConditionId").boundaryEvent().cancelActivity(Boolean.valueOf(interrupting))).conditionalEventDefinition("conditionalEvent").condition(condition)).camundaVariableName("variable")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
            }

            @Override
            public BpmnModelInstance getProcessWithVarNameAndEvents(boolean interrupting, String varEvent) {
                return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(AbstractConditionalEventTestCase.TASK_MODEL).userTaskBuilder("beforeConditionId").boundaryEvent().cancelActivity(Boolean.valueOf(interrupting))).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).camundaVariableName("variable")).camundaVariableEvents(varEvent)).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
            }

            @Override
            public BpmnModelInstance getProcessWithVarEvents(boolean interrupting, String varEvent) {
                return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(AbstractConditionalEventTestCase.TASK_MODEL).userTaskBuilder("beforeConditionId").boundaryEvent().cancelActivity(Boolean.valueOf(interrupting))).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).camundaVariableEvents(varEvent)).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
            }

            public String toString() {
                return "ConditionalBoundaryEventWithVarEvents";
            }
        }}, {new ConditionalProcessVarSpecification(){

            @Override
            public BpmnModelInstance getProcessWithVarName(boolean interrupting, String condition) {
                return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(AbstractConditionalEventTestCase.TASK_MODEL).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(interrupting)).conditionalEventDefinition("conditionalEvent").condition(condition)).camundaVariableName("variable")).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
            }

            @Override
            public BpmnModelInstance getProcessWithVarNameAndEvents(boolean interrupting, String varEvent) {
                return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(AbstractConditionalEventTestCase.TASK_MODEL).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(interrupting)).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).camundaVariableName("variable")).camundaVariableEvents(varEvent)).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
            }

            @Override
            public BpmnModelInstance getProcessWithVarEvents(boolean interrupting, String varEvent) {
                return ((UserTaskBuilder)((ConditionalEventDefinitionBuilder)((ConditionalEventDefinitionBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(AbstractConditionalEventTestCase.TASK_MODEL).addSubProcessTo("conditionalEventProcess").triggerByEvent()).embeddedSubProcess().startEvent().interrupting(interrupting)).conditionalEventDefinition("conditionalEvent").condition("${variable == 1}")).camundaVariableEvents(varEvent)).conditionalEventDefinitionDone().userTask().name("After Condition")).endEvent().done();
            }

            public String toString() {
                return "ConditionalStartEventWithVarEvents";
            }
        }});
    }

    @Test
    public void testVariableConditionWithVariableName() {
        BpmnModelInstance modelInstance = this.specifier.getProcessWithVarName(true, "${variable == 1}");
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable1", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableNameAndEvent() {
        BpmnModelInstance modelInstance = this.specifier.getProcessWithVarNameAndEvents(true, "update");
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingVariableConditionWithVariableName() {
        BpmnModelInstance modelInstance = this.specifier.getProcessWithVarName(false, "${true}");
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        List tasks = taskQuery.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        tasks = taskQuery.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        this.runtimeService.removeVariable(procInst.getId(), "variable");
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().taskName("After Condition").count());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)5L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingVariableConditionWithVariableNameAndEvents() {
        BpmnModelInstance modelInstance = this.specifier.getProcessWithVarNameAndEvents(false, "create, update");
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.removeVariable(task.getId(), "variable");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskName("After Condition").count());
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((long)3L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testVariableConditionWithVariableEvent() {
        BpmnModelInstance modelInstance = this.specifier.getProcessWithVarEvents(true, "update");
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        VariableMap variables = Variables.createVariables();
        variables.put("variable1", 0);
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess", (Map)variables);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.runtimeService.setVariable(procInst.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Before Condition", (Object)task.getName());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
        this.runtimeService.setVariable(procInst.getId(), "variable1", (Object)1);
        this.tasksAfterVariableIsSet = taskQuery.list();
        Assert.assertEquals((Object)"After Condition", (Object)((Task)this.tasksAfterVariableIsSet.get(0)).getName());
        Assert.assertEquals((long)0L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    @Test
    public void testNonInterruptingVariableConditionWithVariableEvent() {
        BpmnModelInstance modelInstance = this.specifier.getProcessWithVarEvents(false, "update");
        this.engine.manageDeployment(this.repositoryService.createDeployment().addModelInstance("conditionalModel.bpmn20.xml", modelInstance).deploy());
        ProcessInstance procInst = this.runtimeService.startProcessInstanceByKey("conditionalEventProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(procInst.getId());
        Task task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        this.taskService.setVariable(task.getId(), "variable", (Object)1);
        Assert.assertEquals((long)2L, (long)taskQuery.taskName("After Condition").count());
        this.tasksAfterVariableIsSet = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)3L, (long)this.tasksAfterVariableIsSet.size());
        Assert.assertEquals((long)1L, (long)this.conditionEventSubscriptionQuery.list().size());
    }

    private static interface ConditionalProcessVarSpecification {
        public BpmnModelInstance getProcessWithVarName(boolean var1, String var2);

        public BpmnModelInstance getProcessWithVarNameAndEvents(boolean var1, String var2);

        public BpmnModelInstance getProcessWithVarEvents(boolean var1, String var2);
    }
}

