/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.event.escalation;

import java.util.HashMap;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class EscalationEventTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testThrowEscalationEventFromEmbeddedSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testThrowEscalationEventHierarchical() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.nonInterruptingEscalationBoundaryEventOnCallActivity.bpmn20.xml"})
    @Test
    public void testThrowEscalationEventFromCallActivity() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after thrown escalation").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml"})
    @Test
    public void testThrowEscalationEventNotCaught() {
        this.runtimeService.startProcessInstanceByKey("throwEscalationProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after thrown escalation").count());
    }

    @Deployment
    @Test
    public void testBoundaryEventWithEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation 1").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testBoundaryEventWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testBoundaryEventWithEmptyEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testBoundaryEventWithoutEscalationRef() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testInterruptingEscalationBoundaryEventOnMultiInstanceSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment
    @Test
    public void testNonInterruptingEscalationBoundaryEventOnMultiInstanceSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)10L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Ignore(value="CAM-4403")
    @Test
    public void testImplicitNonInterruptingEscalationBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testInterruptingEscalationBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.interruptingEscalationBoundaryEventOnCallActivity.bpmn20.xml"})
    @Test
    public void testInterruptingEscalationBoundaryEventOnCallActivity() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment
    @Test
    public void testParallelEscalationEndEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    @Test
    public void testEscalationEndEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testPropagateOutputVariablesWhileCatchEscalationOnCallActivity.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileCatchEscalationOnCallActivity() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testPropagateOutputVariablesWhileCatchEscalationOnCallActivity.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesTwoTimes() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        Task taskInSuperProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)taskInSuperProcess);
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
        Task taskInSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "input", (Object)999);
        this.taskService.complete(taskInSubProcess.getId());
        Assert.assertEquals((Object)999, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testPropagateOutputVariablesWhileCatchInterruptingEscalationOnCallActivity.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileCatchInterruptingEscalationOnCallActivity() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testPropagateOutputVariablesWithoutCatchEscalation.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWithoutCatchEscalation() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment
    @Test
    public void testRetrieveEscalationCodeVariableOnBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment
    @Test
    public void testRetrieveEscalationCodeVariableOnBoundaryEventWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testInterruptingRetrieveEscalationCodeInSuperProcess.bpmn20.xml"})
    @Test
    public void testInterruptingRetrieveEscalationCodeInSuperProcess() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode.bpmn20.xml"})
    @Test
    public void testInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testNonInterruptingRetrieveEscalationCodeInSuperProcess.bpmn20.xml"})
    @Test
    public void testNonInterruptingRetrieveEscalationCodeInSuperProcess() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testNonInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode.bpmn20.xml"})
    @Test
    public void testNonInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalation.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileThrowEscalation() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalationTwoLevels.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileThrowEscalationTwoLevels() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalationThreeLevels.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileThrowEscalationThreeLevels() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalationInSubProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileThrowEscalationInSubProcess() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalationInSubProcessThreeLevels.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileThrowEscalationInSubProcessThreeLevels() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalation2.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    @Test
    public void testPropagateOutputVariablesWhileThrowEscalation2() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("inside subprocess").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    protected void checkOutput(String processInstanceId) {
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        Assert.assertNotNull((Object)this.runtimeService.getVariable(processInstanceId, "cancelReason"));
        Assert.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }
}

