/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.job;

import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.DefaultJobPriorityProvider;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class JobPrioritizationBpmnExpressionValueTest
extends PluggableProcessEngineTest {
    protected static final long EXPECTED_DEFAULT_PRIORITY = 123L;
    protected static final long EXPECTED_DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE = 296L;
    protected long originalDefaultPriority;
    protected long originalDefaultPriorityOnFailure;

    @Before
    public void setUp() throws Exception {
        this.originalDefaultPriority = DefaultJobPriorityProvider.DEFAULT_PRIORITY;
        this.originalDefaultPriorityOnFailure = DefaultJobPriorityProvider.DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE;
        DefaultJobPriorityProvider.DEFAULT_PRIORITY = 123L;
        DefaultJobPriorityProvider.DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE = 296L;
    }

    @After
    public void tearDown() throws Exception {
        DefaultJobPriorityProvider.DEFAULT_PRIORITY = this.originalDefaultPriority;
        DefaultJobPriorityProvider.DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE = this.originalDefaultPriorityOnFailure;
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testConstantValueExpressionPrioritization() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)15L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testConstantValueHashExpressionPrioritization() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task4")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)16L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testVariableValueExpressionPrioritization() {
        ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).setVariable("priority", (Object)22)).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)22L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Ignore(value="CAM-4207")
    @Test
    public void testVariableValueExpressionPrioritizationFailsWhenVariableMisses() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).execute();
            Assert.fail((String)"this should not succeed since the priority variable is not defined");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresentIgnoreCase("Unknown property used in expression: ${priority}. Cause: Cannot resolve identifier 'priority'", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testExecutionExpressionPrioritization() {
        ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).setVariable("priority", (Object)25)).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)25L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testExpressionEvaluatesToNull() {
        try {
            ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task3")).setVariable("priority", null)).execute();
            Assert.fail((String)"this should not succeed since the priority variable is not defined");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresentIgnoreCase("Priority value is not an Integer", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testExpressionEvaluatesToNonNumericalValue() {
        try {
            ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task3")).setVariable("priority", (Object)"aNonNumericalVariableValue")).execute();
            Assert.fail((String)"this should not succeed since the priority must be integer");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresentIgnoreCase("Priority value is not an Integer", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testExpressionEvaluatesToNonIntegerValue() {
        try {
            ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task3")).setVariable("priority", (Object)4.2)).execute();
            Assert.fail((String)"this should not succeed since the priority must be integer");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresentIgnoreCase("Priority value must be either Short, Integer, or Long", e.getMessage());
        }
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testConcurrentLocalVariablesAreAccessible() {
        ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task2")).startBeforeActivity("task1")).setVariableLocal("priority", (Object)14)).execute();
        Job job = (Job)this.managementService.createJobQuery().activityId("task1").singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)14L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testDefaultPriorityWhenBeanMisses() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)296L, (long)job.getPriority());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/job/jobPrioExpressionProcess.bpmn20.xml"})
    @Test
    public void testDisableGracefulDegradation() {
        try {
            this.processEngineConfiguration.setEnableGracefulDegradationOnContextSwitchFailure(false);
            try {
                ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("jobPrioExpressionProcess").startBeforeActivity("task1")).execute();
                Assert.fail((String)"should not succeed due to missing variable");
            }
            catch (ProcessEngineException e) {
                this.testRule.assertTextPresentIgnoreCase("unknown property used in expression", e.getMessage());
            }
        }
        finally {
            this.processEngineConfiguration.setEnableGracefulDegradationOnContextSwitchFailure(true);
        }
    }

    @Test
    public void testDefaultEngineConfigurationSetting() {
        StandaloneInMemProcessEngineConfiguration config = new StandaloneInMemProcessEngineConfiguration();
        Assert.assertTrue((boolean)config.isEnableGracefulDegradationOnContextSwitchFailure());
    }
}

