/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.subprocess;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ActivityInstanceImpl;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.task.TaskQuery;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.bpmn.subprocess.util.GetActInstanceDelegate;
import org.eximeebpms.bpm.engine.test.util.ActivityInstanceAssert;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class SubProcessTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testSimpleSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)subProcessTask.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)rootActivityInstance.getActivityId());
        Assert.assertEquals((long)1L, (long)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"subProcess", (Object)subProcessInstance.getActivityId());
        Assert.assertEquals((long)1L, (long)subProcessInstance.getChildActivityInstances().length);
        ActivityInstance userTaskInstance = subProcessInstance.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"subProcessTask", (Object)userTaskInstance.getActivityId());
        this.taskService.complete(subProcessTask.getId());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).singleResult());
    }

    @Deployment
    @Test
    public void testSimpleAutomaticSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcessAutomatic");
        Assert.assertTrue((boolean)pi.isEnded());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testSimpleSubProcessWithTimer() {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)subProcessTask.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)rootActivityInstance.getActivityId());
        Assert.assertEquals((long)1L, (long)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"subProcess", (Object)subProcessInstance.getActivityId());
        Assert.assertEquals((long)1L, (long)subProcessInstance.getChildActivityInstances().length);
        ActivityInstance userTaskInstance = subProcessInstance.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"subProcessTask", (Object)userTaskInstance.getActivityId());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 0x6DDD00L + 1000L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Task escalationTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Fix escalated problem", (Object)escalationTask.getName());
    }

    @Deployment
    public void IGNORE_testSimpleSubProcessWithConcurrentTimer() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcessWithConcurrentTimer");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        Task subProcessTask = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)subProcessTask.getName());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        List tasksAfterTimer = taskQuery.list();
        Assert.assertEquals((long)2L, (long)tasksAfterTimer.size());
        Task taskAfterTimer1 = (Task)tasksAfterTimer.get(0);
        Task taskAfterTimer2 = (Task)tasksAfterTimer.get(1);
        Assert.assertEquals((Object)"Task after timer 1", (Object)taskAfterTimer1.getName());
        Assert.assertEquals((Object)"Task after timer 2", (Object)taskAfterTimer2.getName());
        this.taskService.complete(taskAfterTimer1.getId());
        this.taskService.complete(taskAfterTimer2.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testNestedSimpleSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess", CollectionUtil.singletonMap((String)"someVar", (Object)"abc"));
        this.runtimeService.deleteProcessInstance(pi.getId(), "deleted");
        pi = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)subProcessTask.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)rootActivityInstance.getActivityId());
        Assert.assertEquals((long)1L, (long)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance1 = rootActivityInstance.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"outerSubProcess", (Object)subProcessInstance1.getActivityId());
        Assert.assertEquals((long)1L, (long)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance2 = subProcessInstance1.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"innerSubProcess", (Object)subProcessInstance2.getActivityId());
        Assert.assertEquals((long)1L, (long)subProcessInstance2.getChildActivityInstances().length);
        ActivityInstance userTaskInstance = subProcessInstance2.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"innerSubProcessTask", (Object)userTaskInstance.getActivityId());
        this.taskService.complete(subProcessTask.getId());
        Task taskAfterSubProcesses = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)taskAfterSubProcesses);
        Assert.assertEquals((Object)"Task after subprocesses", (Object)taskAfterSubProcesses.getName());
        this.taskService.complete(taskAfterSubProcesses.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testNestedSimpleSubprocessWithTimerOnInnerSubProcess() {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nestedSubProcessWithTimer");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)subProcessTask.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)rootActivityInstance.getActivityId());
        Assert.assertEquals((long)1L, (long)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance1 = rootActivityInstance.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"outerSubProcess", (Object)subProcessInstance1.getActivityId());
        Assert.assertEquals((long)1L, (long)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance2 = subProcessInstance1.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"innerSubProcess", (Object)subProcessInstance2.getActivityId());
        Assert.assertEquals((long)1L, (long)subProcessInstance2.getChildActivityInstances().length);
        ActivityInstance userTaskInstance = subProcessInstance2.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"innerSubProcessTask", (Object)userTaskInstance.getActivityId());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3600000L + 1000L));
        this.testRule.waitForJobExecutorToProcessAllJobs(5000L);
        Task escalationTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Escalated task", (Object)escalationTask.getName());
        rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)rootActivityInstance.getActivityId());
        Assert.assertEquals((long)1L, (long)rootActivityInstance.getChildActivityInstances().length);
        subProcessInstance1 = rootActivityInstance.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"outerSubProcess", (Object)subProcessInstance1.getActivityId());
        Assert.assertEquals((long)1L, (long)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance escalationTaskInst = subProcessInstance1.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"escalationTask", (Object)escalationTaskInst.getActivityId());
        this.taskService.complete(escalationTask.getId());
        Task taskAfterSubProcess = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Task after subprocesses", (Object)taskAfterSubProcess.getName());
    }

    @Deployment
    @Test
    public void testDoubleNestedSimpleSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess");
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Task in subprocess", (Object)subProcessTask.getName());
        this.taskService.complete(subProcessTask.getId());
        Task taskAfterSubProcesses = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Task after subprocesses", (Object)taskAfterSubProcesses.getName());
    }

    @Deployment
    @Test
    public void testSimpleParallelSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleParallelSubProcess");
        List subProcessTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc()).list();
        Task taskA = (Task)subProcessTasks.get(0);
        Task taskB = (Task)subProcessTasks.get(1);
        Assert.assertEquals((Object)"Task A", (Object)taskA.getName());
        Assert.assertEquals((Object)"Task B", (Object)taskB.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)rootActivityInstance.getActivityId());
        Assert.assertEquals((long)1L, (long)rootActivityInstance.getChildActivityInstances().length);
        ActivityInstance subProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        Assert.assertEquals((Object)"subProcess", (Object)subProcessInstance.getActivityId());
        Assert.assertEquals((long)2L, (long)subProcessInstance.getChildActivityInstances().length);
        this.taskService.complete(taskA.getId());
        rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)rootActivityInstance.getActivityId());
        subProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        Assert.assertEquals((long)2L, (long)subProcessInstance.getChildActivityInstances().length);
        this.taskService.complete(taskB.getId());
        Task taskAfterSubProcess = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Task after sub process", (Object)taskAfterSubProcess.getName());
    }

    @Deployment
    @Test
    public void testSimpleParallelSubProcessWithTimer() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("simpleParallelSubProcessWithTimer");
        List subProcessTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).orderByTaskName().asc()).list();
        Task taskA = (Task)subProcessTasks.get(0);
        Task taskB = (Task)subProcessTasks.get(1);
        Assert.assertEquals((Object)"Task A", (Object)taskA.getName());
        Assert.assertEquals((Object)"Task B", (Object)taskB.getName());
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        this.managementService.executeJob(job.getId());
        Task taskAfterTimer = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((Object)"Task after timer", (Object)taskAfterTimer.getName());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testTwoSubProcessInParallel() {
        ActivityInstance[] childActivityInstances;
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("twoSubProcessInParallel");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = taskQuery.list();
        Assert.assertEquals((Object)"Task in subprocess A", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"Task in subprocess B", (Object)((Task)tasks.get(1)).getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        Assert.assertEquals((Object)pi.getProcessDefinitionId(), (Object)rootActivityInstance.getActivityId());
        Assert.assertEquals((long)2L, (long)rootActivityInstance.getChildActivityInstances().length);
        for (ActivityInstance activityInstance : childActivityInstances = rootActivityInstance.getChildActivityInstances()) {
            Assert.assertTrue((boolean)Arrays.asList("subProcessA", "subProcessB").contains(activityInstance.getActivityId()));
            ActivityInstance[] subProcessChildren = activityInstance.getChildActivityInstances();
            Assert.assertEquals((long)1L, (long)subProcessChildren.length);
            Assert.assertTrue((boolean)Arrays.asList("subProcessATask", "subProcessBTask").contains(subProcessChildren[0].getActivityId()));
        }
        this.taskService.complete(((Task)tasks.get(0)).getId());
        tasks = taskQuery.list();
        Assert.assertEquals((Object)"Task after subprocess A", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"Task in subprocess B", (Object)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = taskQuery.list();
        Assert.assertEquals((Object)"Task after subprocess A", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"Task after subprocess B", (Object)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testTwoSubProcessInParallelWithinSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("twoSubProcessInParallelWithinSubProcess");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = taskQuery.list();
        Task taskA = (Task)tasks.get(0);
        Task taskB = (Task)tasks.get(1);
        Assert.assertEquals((Object)"Task in subprocess A", (Object)taskA.getName());
        Assert.assertEquals((Object)"Task in subprocess B", (Object)taskB.getName());
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(rootActivityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(pi.getProcessDefinitionId()).beginScope("outerSubProcess").beginScope("subProcessA").activity("subProcessATask").endScope().beginScope("subProcessB").activity("subProcessBTask").done());
        this.taskService.complete(taskA.getId());
        this.taskService.complete(taskB.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"Task after subprocess", (Object)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testTwoNestedSubProcessesInParallelWithTimer() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nestedParallelSubProcessesWithTimer");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = taskQuery.list();
        Task taskA = (Task)tasks.get(0);
        Task taskB = (Task)tasks.get(1);
        Assert.assertEquals((Object)"Task in subprocess A", (Object)taskA.getName());
        Assert.assertEquals((Object)"Task in subprocess B", (Object)taskB.getName());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Task taskAfterTimer = (Task)taskQuery.singleResult();
        Assert.assertEquals((Object)"Task after timer", (Object)taskAfterTimer.getName());
        this.taskService.complete(taskAfterTimer.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testNestedSimpleSubProcessWithoutEndEvent() {
        this.testNestedSimpleSubProcess();
    }

    @Deployment
    @Test
    public void testSimpleSubProcessWithoutEndEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testSimpleSubProcessWithoutEndEvent");
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testNestedSubProcessesWithoutEndEvents() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testNestedSubProcessesWithoutEndEvents");
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/eximeebpms/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    @Test
    public void testInstanceSubProcessInstanceIdSet() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess");
        ActivityInstance rootActivityInstance = this.runtimeService.getActivityInstance(pi.getProcessInstanceId());
        ActivityInstance subProcessInstance = rootActivityInstance.getChildActivityInstances()[0];
        String subProcessInstanceId = ((ActivityInstanceImpl)subProcessInstance).getSubProcessInstanceId();
        Assert.assertNotNull((Object)subProcessInstanceId);
        ProcessInstance subProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("simpleSubProcess").singleResult();
        Assert.assertEquals((Object)subProcess.getId(), (Object)subProcessInstanceId);
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeNestedCmd() {
        GetActInstanceDelegate.activityInstance = null;
        this.runtimeService.startProcessInstanceByKey("process");
        ActivityInstance activityInstance = GetActInstanceDelegate.activityInstance;
        Assert.assertNotNull((Object)activityInstance);
        ActivityInstance subProcessInstance = activityInstance.getChildActivityInstances()[0];
        Assert.assertNotNull((Object)subProcessInstance);
        Assert.assertEquals((Object)"SubProcess_1", (Object)subProcessInstance.getActivityId());
        ActivityInstance serviceTaskInstance = subProcessInstance.getChildActivityInstances()[0];
        Assert.assertNotNull((Object)serviceTaskInstance);
        Assert.assertEquals((Object)"ServiceTask_1", (Object)serviceTaskInstance.getActivityId());
    }

    @Deployment
    @Test
    public void testActivityInstanceTreeNestedCmdAfterTx() {
        GetActInstanceDelegate.activityInstance = null;
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("message");
        ActivityInstance activityInstance = GetActInstanceDelegate.activityInstance;
        Assert.assertNotNull((Object)activityInstance);
        ActivityInstance subProcessInstance = activityInstance.getChildActivityInstances()[0];
        Assert.assertNotNull((Object)subProcessInstance);
        Assert.assertEquals((Object)"SubProcess_1", (Object)subProcessInstance.getActivityId());
        ActivityInstance serviceTaskInstance = subProcessInstance.getChildActivityInstances()[0];
        Assert.assertNotNull((Object)serviceTaskInstance);
        Assert.assertEquals((Object)"ServiceTask_1", (Object)serviceTaskInstance.getActivityId());
    }

    @Test
    public void testConcurrencyInSubProcess() {
        org.eximeebpms.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/eximeebpms/bpm/engine/test/bpmn/subprocess/SubProcessTest.fixSystemFailureProcess.bpmn20.xml").deploy();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("fixSystemFailure");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Task investigateHardwareTask = (Task)tasks.get(0);
        Task investigateSoftwareTask = (Task)tasks.get(1);
        Assert.assertEquals((Object)"Investigate hardware", (Object)investigateHardwareTask.getName());
        Assert.assertEquals((Object)"Investigate software", (Object)investigateSoftwareTask.getName());
        this.taskService.complete(investigateHardwareTask.getId());
        this.taskService.complete(investigateSoftwareTask.getId());
        Task writeReportTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Write report", (Object)writeReportTask.getName());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }
}

