/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.tasklistener.builtin;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.commons.testing.ProcessEngineLoggingRule;
import org.eximeebpms.commons.testing.WatchLogger;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class BuiltinTaskListenerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/eximeebpms/bpm/engine/test/bpmn/tasklistener/builtin/task.listener.eximeebpms.cfg.xml");
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    @Deployment
    @WatchLogger(loggerNames={"org.eximeebpms.bpm.engine.test"}, level="INFO")
    public void shouldExecuteBuiltinTaskListerInOrderAfterModification() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute(true, true);
        List logEntries = this.loggingRule.getLog();
        Assertions.assertThat((List)logEntries).hasSize(5);
        Assertions.assertThat((List)logEntries).extracting("formattedMessage").containsExactly(new Object[]{"Executed task listener: PreParseListener", "Executed task listener: PostParseListener", "Executed task listener: TestTaskListener", "Executed task listener: PreParseListener", "Executed task listener: PostParseListener"});
    }
}

