/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.bpmn.usertask;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.identity.Group;
import org.eximeebpms.bpm.engine.identity.User;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskCandidateTest
extends PluggableProcessEngineTest {
    private static final String MANAGEMENT = "management";
    private static final String KERMIT = "kermit";
    private static final String GONZO = "gonzo";

    @Before
    public void setUp() throws Exception {
        Group accountants = this.identityService.newGroup("accountancy");
        this.identityService.saveGroup(accountants);
        Group managers = this.identityService.newGroup(MANAGEMENT);
        this.identityService.saveGroup(managers);
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        User kermit = this.identityService.newUser(KERMIT);
        this.identityService.saveUser(kermit);
        this.identityService.createMembership(KERMIT, "accountancy");
        User gonzo = this.identityService.newUser(GONZO);
        this.identityService.saveUser(gonzo);
        this.identityService.createMembership(GONZO, MANAGEMENT);
        this.identityService.createMembership(GONZO, "accountancy");
        this.identityService.createMembership(GONZO, "sales");
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteUser(KERMIT);
        this.identityService.deleteUser(GONZO);
        this.identityService.deleteGroup("sales");
        this.identityService.deleteGroup("accountancy");
        this.identityService.deleteGroup(MANAGEMENT);
    }

    @Deployment
    @Test
    public void testSingleCandidateGroup() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("singleCandidateGroup");
        List tasks = this.taskService.createTaskQuery().taskAssignee(KERMIT).list();
        Assert.assertTrue((boolean)tasks.isEmpty());
        tasks = this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task task = (Task)tasks.get(0);
        Assert.assertEquals((Object)"Pay out expenses", (Object)task.getName());
        tasks = this.taskService.createTaskQuery().or().taskCandidateUser(KERMIT).endOr().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        task = (Task)tasks.get(0);
        Assert.assertEquals((Object)"Pay out expenses", (Object)task.getName());
        this.taskService.claim(task.getId(), KERMIT);
        tasks = this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list();
        Assert.assertTrue((boolean)tasks.isEmpty());
        tasks = this.taskService.createTaskQuery().taskAssignee(KERMIT).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        task = (Task)tasks.get(0);
        Assert.assertEquals((Object)"Pay out expenses", (Object)task.getName());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testMultipleCandidateGroups() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("multipleCandidatesGroup");
        List tasks = this.taskService.createTaskQuery().taskAssignee(KERMIT).list();
        Assert.assertTrue((boolean)tasks.isEmpty());
        tasks = this.taskService.createTaskQuery().taskAssignee(GONZO).list();
        Assert.assertTrue((boolean)tasks.isEmpty());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list().size());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser(GONZO).list().size());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateGroup(MANAGEMENT).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateGroup("accountancy").count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCandidateGroup("sales").count());
        tasks = this.taskService.createTaskQuery().taskCandidateUser(GONZO).list();
        Task task = (Task)tasks.get(0);
        Assert.assertEquals((Object)"Approve expenses", (Object)task.getName());
        this.taskService.claim(task.getId(), GONZO);
        Assert.assertTrue((boolean)this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list().isEmpty());
        Assert.assertTrue((boolean)this.taskService.createTaskQuery().taskCandidateUser(GONZO).list().isEmpty());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskCandidateGroup(MANAGEMENT).count());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskAssignee(GONZO).count());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().taskAssignee(KERMIT).count());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testMultipleCandidateUsers() {
        this.runtimeService.startProcessInstanceByKey("multipleCandidateUsersExample");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser(GONZO).list().size());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list().size());
    }

    @Deployment
    @Test
    public void testMixedCandidateUserAndGroup() {
        this.runtimeService.startProcessInstanceByKey("mixedCandidateUserAndGroupExample");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser(GONZO).list().size());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskCandidateUser(KERMIT).list().size());
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/usertask/groupTest.bpmn"})
    @Test
    public void testInvolvedUserQuery() {
        this.identityService.createMembership(KERMIT, MANAGEMENT);
        this.runtimeService.startProcessInstanceByKey("Process_13pqtqg");
        List tasks = this.taskService.createTaskQuery().taskInvolvedUser(KERMIT).list();
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testInvolvedUserQueryForAssignee() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setAssignee(task.getId(), KERMIT);
        List tasks = this.taskService.createTaskQuery().taskInvolvedUser(KERMIT).list();
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testInvolvedUserQueryForOwner() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setOwner(task.getId(), KERMIT);
        List tasks = this.taskService.createTaskQuery().taskInvolvedUser(KERMIT).list();
        Assertions.assertThat((List)tasks).hasSize(1);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/bpmn/usertask/groupTest.bpmn"})
    @Test
    public void testInvolvedUserQueryOr() {
        this.identityService.createMembership(KERMIT, MANAGEMENT);
        this.runtimeService.startProcessInstanceByKey("Process_13pqtqg");
        List tasks = this.taskService.createTaskQuery().or().taskCandidateGroup(MANAGEMENT).taskInvolvedUser(KERMIT).endOr().list();
        Assertions.assertThat((List)tasks).hasSize(2);
    }
}

