/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.concurrency;

import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandInterceptor;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.runtime.Job;
import org.eximeebpms.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.eximeebpms.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.eximeebpms.bpm.engine.test.util.ProcessEngineTestRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CompetingHistoryCleanupAcquisitionTest
extends ConcurrencyTestHelper {
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(this::configureEngine);
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected final Date CURRENT_DATE = new GregorianCalendar(2023, 2, 18, 12, 0, 0).getTime();
    protected static ConcurrencyTestHelper.ThreadControl cleanupThread = null;
    protected static ThreadLocal<Boolean> syncBeforeFlush = new ThreadLocal();
    protected ControllableJobExecutor jobExecutor;
    protected ConcurrencyTestHelper.ThreadControl acquisitionThread;

    @Before
    public void setUp() throws Exception {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.acquisitionThread = this.jobExecutor.getAcquisitionThreadControl();
        this.acquisitionThread.reportInterrupts();
        ClockUtil.setCurrentTime((Date)this.CURRENT_DATE);
    }

    @After
    public void tearDown() throws Exception {
        if (this.jobExecutor.isActive()) {
            this.jobExecutor.shutdown();
        }
        this.jobExecutor.resetOleThrown();
        this.clearDatabase();
        ClockUtil.reset();
    }

    public void configureEngine(ProcessEngineConfigurationImpl configuration) {
        this.jobExecutor = new ControllableJobExecutor();
        this.jobExecutor.setMaxJobsPerAcquisition(1);
        configuration.setJobExecutor((JobExecutor)this.jobExecutor);
        configuration.setHistoryCleanupBatchWindowStartTime("12:00");
        configuration.setCustomPostCommandInterceptorsTxRequiresNew(Collections.singletonList(new CommandInterceptor(){

            public <T> T execute(Command<T> command) {
                Object executed = this.next.execute(command);
                if (syncBeforeFlush.get() != null && syncBeforeFlush.get().booleanValue()) {
                    cleanupThread.sync();
                }
                return (T)executed;
            }
        }));
    }

    @Test
    public void testAcquiringEverLivingJobSucceeds() {
        this.jobExecutor.indicateOptimisticLockingException();
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.lockEverLivingJob(jobId);
        cleanupThread = this.executeControllableCommand(new CleanupThread(jobId));
        cleanupThread.waitForSync();
        cleanupThread.makeContinueAndWaitForSync();
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        cleanupThread.makeContinue();
        cleanupThread.join();
        this.acquisitionThread.makeContinueAndWaitForSync();
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)DateUtils.addSeconds((Date)this.CURRENT_DATE, (int)10));
        Assertions.assertThat((boolean)this.jobExecutor.isOleThrown()).isFalse();
    }

    @Test
    public void testReschedulingEverLivingJobSucceeds() {
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.lockEverLivingJob(jobId);
        cleanupThread = this.executeControllableCommand(new CleanupThread(jobId));
        cleanupThread.waitForSync();
        cleanupThread.makeContinueAndWaitForSync();
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        cleanupThread.makeContinue();
        cleanupThread.join();
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        Assertions.assertThat((Date)job.getDuedate()).isEqualTo((Object)DateUtils.addSeconds((Date)this.CURRENT_DATE, (int)10));
    }

    protected void clearDatabase() {
        this.testRule.deleteHistoryCleanupJobs();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            commandContext.getMeterLogManager().deleteAll();
            commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("history-cleanup");
            return null;
        });
    }

    protected void lockEverLivingJob(String jobId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            JobEntity job = commandContext.getJobManager().findJobById(jobId);
            job.setLockOwner("foo");
            job.setLockExpirationTime(DateUtils.addDays((Date)this.CURRENT_DATE, (int)10));
            return null;
        });
    }

    public class CleanupThread
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String jobId;

        protected CleanupThread(String jobId) {
            this.jobId = jobId;
        }

        public Void execute(CommandContext commandContext) {
            syncBeforeFlush.set(true);
            CompetingHistoryCleanupAcquisitionTest.this.managementService.executeJob(this.jobId);
            return null;
        }
    }
}

