/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.dmn.el;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eximeebpms.bpm.dmn.engine.DmnDecisionTableResult;
import org.eximeebpms.bpm.engine.DecisionService;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.ProcessEngineRule;
import org.eximeebpms.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.Variables;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DmnExpressionLanguageTest {
    private static final String JUEL_EXPRESSIONS_WITH_PROPERTIES_DMN = "org/eximeebpms/bpm/engine/test/dmn/el/DmnExpressionLanguageTest.dmn";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    private DecisionService decisionService;

    @Before
    public void setUp() {
        this.decisionService = this.engineRule.getDecisionService();
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/el/DmnExpressionLanguageTest.dmn"})
    public void testJuelDoesNotShadowInnerProperty() {
        VariableMap inputs = Variables.createVariables();
        inputs.putValue("testExpr", (Object)"TestProperty");
        HashMap<String, String> mapVar = new HashMap<String, String>(1);
        mapVar.put("b", "B_FROM_MAP");
        inputs.putValue("a", mapVar);
        inputs.putValue("b", (Object)"B_FROM_CONTEXT");
        DmnDecisionTableResult result = this.decisionService.evaluateDecisionTableByKey("decision_1", (Map)inputs);
        Assertions.assertThat((String)((String)result.getSingleEntry())).isEqualTo((Object)"B_FROM_MAP");
    }

    @Test
    @Deployment(resources={"org/eximeebpms/bpm/engine/test/dmn/el/DmnExpressionLanguageTest.dmn"})
    public void testJuelResolvesListIndex() {
        VariableMap inputs = Variables.createVariables();
        inputs.putValue("testExpr", (Object)"TestListIndex");
        ArrayList<String> listVar = new ArrayList<String>(1);
        listVar.add("0_FROM_LIST");
        inputs.putValue("a", listVar);
        DmnDecisionTableResult result = this.decisionService.evaluateDecisionTableByKey("decision_1", (Map)inputs);
        Assertions.assertThat((String)((String)result.getSingleEntry())).isEqualTo((Object)"0_FROM_LIST");
    }
}

