/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricIdentityLinkLog;
import org.eximeebpms.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.Deployment;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricIdentityLinkLogTest
extends PluggableProcessEngineTest {
    private static final String A_USER_ID = "aUserId";
    private static final String B_USER_ID = "bUserId";
    private static final String C_USER_ID = "cUserId";
    private static final int numberOfUsers = 3;
    private static final String A_GROUP_ID = "aGroupId";
    private static final String INVALID_USER_ID = "InvalidUserId";
    private static final String A_ASSIGNER_ID = "aAssignerId";
    private static String PROCESS_DEFINITION_KEY = "oneTaskProcess";
    private static final String GROUP_1 = "Group1";
    private static final String USER_1 = "User1";
    private static final String OWNER_1 = "Owner1";
    private static final String IDENTITY_LINK_ADD = "add";
    private static final String IDENTITY_LINK_DELETE = "delete";

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddDelegateTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addUserIdentityLink(taskId, A_USER_ID, "assignee");
        this.taskService.delegateTask(taskId, B_USER_ID);
        this.taskService.deleteUserIdentityLink(taskId, B_USER_ID, "assignee");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)5L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(A_USER_ID).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(B_USER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("assignee").count(), (long)4L);
        Assert.assertEquals((long)query.type("owner").count(), (long)1L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddClaimTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.claim(taskId, A_USER_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(A_USER_ID).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)0L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("assignee").count(), (long)1L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddMultipleDelegateTaskCandidateforAddIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addUserIdentityLink(taskId, A_USER_ID, "assignee");
        this.taskService.delegateTask(taskId, B_USER_ID);
        this.taskService.delegateTask(taskId, C_USER_ID);
        this.taskService.deleteUserIdentityLink(taskId, C_USER_ID, "assignee");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)7L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(A_USER_ID).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(B_USER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.userId(C_USER_ID).count(), (long)2L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_ADD).count(), (long)4L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.operationType(IDENTITY_LINK_DELETE).count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("assignee").count(), (long)6L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("owner").count(), (long)1L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddTaskCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateUser(taskId, A_USER_ID);
        this.taskService.deleteCandidateUser(taskId, A_USER_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)2L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddGroupCandidateForAddAndDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addCandidateGroup(taskId, A_GROUP_ID);
        this.taskService.deleteCandidateGroup(taskId, A_GROUP_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)2L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.groupId(A_GROUP_ID).count(), (long)2L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldNotAddTaskCandidateForInvalidIdentityLinkDelete() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.deleteCandidateUser(taskId, INVALID_USER_ID);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddTaskAssigneeForAddandDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.addAndDeleteUserWithAssigner(taskId, "assignee");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)2L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("assignee").count(), (long)2L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddAndRemoveIdentityLinksForProcessDefinition() throws Exception {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        Assert.assertNotNull((Object)latestProcessDef);
        List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
        Assert.assertEquals((long)0L, (long)links.size());
        this.repositoryService.addCandidateStarterGroup(latestProcessDef.getId(), GROUP_1);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)1L);
        this.repositoryService.addCandidateStarterUser(latestProcessDef.getId(), USER_1);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)2L);
        this.repositoryService.deleteCandidateStarterGroup(latestProcessDef.getId(), GROUP_1);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)3L);
        this.repositoryService.deleteCandidateStarterUser(latestProcessDef.getId(), USER_1);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)4L);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddTaskOwnerForAddandDeleteIdentityLink() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.addAndDeleteUserWithAssigner(taskId, "owner");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)2L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("owner").count(), (long)2L);
    }

    @Test
    public void testShouldAddIdentityLinkForTaskCreationWithAssigneeAndOwner() {
        String taskAssigneeId = "Assigneee";
        String taskOwnerId = "Owner";
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        Task taskAssignee = this.taskService.newTask(taskAssigneeId);
        taskAssignee.setAssignee(USER_1);
        this.taskService.saveTask(taskAssignee);
        Task taskOwner = this.taskService.newTask(taskOwnerId);
        taskOwner.setOwner(OWNER_1);
        this.taskService.saveTask(taskOwner);
        Task taskEmpty = this.taskService.newTask();
        this.taskService.saveTask(taskEmpty);
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)2L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("assignee").count(), (long)1L);
        Assert.assertEquals((long)query.userId(USER_1).count(), (long)1L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("owner").count(), (long)1L);
        Assert.assertEquals((long)query.userId(OWNER_1).count(), (long)1L);
        this.taskService.deleteTask(taskAssigneeId, true);
        this.taskService.deleteTask(taskOwnerId, true);
        this.taskService.deleteTask(taskEmpty.getId(), true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldAddIdentityLinkByProcessDefinitionAndStandalone() {
        String taskAssigneeId = "Assigneee";
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        ProcessInstance processInstance = this.startProcessInstance(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        Task taskAssignee = this.taskService.newTask(taskAssigneeId);
        taskAssignee.setAssignee(USER_1);
        this.taskService.saveTask(taskAssignee);
        this.addAndDeleteUserWithAssigner(taskId, "assignee");
        historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)3L);
        HistoricIdentityLinkLogQuery query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.type("assignee").count(), (long)3L);
        query = this.historyService.createHistoricIdentityLinkLogQuery();
        Assert.assertEquals((long)query.processDefinitionId(processInstance.getProcessDefinitionId()).count(), (long)2L);
        Assert.assertEquals((long)query.processDefinitionKey(PROCESS_DEFINITION_KEY).count(), (long)2L);
        this.taskService.deleteTask(taskAssigneeId, true);
    }

    @Deployment(resources={"org/eximeebpms/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testShouldNotDeleteIdentityLinkForTaskCompletion() {
        List historicIdentityLinks = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)historicIdentityLinks.size(), (long)0L);
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.addCandidateUser(task.getId(), "demo");
        this.taskService.complete(task.getId());
        List historicIdentityLinkLogs = this.historyService.createHistoricIdentityLinkLogQuery().list();
        Assert.assertEquals((long)1L, (long)historicIdentityLinkLogs.size());
        Assert.assertNotEquals((Object)IDENTITY_LINK_DELETE, (Object)((HistoricIdentityLinkLog)historicIdentityLinkLogs.get(0)).getOperationType());
    }

    public void addAndDeleteUserWithAssigner(String taskId, String identityLinkType) {
        this.identityService.setAuthenticatedUserId(A_ASSIGNER_ID);
        this.taskService.addUserIdentityLink(taskId, A_USER_ID, identityLinkType);
        this.taskService.deleteUserIdentityLink(taskId, A_USER_ID, identityLinkType);
    }

    public void addUserIdentityLinks(String taskId) {
        for (int userIndex = 1; userIndex <= 3; ++userIndex) {
            this.taskService.addUserIdentityLink(taskId, A_USER_ID + userIndex, "owner");
        }
    }

    public void deleteUserIdentityLinks(String taskId) {
        for (int userIndex = 1; userIndex <= 3; ++userIndex) {
            this.taskService.deleteUserIdentityLink(taskId, A_USER_ID + userIndex, "owner");
        }
    }

    protected ProcessInstance startProcessInstance(String key) {
        return this.runtimeService.startProcessInstanceByKey(key);
    }
}

