/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test.history;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.history.DurationReportResult;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstanceReport;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.query.PeriodUnit;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.runtime.ProcessInstance;
import org.eximeebpms.bpm.engine.task.Task;
import org.eximeebpms.bpm.engine.test.RequiredHistoryLevel;
import org.eximeebpms.bpm.engine.test.util.PluggableProcessEngineTest;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="activity")
public class HistoricProcessInstanceDurationReportTest
extends PluggableProcessEngineTest {
    private Random random = new Random();

    @Test
    public void testDurationReportByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process", 2016, 0, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 0, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 0, 1, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testTwoInstancesInSamePeriodByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process", 2016, 0, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 0, 15, 10, 0).startAndCompleteProcessInstance("process", 2016, 0, 15, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testDurationReportInDifferentPeriodsByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process", 2015, 10, 1, 10, 0).startAndCompleteProcessInstance("process", 2015, 11, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 0, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 1, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 2, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 3, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 4, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 5, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 6, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 7, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 8, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 9, 1, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testSamePeriodDifferentYearByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process", 2015, 1, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 1, 1, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testDurationReportByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process", 2016, 3, 1, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testTwoInstancesInSamePeriodDurationReportByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process", 2016, 3, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 5, 1, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testDurationReportInDifferentPeriodsByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process", 2015, 10, 1, 10, 0).startAndCompleteProcessInstance("process", 2015, 11, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 1, 1, 10, 0).startAndCompleteProcessInstance("process", 2015, 2, 1, 10, 0).startAndCompleteProcessInstance("process", 2015, 3, 1, 10, 0).startAndCompleteProcessInstance("process", 2015, 5, 1, 10, 0).startAndCompleteProcessInstance("process", 2015, 6, 1, 10, 0).startAndCompleteProcessInstance("process", 2015, 7, 1, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testSamePeriodDifferentYearByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process", 2015, 1, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 1, 1, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByInvalidPeriodUnit() {
        HistoricProcessInstanceReport report = this.historyService.createHistoricProcessInstanceReport();
        try {
            report.duration(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportByStartedBeforeByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process", 2016, 0, 15, 10, 0).done();
        this.createReportScenario().startAndCompleteProcessInstance("process", 2016, 3, 1, 10, 0).done();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 0, 16, 0, 0, 0);
        List result = this.historyService.createHistoricProcessInstanceReport().startedBefore(calendar.getTime()).duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByStartedBeforeByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process", 2016, 0, 15, 10, 0).startAndCompleteProcessInstance("process", 2016, 0, 15, 10, 0).startAndCompleteProcessInstance("process", 2016, 0, 15, 10, 0).done();
        this.createReportScenario().startAndCompleteProcessInstance("process", 2016, 3, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 3, 1, 10, 0).startAndCompleteProcessInstance("process", 2016, 3, 1, 10, 0).done();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 0, 16, 0, 0, 0);
        List result = this.historyService.createHistoricProcessInstanceReport().startedBefore(calendar.getTime()).duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByInvalidStartedBefore() {
        HistoricProcessInstanceReport report = this.historyService.createHistoricProcessInstanceReport();
        try {
            report.startedBefore(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportByStartedAfterByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        this.createReportScenario().startAndCompleteProcessInstance("process", 2015, 11, 15, 10, 0).done();
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process", 2016, 3, 1, 10, 0).done();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 0, 1, 0, 0, 0);
        List result = this.historyService.createHistoricProcessInstanceReport().startedAfter(calendar.getTime()).duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByStartedAfterByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        this.createReportScenario().startAndCompleteProcessInstance("process", 2015, 11, 15, 10, 0).done();
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process", 2016, 3, 1, 10, 0).done();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 0, 1, 0, 0, 0);
        List result = this.historyService.createHistoricProcessInstanceReport().startedAfter(calendar.getTime()).duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByInvalidStartedAfter() {
        HistoricProcessInstanceReport report = this.historyService.createHistoricProcessInstanceReport();
        try {
            report.startedAfter(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportByStartedAfterAndStartedBeforeByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process", 2016, 1, 15, 10, 0).startAndCompleteProcessInstance("process", 2016, 2, 1, 10, 0).done();
        this.createReportScenario().startAndCompleteProcessInstance("process", 2016, 3, 15, 10, 0).done();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 0, 1, 0, 0, 0);
        Date after = calendar.getTime();
        calendar.set(2016, 2, 31, 23, 59, 59);
        Date before = calendar.getTime();
        List result = this.historyService.createHistoricProcessInstanceReport().startedAfter(after).startedBefore(before).duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByStartedAfterAndStartedBeforeByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process", 2016, 1, 15, 10, 0).startAndCompleteProcessInstance("process", 2016, 2, 1, 10, 0).done();
        this.createReportScenario().startAndCompleteProcessInstance("process", 2016, 3, 15, 10, 0).done();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2016, 0, 1, 0, 0, 0);
        Date after = calendar.getTime();
        calendar.set(2016, 2, 31, 23, 59, 59);
        Date before = calendar.getTime();
        List result = this.historyService.createHistoricProcessInstanceReport().startedAfter(after).startedBefore(before).duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportWithExcludingConditions() {
        this.testRule.deploy(this.createProcessWithUserTask("process"));
        this.runtimeService.startProcessInstanceByKey("process");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        List result = this.historyService.createHistoricProcessInstanceReport().startedAfter(hourFromNow.getTime()).startedBefore(hourAgo.getTime()).duration(PeriodUnit.MONTH);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testReportByProcessDefinitionIdByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process1"), this.createProcessWithUserTask("process2"));
        String processDefinitionId1 = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult()).getId();
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process1", 2016, 1, 15, 10, 0).done();
        this.createReportScenario().startAndCompleteProcessInstance("process2", 2016, 3, 15, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{processDefinitionId1}).duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByProcessDefinitionIdByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process1"), this.createProcessWithUserTask("process2"));
        String processDefinitionId1 = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult()).getId();
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process1", 2016, 1, 15, 10, 0).done();
        this.createReportScenario().startAndCompleteProcessInstance("process2", 2016, 3, 15, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{processDefinitionId1}).duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByMultipleProcessDefinitionIdByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process1"), this.createProcessWithUserTask("process2"));
        String processDefinitionId1 = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult()).getId();
        String processDefinitionId2 = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").singleResult()).getId();
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process1", 2016, 1, 15, 10, 0).startAndCompleteProcessInstance("process2", 2016, 3, 15, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{processDefinitionId1, processDefinitionId2}).duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByMultipleProcessDefinitionIdByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process1"), this.createProcessWithUserTask("process2"));
        String processDefinitionId1 = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult()).getId();
        String processDefinitionId2 = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").singleResult()).getId();
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process1", 2016, 1, 15, 10, 0).startAndCompleteProcessInstance("process2", 2016, 3, 15, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionIdIn(new String[]{processDefinitionId1, processDefinitionId2}).duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByInvalidProcessDefinitionId() {
        HistoricProcessInstanceReport report = this.historyService.createHistoricProcessInstanceReport();
        try {
            report.processDefinitionIdIn(new String[]{null});
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            report.processDefinitionIdIn(new String[]{"abc", null, "def"});
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportByProcessDefinitionKeyByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process1"), this.createProcessWithUserTask("process2"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process1", 2016, 1, 15, 10, 0).done();
        this.createReportScenario().startAndCompleteProcessInstance("process2", 2016, 3, 15, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{"process1"}).duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByProcessDefinitionKeyByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process1"), this.createProcessWithUserTask("process2"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process1", 2016, 1, 15, 10, 0).done();
        this.createReportScenario().startAndCompleteProcessInstance("process2", 2016, 3, 15, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{"process1"}).duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByMultipleProcessDefinitionKeyByMonth() {
        this.testRule.deploy(this.createProcessWithUserTask("process1"), this.createProcessWithUserTask("process2"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.MONTH).startAndCompleteProcessInstance("process1", 2016, 1, 15, 10, 0).startAndCompleteProcessInstance("process2", 2016, 3, 15, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{"process1", "process2"}).duration(PeriodUnit.MONTH);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByMultipleProcessDefinitionKeyByQuarter() {
        this.testRule.deploy(this.createProcessWithUserTask("process1"), this.createProcessWithUserTask("process2"));
        DurationReportResultAssertion assertion = this.createReportScenario().periodUnit(PeriodUnit.QUARTER).startAndCompleteProcessInstance("process1", 2016, 1, 15, 10, 0).startAndCompleteProcessInstance("process2", 2016, 3, 15, 10, 0).done();
        List result = this.historyService.createHistoricProcessInstanceReport().processDefinitionKeyIn(new String[]{"process1", "process2"}).duration(PeriodUnit.QUARTER);
        this.assertThat(result).matches(assertion);
    }

    @Test
    public void testReportByInvalidProcessDefinitionKey() {
        HistoricProcessInstanceReport report = this.historyService.createHistoricProcessInstanceReport();
        try {
            report.processDefinitionKeyIn(new String[]{null});
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            report.processDefinitionKeyIn(new String[]{"abc", null, "def"});
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    protected BpmnModelInstance createProcessWithUserTask(String key) {
        return Bpmn.createExecutableProcess((String)key).startEvent().userTask().endEvent().done();
    }

    protected DurationReportScenarioBuilder createReportScenario() {
        return new DurationReportScenarioBuilder();
    }

    protected DurationReportResultAssert assertThat(List<DurationReportResult> actual) {
        return new DurationReportResultAssert(actual);
    }

    protected class DurationReportScenarioBuilder {
        protected PeriodUnit periodUnit = PeriodUnit.MONTH;
        protected DurationReportResultAssertion assertion = new DurationReportResultAssertion();

        protected DurationReportScenarioBuilder() {
        }

        public DurationReportScenarioBuilder periodUnit(PeriodUnit periodUnit) {
            this.periodUnit = periodUnit;
            this.assertion.setPeriodUnit(periodUnit);
            return this;
        }

        protected void setCurrentTime(int year, int month, int dayOfMonth, int hourOfDay, int minute) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month, dayOfMonth, hourOfDay, minute);
            ClockUtil.setCurrentTime((Date)calendar.getTime());
        }

        protected void addToCalendar(int field, int month) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(ClockUtil.getCurrentTime());
            calendar.add(field, month);
            ClockUtil.setCurrentTime((Date)calendar.getTime());
        }

        public DurationReportScenarioBuilder startAndCompleteProcessInstance(String key, int year, int month, int dayOfMonth, int hourOfDay, int minute) {
            this.setCurrentTime(year, month, dayOfMonth, hourOfDay, minute);
            ProcessInstance pi = HistoricProcessInstanceDurationReportTest.this.runtimeService.startProcessInstanceByKey(key);
            int period = month;
            if (this.periodUnit == PeriodUnit.QUARTER) {
                period = month / 3;
            }
            this.assertion.addDurationReportResult(period + 1, pi.getId());
            this.addToCalendar(2, 5);
            this.addToCalendar(13, HistoricProcessInstanceDurationReportTest.this.random.nextInt(60));
            Task task = (Task)HistoricProcessInstanceDurationReportTest.this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            HistoricProcessInstanceDurationReportTest.this.taskService.complete(task.getId());
            return this;
        }

        public DurationReportResultAssertion done() {
            return this.assertion;
        }
    }

    protected class DurationReportResultAssertion {
        protected PeriodUnit periodUnit = PeriodUnit.MONTH;
        protected Map<Integer, Set<String>> periodToProcessInstancesMap = new HashMap<Integer, Set<String>>();

        protected DurationReportResultAssertion() {
        }

        public DurationReportResultAssertion addDurationReportResult(int period, String processInstanceId) {
            Set<String> processInstances = this.periodToProcessInstancesMap.get(period);
            if (processInstances == null) {
                processInstances = new HashSet<String>();
                this.periodToProcessInstancesMap.put(period, processInstances);
            }
            processInstances.add(processInstanceId);
            return this;
        }

        public DurationReportResultAssertion setPeriodUnit(PeriodUnit periodUnit) {
            this.periodUnit = periodUnit;
            return this;
        }

        public void assertReportResults(List<DurationReportResult> actual) {
            Assert.assertEquals((String)"Report size", (long)this.periodToProcessInstancesMap.size(), (long)actual.size());
            for (DurationReportResult reportResult : actual) {
                Assert.assertEquals((String)"Period unit", (Object)this.periodUnit, (Object)reportResult.getPeriodUnit());
                int period = reportResult.getPeriod();
                Set<String> processInstancesInPeriod = this.periodToProcessInstancesMap.get(period);
                Assert.assertNotNull((String)("Unexpected report for period " + period), processInstancesInPeriod);
                List historicProcessInstances = HistoricProcessInstanceDurationReportTest.this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstancesInPeriod).finished().list();
                long max = 0L;
                long min = 0L;
                long sum = 0L;
                for (int i = 0; i < historicProcessInstances.size(); ++i) {
                    HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historicProcessInstances.get(i);
                    Long duration = historicProcessInstance.getDurationInMillis();
                    sum += duration.longValue();
                    max = i > 0 ? Math.max(max, duration) : duration;
                    min = i > 0 ? Math.min(min, duration) : duration;
                }
                long avg = sum / (long)historicProcessInstances.size();
                Assert.assertEquals((String)"maximum", (long)max, (long)reportResult.getMaximum());
                Assert.assertEquals((String)"minimum", (long)min, (long)reportResult.getMinimum());
                Assert.assertEquals((String)"average", (float)avg, (float)reportResult.getAverage(), (float)1.0f);
            }
        }
    }

    protected class DurationReportResultAssert {
        protected List<DurationReportResult> actual;

        public DurationReportResultAssert(List<DurationReportResult> actual) {
            this.actual = actual;
        }

        public void matches(DurationReportResultAssertion assertion) {
            assertion.assertReportResults(this.actual);
        }
    }
}

